/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.fragment;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.adapter.MyFragmentPagerAdapter;
import ai.botbrain.ttcloud.sdk.fragment.RecommendHomeFragment;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.ClickCategoryEvent;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.AppsListPresenter;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.LoadingView;
import ai.botbrain.ttcloud.sdk.widget.MyViewPager;
import ai.botbrain.ttcloud.sdk.widget.TsdTabLayout;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class IndexFragment
extends Fragment
implements LoadingView.OnRetryListener,
MyFragmentPagerAdapter.MyFragmentPagerAdapterCallBack,
TsdTabLayout.RenderListener {
    private RestApi restApi;
    private int tab_position = 0;
    private String currentSubColumnsId;
    private List<String> label_idList;
    private View rootView;
    private MyViewPager mViewPager;
    private TsdTabLayout mTabLayout;
    public LoadingView mLoadingView;
    private boolean isInitTop;
    private MyFragmentPagerAdapter adapter;
    public static final String ARG_FEED_TYPE = "arg_type_video";
    public static final String TYPE_ARTICLE = "article";
    public static final String TYPE_VIDEO = "video";
    private Fragment mCurrentFragment;
    public AppNameListener appNameListener;
    private TopTitleEntity.Data mData;

    public static IndexFragment newInstance(String type) {
        IndexFragment fragment = new IndexFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_FEED_TYPE, type);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static IndexFragment newInstance() {
        TsdSPUtils.remove(TsdContextHolder.getContext(), ARG_FEED_TYPE);
        return IndexFragment.newInstance(null);
    }

    public IndexFragment() {
        TsdSPUtils.remove(TsdContextHolder.getContext(), ARG_FEED_TYPE);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        ViewGroup parent;
        if (this.rootView == null) {
            this.setMyTheme();
            this.rootView = inflater.inflate(R.layout.tsd_fragment_index, container, false);
            this.initView(this.rootView);
        }
        if ((parent = (ViewGroup)this.rootView.getParent()) != null) {
            parent.removeView(this.rootView);
        }
        return this.rootView;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            String arg_type = this.getArguments().getString(ARG_FEED_TYPE);
            TsdSPUtils.put(TsdContextHolder.getContext(), ARG_FEED_TYPE, arg_type);
        }
        this.mLoadingView = new LoadingView(TsdContextHolder.getContext());
        this.restApi = new RestApiImpl();
        AppsListPresenter.upload(TsdContextHolder.getContext());
        this.initJsHttp();
        this.initData();
    }

    private void setMyTheme() {
        int i = TtCloudManager.getCurrentTheme();
        if (i == 0) {
            this.getActivity().setTheme(R.style.tsd_theme_default);
        } else if (i == 1) {
            this.getActivity().setTheme(R.style.tsd_theme_night);
        }
    }

    private void initData() {
        this.label_idList = new ArrayList<String>();
    }

    public void setAppNameListener(AppNameListener listener) {
        this.appNameListener = listener;
    }

    @Override
    public void getCurrentFragment(Fragment fragment) {
        this.mCurrentFragment = fragment;
    }

    @Override
    public void renderTabLayoutFail() {
        this.mLoadingView.notifyDataChanged(LoadingView.State.error);
    }

    @Override
    public void renderTabLayoutSuccess(TopTitleEntity.Data data, String appName) {
        this.mData = data;
        this.mLoadingView.notifyDataChanged(LoadingView.State.done);
        if (!this.isInitTop) {
            this.adapter = new MyFragmentPagerAdapter(this.getChildFragmentManager(), data);
            this.adapter.setCallBack(this);
            this.mViewPager.setAdapter((PagerAdapter)this.adapter);
            this.isInitTop = true;
        } else {
            this.adapter.notifyDataSetChanged();
        }
        if (this.appNameListener != null) {
            this.appNameListener.appName(appName);
        }
        this.mTabLayout.setupWithViewPager(this.mViewPager);
        this.initSecondaryDirectoryStatus(data);
    }

    @Override
    public void onRetry() {
        this.mTabLayout.retryRender();
    }

    private void initView(View view) {
        RelativeLayout rl_title = (RelativeLayout)view.findViewById(R.id.rl_title);
        this.mLoadingView = (LoadingView)view.findViewById(R.id.loading_view);
        this.mLoadingView.setOnRetryListener(this);
        this.mViewPager = (MyViewPager)view.findViewById(R.id.bot_news_pager);
        this.mTabLayout = (TsdTabLayout)view.findViewById(R.id.tsd_tablayout);
        this.mTabLayout.setCallBack(this);
        if (TsdContextHolder.isShowActionBar()) {
            rl_title.setVisibility(8);
        }
        this.mViewPager.setOffscreenPageLimit(10);
    }

    private void initSecondaryDirectoryStatus(TopTitleEntity.Data d) {
        List<TopTitleEntity.Columns> datas = d.columns;
        if (null == datas || datas.size() <= 0) {
            return;
        }
        for (TopTitleEntity.Columns labelData : datas) {
            List<TopTitleEntity.SubColumns> labelDatas = labelData.subColumns;
            if (null == labelDatas || labelDatas.size() <= 0) continue;
            TopTitleEntity.SubColumns data = labelDatas.get(0);
            data.isSelected = true;
        }
    }

    private void initJsHttp() {
        new Thread(){

            @Override
            public void run() {
                super.run();
                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
            }
        }.start();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(String event) {
        try {
            String[] ss = event.split("://");
            String a = ss[1].split("/")[0];
            for (int i = 0; i < this.label_idList.size(); ++i) {
                String label_id = this.label_idList.get(i);
                if (!a.equals(label_id)) continue;
                this.mViewPager.setCurrentItem(i);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getSubColumnsIdBy(int tab_position, int subColumns_position) {
        if (null == this.mData || null == this.mData.columns) {
            return;
        }
        try {
            TopTitleEntity.Columns columns = this.mData.columns.get(tab_position);
            if (null == columns.subColumns || columns.subColumns.size() <= 0) {
                return;
            }
            this.currentSubColumnsId = columns.subColumns.get((int)subColumns_position).id;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onMessageEvent(ClickCategoryEvent event) {
        int position = event.position;
        this.getSubColumnsIdBy(this.tab_position, position);
        if (null != this.mCurrentFragment && this.mCurrentFragment instanceof RecommendHomeFragment) {
            ((RecommendHomeFragment)this.mCurrentFragment).refresh(position);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onMessageEvent(BuriedPointEvent event) {
        if (null == this.mData || null == this.mData.columns) {
            return;
        }
        String columns_id = this.mData.columns.get((int)this.tab_position).id;
        String iid = event.getIid();
        Object alg = event.getAlg();
        String action = event.getAction();
        String num = event.getNum();
        this.currentSubColumnsId = null == this.currentSubColumnsId ? "" : this.currentSubColumnsId;
        this.restApi.commentToService(iid, alg, action, columns_id + "_" + this.currentSubColumnsId, num, null);
    }

    public void onStart() {
        super.onStart();
        EventBus.getDefault().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        EventBus.getDefault().unregister((Object)this);
    }

    public void onResume() {
        super.onResume();
        this.mTabLayout.onResume();
    }

    public static interface AppNameListener {
        public void appName(String var1);
    }
}

