/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.disLike;

import ai.botbrain.ttcloud.sdk.R;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

public class FitPopupWindowLayout
extends RelativeLayout {
    public static final int UP = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int DOWN = 4;
    private int mHorizontal = 3;
    private int mVertical = 4;
    private Paint mPaint;
    public static final int SHARP_WIDTH = 50;
    public static final int SHARP_HEIGHT = 50;
    private static final int RECT_CORNER = 20;
    private int mXoffset = 20;
    private Path mPath = new Path();
    private Path mSharpPath = new Path();

    public FitPopupWindowLayout(Context context) {
        this(context, null);
    }

    public FitPopupWindowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FitPopupWindowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundColor(0);
        this.mPaint = new Paint();
        this.mPaint.setColor(context.getResources().getColor(R.color.tsd_color_dislike_bg));
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
    }

    private Path makeSharpPath() {
        this.mSharpPath.moveTo((float)this.mXoffset, (float)(this.getMeasuredHeight() - 50));
        this.mSharpPath.cubicTo((float)this.mXoffset, (float)this.getMeasuredHeight(), (float)this.mXoffset, (float)(this.getMeasuredHeight() - 50), (float)(50 + this.mXoffset), (float)(this.getMeasuredHeight() - 50));
        return this.mSharpPath;
    }

    protected void onDraw(Canvas canvas) {
        this.mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)(this.getMeasuredHeight() - 50)), 20.0f, 20.0f, Path.Direction.CW);
        this.mPath.addPath(this.makeSharpPath());
        canvas.drawPath(this.mPath, this.mPaint);
        if (this.mHorizontal == 3 && this.mVertical == 1) {
            this.setScaleX(1.0f);
            this.setScaleY(1.0f);
        } else if (this.mHorizontal == 3 && this.mVertical == 4) {
            this.setScaleX(1.0f);
            this.setScaleY(-1.0f);
            this.scaleChild(1.0f, -1.0f);
        } else if (this.mHorizontal == 2 && this.mVertical == 1) {
            this.setScaleX(-1.0f);
            this.setScaleY(1.0f);
            this.scaleChild(-1.0f, 1.0f);
        } else if (this.mHorizontal == 2 && this.mVertical == 4) {
            this.setScaleX(-1.0f);
            this.setScaleY(-1.0f);
            this.scaleChild(-1.0f, -1.0f);
        }
    }

    private void scaleChild(float scaleX, float scaleY) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setScaleX(scaleX);
            this.getChildAt(i).setScaleY(scaleY);
        }
    }

    public void setOrientation(int horizontal, int vertical, int xOffset) {
        this.mHorizontal = horizontal;
        this.mVertical = vertical;
        this.mXoffset = xOffset;
        this.invalidate();
    }
}

