/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.adapter;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class TvAdapter2
extends BaseAdapter {
    private Context mContext;
    private RecommendEntity.Data2 mData;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    public TvAdapter2(Context context, RecommendEntity.Data2 data) {
        this.mContext = context;
        this.mData = data;
    }

    public int getCount() {
        List<RecommendEntity.Episodes> episodesList = this.mData.episodes;
        return null == episodesList ? 0 : episodesList.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_tv, null);
            viewHolder.btnNum = (Button)convertView.findViewById(R.id.btn_num);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        final String channel = null == this.mData.channel ? "" : this.mData.channel;
        final String iid = null == this.mData.iid ? "" : this.mData.iid;
        final String alg = null == this.mData.alg ? "" : this.mData.alg;
        final List<RecommendEntity.Episodes> episodesList = this.mData.episodes;
        RecommendEntity.Episodes entity = episodesList.get(position);
        final String num_text = this.getbtnNumText(entity, channel);
        boolean is_free = entity.sources.get((int)0).is_free;
        viewHolder.btnNum.setText((CharSequence)num_text);
        if (is_free) {
            viewHolder.btnNum.setTextColor(this.mContext.getResources().getColor(R.color.tsd_black));
        } else {
            viewHolder.btnNum.setTextColor(this.mContext.getResources().getColor(R.color.tsd_gray));
        }
        viewHolder.btnNum.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FireDataManager.clickCsn(channel, ((TvAdapter2)TvAdapter2.this).mData.title, iid, num_text);
                if (((RecommendEntity.Episodes)episodesList.get((int)position)).sources.get((int)0).is_free) {
                    final String url = ((RecommendEntity.Episodes)episodesList.get((int)position)).sources.get((int)0).url;
                    EventBus.getDefault().post((Object)new BuriedPointEvent("click", iid, alg, null, num_text));
                    if (JsPresenter.getInstance().isEmpty()) {
                        new Thread(){

                            @Override
                            public void run() {
                                super.run();
                                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
                                TvAdapter2.this.mainHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        FireDataManager.play(((TvAdapter2)TvAdapter2.this).mData.channel);
                                        JsPresenter.getInstance().StartPlayback(TvAdapter2.this.mContext, url, ((TvAdapter2)TvAdapter2.this).mData.title, iid);
                                    }
                                });
                            }
                        }.start();
                    } else {
                        FireDataManager.play(((TvAdapter2)TvAdapter2.this).mData.channel);
                        JsPresenter.getInstance().StartPlayback(TvAdapter2.this.mContext, url, ((TvAdapter2)TvAdapter2.this).mData.title, iid);
                    }
                }
            }
        });
        return convertView;
    }

    private String getbtnNumText(RecommendEntity.Episodes entity, String channel) {
        String s;
        if (!channel.equals("\u7efc\u827a")) {
            s = entity.episode;
        } else {
            String text = entity.episode;
            String str1 = text.substring(0, 4);
            String str2 = text.substring(4, 6);
            String str3 = text.substring(6, 8);
            s = str1 + "-" + str2 + "-" + str3;
        }
        return s;
    }

    private static class ViewHolder {
        private Button btnNum;

        private ViewHolder() {
        }
    }
}

