/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.adapter;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.adapter.TsdBaseAdapter;
import ai.botbrain.ttcloud.sdk.disLike.FitPopupUtil;
import ai.botbrain.ttcloud.sdk.model.AdEntity;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.DislikeEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.AdManager;
import ai.botbrain.ttcloud.sdk.util.AdQqManager;
import ai.botbrain.ttcloud.sdk.util.CommonUtil;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.qq.e.ads.nativ.NativeMediaAD;
import com.qq.e.ads.nativ.NativeMediaADData;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class GraphicAdapter
extends TsdBaseAdapter
implements NativeMediaAD.NativeMediaADListener {
    private static final String TAG = GraphicAdapter.class.getSimpleName();
    private static final int TYPE_NO_PIC = 0;
    private static final int TYPE_ONE_SMALL = 1;
    private static final int TYPE_ONE_BIG = 2;
    private static final int TYPE_THREE_PIC = 3;
    private static final int TYPE_QQ_AD = 4;
    private static final int TYPE_SEE_HERE = 5;
    private static final int TYPE_COUNT = 6;
    private RestApi restApi;
    private List<RecommendEntity.Data> mData;
    private TopTitleEntity.Columns mColumns;
    private Context mContext;
    private NotiListener mNotiListener;

    public GraphicAdapter(Context context, TopTitleEntity.Columns columns, List<RecommendEntity.Data> data) {
        this.mContext = context;
        this.mData = data;
        this.mColumns = columns;
        this.restApi = new RestApiImpl();
    }

    private String getCompose() {
        return null == this.mColumns.compose ? "" : this.mColumns.compose;
    }

    @Override
    public int getCount() {
        return null == this.mData ? 0 : this.mData.size();
    }

    @Override
    public Object getItem(int position) {
        return this.mData.get(position);
    }

    @Override
    public long getItemId(int i) {
        return 0L;
    }

    public int getViewTypeCount() {
        return 6;
    }

    public int getItemViewType(int position) {
        RecommendEntity.Data data = this.mData.get(position);
        String type = data.type;
        if (type.equals("ad") && data.data.src.equals("qq.e")) {
            return 4;
        }
        if (this.getType(position).equals("feed")) {
            return this.getFeedType(position);
        }
        if (this.getType(position).equals("seeHere")) {
            return 5;
        }
        return 0;
    }

    private String getType(int position) {
        RecommendEntity.Data data = this.mData.get(position);
        return data.type;
    }

    private boolean checkImgIsNull(RecommendEntity.Data2 data2) {
        return null == data2.images || data2.images.length == 0;
    }

    private int getFeedType(int position) {
        String view_img_type;
        RecommendEntity.Data data = this.mData.get(position);
        RecommendEntity.Data2 data2 = data.data;
        String[] imgs = data2.images;
        String coverUrl = data2.cover_url;
        String string2 = view_img_type = null == data2.view_img_type ? "" : data2.view_img_type;
        if (TextUtils.isEmpty((CharSequence)coverUrl) && this.checkImgIsNull(data2)) {
            return 0;
        }
        if (this.getCompose().equals("2")) {
            return 1;
        }
        if (this.getCompose().equals("3")) {
            return 2;
        }
        if (view_img_type.equals("1") && !TextUtils.isEmpty((CharSequence)coverUrl)) {
            return 2;
        }
        if (view_img_type.equals("2")) {
            return 1;
        }
        if (view_img_type.equals("3")) {
            return 3;
        }
        if (!TextUtils.isEmpty((CharSequence)coverUrl)) {
            return 2;
        }
        if (TextUtils.isEmpty((CharSequence)coverUrl) && null != imgs && imgs.length == 0) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)coverUrl) && null != imgs && imgs.length == 1) {
            return 1;
        }
        if (TextUtils.isEmpty((CharSequence)coverUrl) && null != imgs && imgs.length >= 3) {
            return 3;
        }
        return 0;
    }

    private void initViewDisLike(View convertView, ViewHolder viewHolder) {
        viewHolder.iv_dislike = (ImageView)convertView.findViewById(R.id.iv_dislike);
        viewHolder.iv_dislike.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int position2 = (Integer)v.getTag();
                GraphicAdapter.this.initPopup(v, position2);
            }
        });
    }

    private void initViewCommon(View convertView, ViewHolder viewHolder) {
        viewHolder.mTitle = (TextView)convertView.findViewById(R.id.item_title);
        viewHolder.mSource = (TextView)convertView.findViewById(R.id.item_source);
        viewHolder.tsd_tv_stickied = (TextView)convertView.findViewById(R.id.tsd_tv_stickied);
        viewHolder.tsd_article_divider = convertView.findViewById(R.id.tsd_article_divider);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        int type = this.getItemViewType(position);
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            switch (type) {
                case 5: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_see_here, null);
                    break;
                }
                case 0: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_article_plain, null);
                    this.initViewDisLike(convertView, viewHolder);
                    this.initViewCommon(convertView, viewHolder);
                    break;
                }
                case 1: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_article_small, null);
                    viewHolder.mRightImage = (ImageView)convertView.findViewById(R.id.right_image);
                    this.initViewDisLike(convertView, viewHolder);
                    this.initViewCommon(convertView, viewHolder);
                    break;
                }
                case 3: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_article_multi_pics, null);
                    viewHolder.mImageLeft = (ImageView)convertView.findViewById(R.id.left_image);
                    viewHolder.mImageMid = (ImageView)convertView.findViewById(R.id.mid_image);
                    viewHolder.mImageRight = (ImageView)convertView.findViewById(R.id.right_image);
                    this.initViewDisLike(convertView, viewHolder);
                    this.initViewCommon(convertView, viewHolder);
                    break;
                }
                case 2: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_article_big_pic, null);
                    viewHolder.mBigImage = (ImageView)convertView.findViewById(R.id.big_image);
                    this.initViewDisLike(convertView, viewHolder);
                    this.initViewCommon(convertView, viewHolder);
                    break;
                }
                case 4: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_qq_ad2, null);
                    viewHolder.adInfoContainer = (LinearLayout)convertView.findViewById(R.id.ad_info);
                    viewHolder.logo = (ImageView)convertView.findViewById(R.id.img_logo);
                    viewHolder.poster = (ImageView)convertView.findViewById(R.id.img_poster);
                    viewHolder.name = (TextView)convertView.findViewById(R.id.text_title);
                    viewHolder.desc = (TextView)convertView.findViewById(R.id.text_desc);
                    viewHolder.download = (Button)convertView.findViewById(R.id.btn_download);
                    this.initViewCommon(convertView, viewHolder);
                }
            }
            if (null != convertView) {
                convertView.setTag((Object)viewHolder);
            }
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        if (type == 4) {
            this.renderQqAd(viewHolder, position, convertView);
        } else if (type == 3 || type == 0 || type == 1 || type == 2) {
            String flag;
            viewHolder.iv_dislike.setTag((Object)position);
            viewHolder.mTitle.setTextSize((float)TsdContextHolder.getFont_size());
            RecommendEntity.Data data = this.mData.get(position);
            RecommendEntity.Data2 data2 = data.data;
            if (data2 == null) {
                return convertView;
            }
            boolean has_read = data2.has_read;
            String channel = data2.channel == null ? "" : data2.channel;
            String coverUrl = data2.cover_url == null ? "" : data2.cover_url;
            String[] images = data2.images;
            String string2 = flag = data.flag == null ? "" : data.flag;
            if (flag.equals("top")) {
                viewHolder.tsd_tv_stickied.setVisibility(0);
            } else {
                viewHolder.tsd_tv_stickied.setVisibility(8);
            }
            viewHolder.mTitle.setText((CharSequence)data2.title);
            viewHolder.mSource.setText((CharSequence)channel);
            if (type == 2) {
                Glide.with((Context)this.mContext).load((Object)coverUrl).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mBigImage);
            } else if (type == 1) {
                String img = null == images[0] ? "" : images[0];
                Glide.with((Context)this.mContext).load((Object)img).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mRightImage);
            } else if (type == 3) {
                String image0 = null == images[0] ? "" : images[0];
                String image1 = null == images[1] ? "" : images[1];
                String image2 = null == images[2] ? "" : images[2];
                RequestManager manager = Glide.with((Context)this.mContext).setDefaultRequestOptions(this.options_common);
                RequestBuilder builder = manager.load((Object)image0).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250));
                builder.into(viewHolder.mImageLeft);
                Glide.with((Context)this.mContext).applyDefaultRequestOptions(this.options_common).load((Object)image1).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mImageMid);
                Glide.with((Context)this.mContext).load((Object)image2).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(250)).into(viewHolder.mImageRight);
            }
            if (position + 1 < this.mData.size()) {
                RecommendEntity.Data data22 = this.mData.get(position + 1);
                if (data22.type.equals("seeHere")) {
                    viewHolder.tsd_article_divider.setVisibility(8);
                } else {
                    viewHolder.tsd_article_divider.setVisibility(0);
                }
            }
        }
        return convertView;
    }

    private void fetchQqAd(final RecommendEntity.Data2 data2) {
        String adPlaceId = data2.appid;
        String nativeVideoPosID = data2.nativevideoposid;
        NativeMediaAD mediaAD = new NativeMediaAD(TsdContextHolder.getContext(), adPlaceId, nativeVideoPosID, new NativeMediaAD.NativeMediaADListener(){

            public void onADLoaded(List<NativeMediaADData> list) {
                if (null != list && list.size() > 0) {
                    data2.nativeMediaADData = list.get(0);
                    if (null != GraphicAdapter.this.mNotiListener) {
                        GraphicAdapter.this.mNotiListener.notifyData();
                    }
                }
            }

            public void onNoAD(int errorCode) {
                LogUtil.i(TAG, "\u52a0\u8f7d\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errorCode);
                CommonUtil.clearAppidQ(GraphicAdapter.this.mContext.getApplicationContext());
            }

            public void onADStatusChanged(NativeMediaADData nativeMediaADData) {
            }

            public void onADError(NativeMediaADData nativeMediaADData, int i) {
            }

            public void onADVideoLoaded(NativeMediaADData nativeMediaADData) {
            }

            public void onADExposure(NativeMediaADData nativeMediaADData) {
                GraphicAdapter.this.adExposure(nativeMediaADData);
            }

            public void onADClicked(NativeMediaADData nativeMediaADData) {
                GraphicAdapter.this.adClick(nativeMediaADData);
            }
        });
        mediaAD.loadAD(1);
    }

    private void renderQqAd(ViewHolder viewHolder, int position, View convertView) {
        viewHolder.poster.setVisibility(0);
        RecommendEntity.Data data = this.mData.get(position);
        RecommendEntity.Data2 data2 = data.data;
        final NativeMediaADData ad = data2.nativeMediaADData;
        if (null == ad) {
            this.fetchQqAd(data2);
        }
        String ad_img = null == ad ? "" : ad.getImgUrl();
        String title = null == ad ? "" : ad.getTitle();
        String iconUrl = null == ad ? "" : ad.getIconUrl();
        String desc = null == ad ? "" : ad.getDesc();
        viewHolder.name.setText((CharSequence)title);
        viewHolder.desc.setText((CharSequence)desc);
        Glide.with((Context)this.mContext).load((Object)ad_img).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.poster);
        Glide.with((Context)this.mContext).load((Object)(TextUtils.isEmpty((CharSequence)iconUrl) ? ad_img : iconUrl)).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into(viewHolder.logo);
        viewHolder.download.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != ad) {
                    ad.onClicked(v);
                }
            }
        });
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (null == ad) {
                    return;
                }
                FireDataManager.qqAdClick(ad);
                ad.onClicked(view);
                AdEntity adEntity = new AdEntity();
                adEntity.setDes(ad.getDesc());
                adEntity.setSrc("qq.e");
                adEntity.setTitle(ad.getTitle());
                String params = GsonUtil.GsonString(adEntity);
                GraphicAdapter.this.restApi.adClickHttp(params);
            }
        });
        AdQqManager.renderDownLoadView(viewHolder.download, ad);
        if (null != ad) {
            ad.onExposured((View)viewHolder.adInfoContainer);
        }
    }

    public void onADLoaded(List<NativeMediaADData> list) {
        LogUtil.i(TAG, "\u6210\u529f\u52a0\u8f7d\u539f\u751f\u5e7f\u544a\uff1a" + list.size() + "\u6761");
        AdManager.setMediaADDataHashMap(list);
    }

    public void onNoAD(int errorCode) {
        LogUtil.i(TAG, "\u52a0\u8f7d\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errorCode);
        Toast.makeText((Context)this.mContext.getApplicationContext(), (CharSequence)("\u52a0\u8f7d\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errorCode), (int)0).show();
    }

    public void onADStatusChanged(NativeMediaADData nativeMediaADData) {
    }

    public void onADError(NativeMediaADData nativeMediaADData, int errorCode) {
        LogUtil.i(TAG, "onADError: " + errorCode);
    }

    public void onADVideoLoaded(NativeMediaADData adData) {
        Log.i((String)TAG, (String)(adData.getTitle() + " ---> \u89c6\u9891\u52a0\u8f7d\u5b8c\u6210"));
    }

    public void onADExposure(NativeMediaADData adData) {
        Log.i((String)TAG, (String)(adData.getTitle() + " onADExposure"));
    }

    public void onADClicked(NativeMediaADData adData) {
        Log.i((String)TAG, (String)(adData.getTitle() + " onADClicked"));
    }

    private void initPopup(View anchorView, final int position) {
        FitPopupUtil fitPopupUtil = new FitPopupUtil((Activity)this.mContext);
        fitPopupUtil.setOnClickListener(new FitPopupUtil.OnCommitClickListener(){

            @Override
            public void onClick(String reason) {
                RecommendEntity.Data data = (RecommendEntity.Data)GraphicAdapter.this.mData.get(position);
                RecommendEntity.Data2 data2 = data.data;
                String iid = null == data2.iid ? "" : data2.iid;
                EventBus.getDefault().post((Object)new BuriedPointEvent("dislike", iid, null, null, null));
                EventBus.getDefault().post((Object)new DislikeEvent(position, GraphicAdapter.this));
            }
        });
        fitPopupUtil.showPopup(anchorView);
    }

    private void adClick(NativeMediaADData ad) {
        LogUtil.i(TAG, ad.getTitle() + " onADClicked");
        AdEntity adEntity = new AdEntity();
        adEntity.setDes(ad.getDesc());
        adEntity.setSrc("qq.e");
        adEntity.setTitle(ad.getTitle());
        String params = GsonUtil.GsonString(adEntity);
        this.restApi.adClickHttp(params);
        FireDataManager.qqAdClick(ad);
    }

    private void adExposure(NativeMediaADData nativeMediaADData) {
        LogUtil.i(TAG, nativeMediaADData.getTitle() + " onADExposure");
        AdEntity adEntity = new AdEntity();
        adEntity.setDes(nativeMediaADData.getDesc());
        adEntity.setSrc("qq.e");
        adEntity.setTitle(nativeMediaADData.getTitle());
        String params = GsonUtil.GsonString(adEntity);
        EventBus.getDefault().post((Object)new BuriedPointEvent("adshow", null, null, params, null));
        FireDataManager.qqAdShow(nativeMediaADData);
    }

    public void setNotiListener(NotiListener notiListener) {
        this.mNotiListener = notiListener;
    }

    public static interface NotiListener {
        public void notifyData();
    }

    private static class ViewHolder {
        private TextView name;
        private TextView desc;
        private TextView mTitle;
        private TextView mSource;
        private TextView tsd_tv_stickied;
        private ImageView mImageLeft;
        private ImageView iv_dislike;
        private ImageView mImageMid;
        private ImageView mImageRight;
        private ImageView mBigImage;
        private ImageView mRightImage;
        private LinearLayout adInfoContainer;
        private ImageView logo;
        private ImageView poster;
        private Button download;
        private View tsd_article_divider;

        private ViewHolder() {
        }
    }
}

