/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.activity;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TsdChoiceLikeActivity
extends Activity
implements View.OnClickListener {
    private TopTitleEntity.ColdStart mColdStart;
    private String mAppName;
    private Button btn_ok;
    private TextView tv_title;
    private TextView ttc_tv_title;
    private List<Button> buttons;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.tsd_activity_choice_like);
        this.initVariables();
        this.buttons = new ArrayList<Button>();
        this.initView();
        this.init();
    }

    private void initVariables() {
        Intent intnet = this.getIntent();
        this.mColdStart = (TopTitleEntity.ColdStart)intnet.getSerializableExtra("ACTION_COLDSTART");
        this.mAppName = intnet.getStringExtra("ACTION_APP_NAME");
    }

    private void init() {
        this.ttc_tv_title.setText((CharSequence)this.mAppName);
        if (null == this.mColdStart) {
            return;
        }
        this.setTitle();
        this.setBtn();
        this.setLabel();
    }

    private void setLabel() {
        try {
            ArrayList<Map> map = this.mColdStart.tags;
            for (int i = 0; i < map.size(); ++i) {
                LinkedHashMap linkedTreeMap = (LinkedHashMap)map.get(i);
                String label = (String)linkedTreeMap.get("label");
                this.buttons.get(i).setVisibility(0);
                this.buttons.get(i).setText((CharSequence)label);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTitle() {
        String custom = null == this.mColdStart.custom ? "" : this.mColdStart.custom;
        this.tv_title.setText((CharSequence)custom);
    }

    private void setBtn() {
        String confirm = null == this.mColdStart.confirm ? "" : this.mColdStart.confirm;
        this.btn_ok.setText((CharSequence)confirm);
    }

    private void initView() {
        Button btn_0 = (Button)this.findViewById(R.id.btn_0);
        Button btn_1 = (Button)this.findViewById(R.id.btn_1);
        Button btn_2 = (Button)this.findViewById(R.id.btn_2);
        Button btn_3 = (Button)this.findViewById(R.id.btn_3);
        Button btn_4 = (Button)this.findViewById(R.id.btn_4);
        Button btn_5 = (Button)this.findViewById(R.id.btn_5);
        Button btn_6 = (Button)this.findViewById(R.id.btn_6);
        Button btn_7 = (Button)this.findViewById(R.id.btn_7);
        Button btn_8 = (Button)this.findViewById(R.id.btn_8);
        Button btn_9 = (Button)this.findViewById(R.id.btn_9);
        this.btn_ok = (Button)this.findViewById(R.id.btn_ok);
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        Button btn_skip = (Button)this.findViewById(R.id.btn_skip);
        this.ttc_tv_title = (TextView)this.findViewById(R.id.ttc_tv_title);
        this.buttons.add(btn_0);
        this.buttons.add(btn_1);
        this.buttons.add(btn_2);
        this.buttons.add(btn_3);
        this.buttons.add(btn_4);
        this.buttons.add(btn_5);
        this.buttons.add(btn_6);
        this.buttons.add(btn_7);
        this.buttons.add(btn_8);
        this.buttons.add(btn_9);
        for (Button btn : this.buttons) {
            btn.setOnClickListener((View.OnClickListener)this);
        }
        btn_skip.setOnClickListener((View.OnClickListener)this);
        this.btn_ok.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v instanceof Button && this.buttons.contains(v)) {
            v.setSelected(!v.isSelected());
            this.setBtnOkColor();
            return;
        }
        if (v.getId() == R.id.btn_skip) {
            this.finish();
            return;
        }
        if (v.getId() == R.id.btn_ok && this.btn_ok.isSelected()) {
            this.http();
        }
    }

    private void http() {
        ArrayList list = new ArrayList();
        try {
            ArrayList<Map> map = this.mColdStart.tags;
            for (int i = 0; i < map.size(); ++i) {
                LinkedHashMap linkedTreeMap = (LinkedHashMap)map.get(i);
                Object o = linkedTreeMap.get("topic");
                if (!this.buttons.get(i).isSelected() || null == o) continue;
                list.add(o);
            }
            String ext = GsonUtil.GsonString(list);
            new RestApiImpl().coldStartHttp("coldstart", ext);
            this.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBtnOkColor() {
        this.btn_ok.setSelected(false);
        for (Button btn : this.buttons) {
            if (!btn.isSelected()) continue;
            this.btn_ok.setSelected(true);
        }
    }
}

