/*
 * Decompiled with CFR 0.152.
 */
package com.firedata.sdk;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.WebView;
import com.firedata.sdk.FiredataJsInterface;
import com.firedata.sdk.Props;
import com.firedata.sdk.Tracker;
import com.firedata.sdk.tools.Logy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class Firedata {
    public static final String TAG = "com.firedata.sdk";
    private static Context context;

    public static void init(Context context) {
        Firedata.init(context, null, null);
    }

    public static void init(Context context, String appKey, String channel) {
        if (context == null) {
            Logy.e(TAG, "Argument context cannot be null in initialize()");
            throw new NullPointerException("Argument context cannot be null");
        }
        Firedata.context = context;
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            appKey = Firedata.getMetaData("firedata_appkey");
        }
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            throw new NullPointerException("appKey\u4e0d\u80fd\u4e3a\u7a7a, \u4f20\u5165appKey, \u6216\u8005\u5728Manifest\u4e2d\u8bbe\u7f6e\uff1afiredata_appkey");
        }
        if (TextUtils.isEmpty((CharSequence)channel)) {
            channel = Firedata.getMetaData("firedata_channel");
        }
        Tracker.getInstance().init(context, appKey, channel);
    }

    public static void onLogin(String userId, Map<String, Object> userInfo) {
        Tracker.getInstance().setUserId(userId).setUserVars(userInfo);
        Tracker.getInstance().logEvent("/user", "login", Props.eventProps("userId", userId));
    }

    public static void onLogout() {
        String userId = Tracker.getInstance().getUserId();
        Tracker.getInstance().logEvent("/user", "logout", Props.eventProps("userId", userId == null ? "" : userId));
        Tracker.getInstance().setUserId("").setUserVars(null);
    }

    public static void setUserInfo(String key, Object value) {
        Map<String, Object> vars = Tracker.getInstance().getUserVars();
        vars.put(key, value);
        Tracker.getInstance().setUserVars(vars);
    }

    public static void setABTest(String ab) {
        Tracker.getInstance().setABTest(ab);
    }

    public static void removeUserInfo(String key) {
        Map<String, Object> vars = Tracker.getInstance().getUserVars();
        vars.remove(key);
        Tracker.getInstance().setUserVars(vars);
    }

    public static String getUserId() {
        return Tracker.getInstance().getUserId();
    }

    public static String getGuid() {
        return Tracker.getInstance().getGuid();
    }

    public static Object getConfigParam(String key, Object defaultVal) {
        return Tracker.getInstance().getConfigParam(key, defaultVal);
    }

    public static void setDebug(boolean debug) {
        Tracker.getInstance().setDebug(debug);
        Logy.setDebug(debug);
    }

    @TargetApi(value=14)
    public static void enableForegroundTracking(Application app) {
        Tracker.getInstance().enableForegroundTracking(app);
    }

    public static void pageViewStart(String pageName) {
        Firedata.pageViewStart(pageName, null);
    }

    public static void pageViewStart(String pageName, Props props) {
        Tracker.getInstance().pageViewStart(pageName, props);
    }

    public static void pageViewEnd(String pageName) {
        Tracker.getInstance().pageViewEnd(pageName);
    }

    public static void event(String category, String action) {
        Tracker.getInstance().logEvent(category, action);
    }

    public static void event(String category, String action, Props props) {
        Tracker.getInstance().logEvent(category, action, props);
    }

    public static void event(String category, String action, Map<String, Object> props) {
        Tracker.getInstance().logEvent(category, action, Props.eventProps(props));
    }

    public static synchronized void enableCrashReporting() {
        final Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Tracker.getInstance().logEventSync("/error", "crash", Props.eventProps("stack", sw.toString()));
                Tracker.getInstance().uploadEvents();
                if (oldHandler != null) {
                    oldHandler.uncaughtException(t, e);
                }
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    public static void exception(Throwable e, String msg) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        Props props = Props.eventProps("stack", sw.toString()).event("class", e.getClass().getName()).event("msg", msg);
        Tracker.getInstance().logEventSync("/error", "exception", props);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    @TargetApi(value=17)
    public static void bindWebview(WebView webView, String catPrefix, Props props) {
        if (Build.VERSION.SDK_INT >= 17) {
            FiredataJsInterface js = new FiredataJsInterface(Tracker.getInstance(), catPrefix);
            if (props != null) {
                js.setExtraProps(props);
            }
            webView.getSettings().setJavaScriptEnabled(true);
            webView.addJavascriptInterface((Object)js, "FiredataAPP");
        } else {
            Logy.w(TAG, "Android 4.2 \u4ee5\u4e0a\u7248\u672c\u6709\u6548\uff0c API >= 17");
        }
    }

    static String getMetaData(String name) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData == null) {
                return null;
            }
            return appInfo.metaData.getString(name);
        }
        catch (Exception localException) {
            Logy.e(TAG, localException.toString());
            return null;
        }
    }

    public static Map<String, Object> toMap(String ... kvs) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        for (int i = 0; i < kvs.length; i += 2) {
            infos.put(kvs[i], kvs[i + 1]);
        }
        return infos;
    }
}

