/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.util;

import android.content.Context;
import cn.com.mma.mobile.tracking.api.Constant;
import cn.com.mma.mobile.tracking.bean.SDK;
import cn.com.mma.mobile.tracking.util.CommonUtil;
import cn.com.mma.mobile.tracking.util.ConnectUtil;
import cn.com.mma.mobile.tracking.util.DeviceInfoUtil;
import cn.com.mma.mobile.tracking.util.Logger;
import cn.com.mma.mobile.tracking.util.SharedPreferencedUtil;
import cn.com.mma.mobile.tracking.util.XmlUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class SdkConfigUpdateUtil {
    private static SDK sdk = null;

    public static void initSdkConfigResult(final Context context, final String configUrl) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                sdk = SdkConfigUpdateUtil.getNewestSDK(context, configUrl);
                if (sdk != null) {
                    SdkConfigUpdateUtil.setSdk(sdk);
                }
            }
        }).start();
    }

    private static SDK getNewestSDK(Context context, String configUrl) {
        SDK sdkNewest;
        if (configUrl == null || configUrl.length() <= 0) {
            return null;
        }
        if (SdkConfigUpdateUtil.JudgeUpdateAccordingDate(context)) {
            sdkNewest = SdkConfigUpdateUtil.dealUpdateConfig(context, configUrl);
            if (sdkNewest == null) {
                sdkNewest = SdkConfigUpdateUtil.getSDKFromPreferences(context);
            }
        } else {
            sdkNewest = SdkConfigUpdateUtil.getSDKFromPreferences(context);
            if (sdkNewest == null) {
                sdkNewest = SdkConfigUpdateUtil.dealUpdateConfig(context, configUrl);
            }
        }
        return sdkNewest;
    }

    private static boolean JudgeUpdateAccordingDate(Context context) {
        boolean result = true;
        long currentTime = System.currentTimeMillis();
        long lastUpdateTime = SharedPreferencedUtil.getLong(context, "cn.com.mma.mobile.tracking.other", "updateTime");
        Logger.d("mma_config lastUpdateTimeStamp:" + lastUpdateTime);
        Logger.d("mma_config wifi:" + CommonUtil.isWifiConnected(context) + " | " + (currentTime - lastUpdateTime >= 86400000L));
        Logger.d("mma_config mobile:" + CommonUtil.isMobileConnected(context) + " | " + (currentTime - lastUpdateTime >= 259200000L));
        if (currentTime < lastUpdateTime) {
            SharedPreferencedUtil.putLong(context, "cn.com.mma.mobile.tracking.other", "updateTime", currentTime);
            return false;
        }
        boolean isWifiUpdate = CommonUtil.isWifiConnected(context) && currentTime - lastUpdateTime >= 86400000L;
        boolean isMobileUpdate = CommonUtil.isMobileConnected(context) && currentTime - lastUpdateTime >= 259200000L;
        result = isWifiUpdate || isMobileUpdate;
        Logger.d("mma_config File need Update\uff1a" + result);
        return result;
    }

    public static SDK dealUpdateConfig(Context context, String configUrl) {
        if (!DeviceInfoUtil.isNetworkAvailable(context)) {
            return null;
        }
        SDK sdk = null;
        ConnectUtil util = ConnectUtil.getInstance();
        String response = util.get(configUrl);
        if (response != null) {
            try {
                sdk = XmlUtil.doParser(new ByteArrayInputStream(response.getBytes("UTF-8")));
                if (sdk != null && sdk.companies != null && sdk.companies.size() > 0) {
                    SharedPreferencedUtil.putString(context, "cn.com.mma.mobile.tracking.sdkconfig", "trackingConfig", response);
                    SharedPreferencedUtil.putLong(context, "cn.com.mma.mobile.tracking.other", "updateTime", System.currentTimeMillis());
                    Logger.d("mma_\u7f51\u7edc\u66f4\u65b0sdkconfig.xml\u6210\u529f");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sdk;
    }

    public static SDK getSDKFromPreferences(Context context) {
        try {
            String valueString = SharedPreferencedUtil.getString(context, "cn.com.mma.mobile.tracking.sdkconfig", "trackingConfig");
            InputStream is = null;
            try {
                is = valueString != null && valueString.length() > 0 ? new ByteArrayInputStream(valueString.getBytes()) : context.getAssets().open("sdkconfig.xml");
            }
            catch (Exception e) {
                is = null;
            }
            return is != null ? XmlUtil.doParser(is) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getConfigFromNetWork(String configUrl) {
        if (configUrl == null) {
            return null;
        }
        try {
            URL url = new URL(configUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(10000);
            urlConnection.connect();
            InputStream inputStream = urlConnection.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            inputStream.close();
            return buffer.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setSdk(SDK sdk) {
        Logger.d("mma_setSdk");
        if (sdk != null) {
            try {
                if (sdk.offlineCache != null) {
                    if (sdk.offlineCache.length != null && !"".equals(sdk.offlineCache.length)) {
                        Constant.OFFLINECACHE_LENGTH = Integer.parseInt(sdk.offlineCache.length);
                    }
                    if (sdk.offlineCache.queueExpirationSecs != null && !"".equals(sdk.offlineCache.queueExpirationSecs)) {
                        Constant.OFFLINECACHE_QUEUEEXPIRATIONSECS = Integer.parseInt(sdk.offlineCache.queueExpirationSecs);
                    }
                    if (sdk.offlineCache.timeout != null && !"".equals(sdk.offlineCache.timeout)) {
                        Constant.OFFLINECACHE_TIMEOUT = Integer.parseInt(sdk.offlineCache.timeout);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static SDK getSdk(Context context) {
        if (sdk == null || SdkConfigUpdateUtil.sdk.companies == null) {
            sdk = SdkConfigUpdateUtil.getSDKFromPreferences(context);
            SdkConfigUpdateUtil.setSdk(sdk);
        }
        return sdk;
    }
}

