/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import cn.com.mma.mobile.tracking.bean.Argument;
import cn.com.mma.mobile.tracking.bean.Company;
import cn.com.mma.mobile.tracking.util.Logger;
import cn.mmachina.JniClient;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtil {
    public static String removeExistEvent(String url, List<String> requiredEventValue, String separator, String equalizer) {
        for (String value : requiredEventValue) {
            if (!url.contains(String.valueOf(separator) + value)) continue;
            Logger.d("mma_" + separator + value + equalizer + "[^" + separator + "]*");
            url = url.replaceAll(String.valueOf(separator) + value + equalizer + "[^" + separator + "]*", "");
        }
        return url;
    }

    public static Map removeExistArgmentAndGetRedirectURL(String url, List<String> requiredArgmentValue, String separator, String equalizer, String redirectURLValue) {
        requiredArgmentValue = CommonUtil.sortByLength(requiredArgmentValue);
        String redirectUrl = "";
        HashMap<String, String> URLAndRedirectURL = new HashMap<String, String>();
        for (String value : requiredArgmentValue) {
            Pattern pattern;
            Matcher matcher;
            if (!url.contains(String.valueOf(separator) + value)) continue;
            if (value.equals(redirectURLValue) && (matcher = (pattern = Pattern.compile(String.valueOf(separator) + value + "[^" + separator + "]*")).matcher(url)).find()) {
                redirectUrl = matcher.group(0).replace(String.valueOf(separator) + value, "");
            }
            url = url.replaceAll(String.valueOf(separator) + value + equalizer + "[^" + separator + "]*", "");
        }
        URLAndRedirectURL.put("URL", url);
        return URLAndRedirectURL;
    }

    private static List<String> sortByLength(List list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.length() > s2.length() ? -1 : 1;
            }
        });
        return list;
    }

    public static String getHostURL(String url) {
        String hostURL = "";
        Pattern pattern = Pattern.compile("^([\\w\\d]+):\\/\\/([\\w\\d\\-_]+(?:\\.[\\w\\d\\-_]+)*)");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            hostURL = matcher.group(0);
        }
        return hostURL;
    }

    public static String getSignature(Context context, String url) {
        try {
            url.toLowerCase();
            String signature = JniClient.MDString("", context, url);
            return signature;
        }
        catch (Exception e) {
            e.printStackTrace();
            return url;
        }
    }

    public static String md5(String input) {
        String result = input;
        if (input != null && !"".equals(input)) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(input.getBytes());
                BigInteger hash = new BigInteger(1, md.digest());
                result = hash.toString(16);
                while (result.length() < 32) {
                    result = "0" + result;
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean isNetWorkEnable(Context context) {
        boolean result = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        result = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        return result;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mWiFiNetworkInfo;
        boolean result = false;
        if (context != null && (mWiFiNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) != null) {
            result = mWiFiNetworkInfo.isAvailable();
        }
        return result;
    }

    public static boolean isMobileConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mMobileNetworkInfo;
        boolean result = false;
        if (context != null && (mMobileNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(0)) != null) {
            result = mMobileNetworkInfo.isAvailable();
        }
        return result;
    }

    public static String encodingUTF8(String str) {
        try {
            return str == null ? "" : URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encodingUTF8(String str, Argument argument, Company company) {
        try {
            if (company.sswitch.encrypt.containsKey(argument.key) && "md5".equals(company.sswitch.encrypt.get(argument.key))) {
                if ("MAC".equals(argument.key)) {
                    str = str == null ? "" : str.replaceAll(":", "");
                }
                String string = str = str == null ? "" : CommonUtil.md5(str);
            }
            if (!argument.urlEncode) {
                return str == null ? "" : str;
            }
            return str == null ? "" : URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

