/*
 * Decompiled with CFR 0.152.
 */
package com.qq.e.comm.util;

import com.qq.e.comm.util.GDTLogger;
import com.qq.e.comm.util.Md5Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    public static boolean copyTo(InputStream inputStream, File file) {
        FileOutputStream fileOutputStream;
        block7: {
            if (inputStream == null || file == null) {
                return false;
            }
            fileOutputStream = null;
            if (file.getParentFile().exists() || file.getParentFile().mkdirs()) break block7;
            FileUtil.tryClose(inputStream);
            FileUtil.tryClose(null);
            return false;
        }
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            try {
                GDTLogger.e(String.format("Exception while copy from InputStream to File %s", file.getAbsolutePath()), throwable);
            }
            catch (Throwable throwable2) {
                FileUtil.tryClose(inputStream);
                FileUtil.tryClose(fileOutputStream);
                throw throwable2;
            }
            FileUtil.tryClose(inputStream);
            FileUtil.tryClose(fileOutputStream);
            return false;
        }
        FileUtil.tryClose(inputStream);
        FileUtil.tryClose(fileOutputStream);
        return true;
    }

    public static boolean renameTo(File file, File file2) {
        if (file == null || file2 == null || !file.exists()) {
            return false;
        }
        if (!file.renameTo(file2)) {
            return FileUtil.copyTo(null, file2);
        }
        return true;
    }

    public static void tryClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static void tryClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static String getFileName(String string) {
        return Md5Util.encode(string);
    }

    public static String getTempFileName(String string) {
        return Md5Util.encode(string) + ".temp";
    }
}

