package ai.botbrain.ttcloud.sdk.widget;

import android.app.Activity;
import android.app.Dialog;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.model.PublishCommentEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.KeyBoardUtil;
import ai.botbrain.ttcloud.sdk.util.ToastUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;

public class InputDailog extends DialogFragment {

    private Button btn_publish;
    private EditText et_comment;
    private TsdCircleImageView mCircleImageView;

    private static final String ARG_PARAM1 = "arg_param1";
    private String mHintText;

    private RequestOptions options_avatar = new RequestOptions()
            .centerCrop()
            .error(R.drawable.tsd_def_avatar)
            .diskCacheStrategy(DiskCacheStrategy.NONE)
            .skipMemoryCache(true)
            .priority(Priority.HIGH);

    public static InputDailog newInstance(String hintText) {
        InputDailog inputDailog = new InputDailog();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_PARAM1, hintText);
        inputDailog.setArguments(bundle);
        return inputDailog;
    }

    public static InputDailog newInstance() {
        return newInstance("");
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mHintText = getArguments().getString(ARG_PARAM1);
        }
    }

    private EditText et_here_speak;

    private void initView(View view) {
        mCircleImageView = (TsdCircleImageView) view.findViewById(R.id.iv_avatar);
        TextView tv_name = (TextView) view.findViewById(R.id.tv_name);
        et_here_speak = (EditText) view.findViewById(R.id.et_here_speak);
        String userNickName = TsdContextHolder.getUserNickName();
        tv_name.setText(userNickName);
        setAvatar();
    }

    private void setAvatar() {
        String userAvatar = TsdContextHolder.getUserAvatar();
        Glide.with(getActivity()).setDefaultRequestOptions(options_avatar).load(userAvatar).transition(
                new DrawableTransitionOptions().crossFade(500)).into(mCircleImageView);
    }

    private void setWindow(Window window) {
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.gravity = Gravity.BOTTOM;
        lp.alpha = 1;
        lp.dimAmount = 0.5f;
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        window.setAttributes(lp);
        window.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (getActivity() instanceof TsdH5ReaderActivity) {
            h5ReaderActivity = ((TsdH5ReaderActivity) getActivity());
        }

        Dialog dialog = new Dialog(getActivity(), R.style.BottomDialog);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        View contentview = View.inflate(getActivity(), R.layout.tsd_dialog_input, null);
        dialog.setContentView(contentview);
        dialog.setCanceledOnTouchOutside(true);
        Window window = dialog.getWindow();
        setWindow(window);
        et_comment = (EditText) contentview.findViewById(R.id.et_comment);
        if (!TextUtils.isEmpty(mHintText))
            et_comment.setHint(mHintText);
        btn_publish = (Button) contentview.findViewById(R.id.btn_publish);
        et_comment.addTextChangedListener(new MyTextWatcher());

        btn_publish.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (TextUtils.isEmpty(et_comment.getText().toString())) {
                    Toast.makeText(getActivity(), "输入内容为空", Toast.LENGTH_LONG).show();
                } else {
                    Editable text = et_comment.getText();
                    if (!TextUtils.isEmpty(text)) {
                        String content = text.toString();
                        publish(content);
                    }
                }
            }
        });
        et_comment.setFocusable(true);
        et_comment.setFocusableInTouchMode(true);
        et_comment.requestFocus();
        initView(contentview);
        renderLikesCount();

        return dialog;
    }

    private TsdH5ReaderActivity h5ReaderActivity;

    private void renderLikesCount() {
        Activity activity = getActivity();
        if (activity instanceof TsdH5ReaderActivity) {
            TsdH5ReaderActivity h5ReaderActivity = ((TsdH5ReaderActivity) activity);
            h5ReaderActivity.setTv_count();
        }
    }

    @Override
    public void dismiss() {
        super.dismiss();
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                KeyBoardUtil.hide(getActivity());
            }
        }, 200);
    }

    public void publish(final String content) {
        if (TsdContextHolder.isLogin()) {
            String userId = TsdContextHolder.getUserId();
            String userAvatar = TsdContextHolder.getUserAvatar();
            //String userName = ContextHolder.getUserName();
            String userNickName = null == TsdContextHolder.getUserNickName() ? "unkonw" : TsdContextHolder.getUserNickName();

            String iid = (String) TsdSPUtils.get(getActivity(), "iid", "");

            subCommEntity = getSubCreateComment();

            if (null != subCommEntity && h5ReaderActivity.mSubCommentsWidget.isShow())
                subCommEntity.superiorCommentId = h5ReaderActivity.mSubCommentsWidget.id;
            else
                subCommEntity = null;

            new RestApiImpl().subComment(new CommentObserver(), iid, userId, userAvatar, userNickName, subCommEntity, content);
        }
    }

    private SubCommEntity subCommEntity;

    public SubCommEntity getSubCreateComment() {
        subCommEntity = h5ReaderActivity.getSubCommentEntity();
        return subCommEntity;
    }

    //private String content;
    private final class CommentObserver extends StringCallback {

        @Override
        public void onSuccess(Response<String> response) {
            dismiss();
            KeyBoardUtil.hide(getActivity());
            String json = response.body();

            renderData(json);
        }

        @Override
        public void onError(Response<String> response) {
            super.onError(response);
        }
    }

    private void renderData(String json) {
        PublishCommentEntity entity = GsonUtil.GsonToBean(json, PublishCommentEntity.class);
        et_comment.setText("");
        SubCommentEntity subCommentEntity = entity.subCommentEntity;
        if (!h5ReaderActivity.mSubCommentsWidget.isShow())
            h5ReaderActivity.addComment(subCommentEntity);
        else {
            subCommentEntity.parentCommentContent = h5ReaderActivity.getSubCommentEntity().parentCommentContent;
            h5ReaderActivity.addComment2(subCommentEntity);
            //h5ReaderActivity.setSubCommEntity(null);
            if (TextUtils.isEmpty(mHintText)) {
                subCommentEntity.parentCommentContent = null;
            }
        }
    }

    private class MyTextWatcher implements TextWatcher {
        private CharSequence temp;

        @Override
        public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
            temp = charSequence;
        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {

        }

        @Override
        public void afterTextChanged(Editable editable) {
            if (temp.length() == 0) {
                btn_publish.setBackgroundResource(R.drawable.tsd_shape_pubsh_gay);
                et_here_speak.setText("");
            } else {
                btn_publish.setBackgroundResource(R.drawable.tsd_shape_pubsh_blue);
                et_here_speak.setText(temp);
            }
            if (temp.length() > 100) {
                ToastUtil.showShort(TsdContextHolder.getContext(), "输入的字数已超过限制");
            }
        }
    }

}
