package ai.botbrain.ttcloud.sdk.widget;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.View;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.TextView;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.adapter.TvAdapter2;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;

public class AnthologyDialog extends Dialog {

    private TextView tvTitle;
    private ImageButton ib_cancel;
    private Context mContext;
    private RecommendEntity.Data2 mData;

    public AnthologyDialog(Context context, RecommendEntity.Data2 entity) {
        super(context, R.style.tsd_commonDialog);
        this.mContext = context;
        this.mData = entity;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tsd_dlg_anthology);
        initView();
    }

    private void initView() {
        String channel = null == mData.channel ? "" : mData.channel;
        String title = null == mData.title ? "" : mData.title;

        tvTitle = (TextView) findViewById(R.id.tv_title);
        ib_cancel = (ImageButton) findViewById(R.id.ib_cancel);
        GridView gv = (GridView) findViewById(R.id.gv);

        tvTitle.setText(title);
        ib_cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AnthologyDialog.this.dismiss();
            }
        });

        ib_cancel.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View arg0) {
                dismiss();
            }
        });

        if (!channel.equals(mContext.getResources().getString(R.string.tsd_variety))) {
            gv.setNumColumns(4);
        } else {
            gv.setNumColumns(2);
        }

        final TvAdapter2 adapter = new TvAdapter2(mContext, mData);
        gv.setAdapter(adapter);
        gv.setSelector(new ColorDrawable(Color.TRANSPARENT));
    }
}
