package ai.botbrain.ttcloud.sdk.presenter;


import com.lzy.okgo.OkGo;

import java.io.IOException;
import java.util.List;

import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.model.InjectJsEntity;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class GetInjectJsNet {

    private static GetInjectJsNet instance = null;

    private List<InjectJsEntity.Content> contentList;

    private GetInjectJsNet() {
    }

    public static GetInjectJsNet getInstance() {
        synchronized (GetInjectJsNet.class) {
            if (instance == null) {
                instance = new GetInjectJsNet();
            }
        }
        return instance;
    }

    public List<InjectJsEntity.Content> getJsHttp() {

        if (null != contentList && contentList.size() > 0) {
            return contentList;
        }
        try {
            okhttp3.Response response = OkGo.get(TsdConstant.URL_JS).execute();
            /*
            Response response2 = OkHttpUtils.get().url(Constant.URL_JS)
                    .tag(this)//
                    .build()//
                    .execute();
                    */

            String json = response.body().string();
            InjectJsEntity entity = GsonUtil.GsonToBean(json, InjectJsEntity.class);
            List<InjectJsEntity.Content> contents = entity.content;
            return contents;
        } catch (IOException ie) {
            ie.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

}
