package ai.botbrain.ttcloud.sdk.presenter;

import android.text.TextUtils;
import android.util.SparseArray;

import com.ak.android.engine.nav.NativeAd;
import com.qq.e.ads.nativ.NativeMediaADData;

import java.util.Iterator;
import java.util.List;

import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.util.CommonUtil;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;

import static ai.botbrain.ttcloud.sdk.TsdConstant.TYPE_360;
import static ai.botbrain.ttcloud.sdk.TsdConstant.TYPE_QQ;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class AdManager {

    /**
     * 腾讯广点通的id和key
     */
    private static String appid, nativevideoposid;

    /**
     * 记录广告位置，广告类型
     */
    private static SparseArray<String> adSlots = new SparseArray<>();

    /**
     * QQ广告对象
     */
    private static SparseArray<NativeMediaADData> mediaADDataHashMap = new SparseArray<>();

    /**
     * 360广告对象
     */
    private static SparseArray<NativeAd> mAd360EntitySparseArray = new SparseArray<>();

    /**
     * 遍历datas集合，删除指定type=ad的元素，并用SparseArray String 集合记录所有广告的位置
     * @param datas 需要遍历的集合
     */
    public static void init(List datas) {
        clearAllAdSlots();
        if (null == datas) return;
        removeUninitializedAds(datas);
    }

    private static void removeUninitializedAds(List datas) {
        int index = 0;
        Iterator sListIterator = datas.iterator();
        while (sListIterator.hasNext()) {
            Object o = sListIterator.next();
            test(o, index, sListIterator);
            index++;
        }
    }

    private static void test(Object o, int index, Iterator sListIterator) {
        if (o instanceof RecommendEntity.Data) {
            RecommendEntity.Data e = (RecommendEntity.Data) o;
            String type = getType(e);
            test2(type, e, index, sListIterator);
        }
    }

    private static void test2(String type, RecommendEntity.Data e, int index, Iterator sListIterator) {
        if (type.equals("ad")) {
            String adSrc = getAdSrc(e);
            test3(adSrc, e, index, sListIterator);
        }
    }

    private static void test3(String adSrc, RecommendEntity.Data e, int index, Iterator sListIterator) {
        if (adSrc.equals(TYPE_QQ)) {
            saveQqAdInfo(e);
            adSlots.put(index, TYPE_QQ);
            sListIterator.remove();
            return;
        }
        if (adSrc.equals(TYPE_360)) {
            adSlots.put(index, TYPE_360);
            sListIterator.remove();
            return;
        }
        //TODO 布本自有的广告统计
    }

    private static String getType(RecommendEntity.Data data) {
        return (null == data.type ? "" : data.type);
    }

    /**
     * 获取广告源
     *
     * @param data 对象
     * @return 广告源
     */
    private static String getAdSrc(RecommendEntity.Data data) {
        RecommendEntity.Data2 data1 = data.data;
        return (null == data1.src ? "" : data1.src);
    }

    public static String getAppId() {
        return appid;
    }

    public static String getNativevideoposid() {
        return nativevideoposid;
    }

    private static void clearAllAdSlots() {
        adSlots.clear();
        mediaADDataHashMap.clear();
        mAd360EntitySparseArray.clear();
    }

    private static void saveQqAdInfo(RecommendEntity.Data data) {
        appid = data.data.appid;
        nativevideoposid = data.data.nativevideoposid;
        if (!TextUtils.isEmpty(appid) && !TextUtils.isEmpty(nativevideoposid)) {
            CommonUtil.setAppId(TsdContextHolder.getContext(), appid);
            CommonUtil.setNativevideoposid(TsdContextHolder.getContext(), nativevideoposid);
        }
    }

    public static SparseArray<String> getAdSlots() {
        return adSlots;
    }

    public static void setMediaADDataHashMap(List<NativeMediaADData> ads) {
        for (int i = 0; i < ads.size(); i++) {
            NativeMediaADData ad = ads.get(i);
            for (int j = 0; j < adSlots.size(); j++) {
                int solt = adSlots.keyAt(i);
                mediaADDataHashMap.put(solt, ad);
            }
        }
    }

    public static void set360HashMap(NativeAd ad) {
        for (int j = 0; j < adSlots.size(); j++) {
            int solt = adSlots.keyAt(j);
            String type = adSlots.get(solt);
            if (type.equals(TYPE_360)) {
                mAd360EntitySparseArray.put(solt, ad);
            }
        }
    }

    public static SparseArray<NativeMediaADData> getMediaADDataHashMap() {
        return mediaADDataHashMap;
    }

    public static SparseArray<NativeAd> getmAd360EntitySparseArray() {
        return mAd360EntitySparseArray;
    }

    /*
    private static void BotAdShow(RecommendEntity.Data data) {
        FireDataManager.botAdShow(data);
        String params = GsonUtil.GsonString(data);
        //TODO 埋点
        //new RestApiImpl().adShowHttp(params);
    }
    */
}
