package ai.botbrain.ttcloud.sdk.net;

import android.app.Application;
import android.text.TextUtils;

import com.firedata.sdk.Firedata;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.GetRequest;
import com.lzy.okgo.request.PostRequest;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.model.YKSecretEntity;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.YouKuManager;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/24.
 */
public class RestApiImpl implements RestApi {

    @Override
    public void getConfig(StringCallback callback, String type) {
        String apiUrl = API_URL_CONFIG + TtCloudManager.getAppId();
        GetRequest<String> request = OkGo.get(apiUrl);
        request.params("sid", TtCloudManager.getSid());
        request.params("uid", FireDataManager.getGuid());
        request.params("platform", TsdConstant.PARAM_PLATFORM);
        if (!TextUtils.isEmpty(type))
            request.params("type", type);
        request.execute(callback);
    }

    @Override
    public void getYouKuConfig() {
        String apiUrl = API_URL_GET_YOUKU_SECRET + TtCloudManager.getAppId();
        GetRequest<String> request = OkGo.<String>get(apiUrl);
        request.params("uid", FireDataManager.getGuid());
        request.params("src", "youku");
        request.params("platform", TsdConstant.PARAM_PLATFORM);
        request.execute(new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {
                String s = response.body();
                try {
                    YKSecretEntity entity = GsonUtil.GsonToBean(s, YKSecretEntity.class);
                    YKSecretEntity.Data data = entity.data;
                    String clientId = data.clientId;
                    String secret = data.clientSecret;
                    YouKuManager.setLog(true);
                    YouKuManager.setClientIdAndSecret(clientId, secret);
                    YouKuManager.onInitial((Application) TsdContextHolder.getContext());

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(Response<String> response) {
                super.onError(response);

            }
        });
    }

    private String getColumnid(TopTitleEntity.Columns data, int secondDirectoryPosition) {
        String out_id = data.id;
        String in_id = "";
        if (null != data.subColumns && data.subColumns.size() > 0) {
            in_id = data.subColumns.get(secondDirectoryPosition).id;
        }
        if (out_id.equals(in_id)) {
            return out_id;
        } else if (TextUtils.isEmpty(in_id)) {
            return out_id;
        } else {
            return out_id + "_" + in_id;
        }
    }

    @Override
    public void feedList(StringCallback callback, String columnid, int st, String time) {
        GetRequest<String> request = OkGo.<String>get(API_URL_GET_FEED_LIST);
        request.params("appid", TtCloudManager.getAppId());
        if (null != time)
            request.params("time", time);
        request.params("columnid", columnid);
        request.params("uid", Firedata.getGuid());
        request.params("st", "" + st);
        request.params("ct", "6");
        request.params("platform", TsdConstant.PARAM_PLATFORM);
        if (st == 0) {
            request.params("widen", "1");
        }
        request.execute(callback);
    }

    /**
     * 视频用的
     *
     * @param callback                ..
     * @param start                   ..
     * @param sid                     ..
     * @param data                    ..
     * @param secondDirectoryPosition ..
     */
    @Override
    public void getFeedData(StringCallback callback, int start, String sid,
                            TopTitleEntity.Columns data, int secondDirectoryPosition) {
        String columnid = getColumnid(data, secondDirectoryPosition);
        GetRequest<String> request = OkGo.<String>get(API_URL_GET_FEED_LIST);
        request.params("appid", TtCloudManager.getAppId());
        request.params("columnid", columnid);
        request.params("uid", FireDataManager.getGuid());
        request.params("st", start + "");
        request.params("ct", 6);
        request.params("sid", sid);
        request.params("sdk", "2.0");
        request.params("city", "1");
        request.params("platform", TsdConstant.PARAM_PLATFORM);
        request.params("network", "1");
        request.params("versionCode", String.valueOf(VERSION_CODE));
        request.execute(callback);
    }

    @Override
    public void adClickHttp(String params) {
        OkGo.<String>get(API_URL_AD_CLICK)
                .params("appid", TtCloudManager.getAppId())
                .params("md", "home")
                .params("uid", FireDataManager.getGuid())
                .params("sid", TtCloudManager.getSid())
                .params("params", params)
                .params("platform", TsdConstant.PARAM_PLATFORM).execute(new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

            }
        });
    }

    @Override
    public void reportVid(int code, String iid) {
        OkGo.<String>get(API_URL_AD_CLICK).params("appid", TtCloudManager.getAppId())
                .params("md", "1")
                .params("uid", "1")
                .params("sid", "1")
                .params("iid", iid)
                .params("platform", TsdConstant.PARAM_PLATFORM).execute(new StringCallback() {

            @Override
            public void onSuccess(Response<String> response) {

            }
        });
    }

    @Override
    public void commentToService(String iid, Object alg, String action, String columnid, String num, String params) {
        String apiUrl = API_URL_UB + action;
        GetRequest request = OkGo.<String>get(apiUrl);
        request.params("appid", TtCloudManager.getAppId());
        request.params("sid", TtCloudManager.getSid());
        request.params("uid", FireDataManager.getGuid());
        if (!TextUtils.isEmpty(columnid))
            request.params("columnid", columnid);
        if (!TextUtils.isEmpty(params))
            request.params("params", params);
        if (!TextUtils.isEmpty(iid))
            request.params("iid", iid);
        if (null != alg && !TextUtils.isEmpty(alg.toString()))
            request.params("alg", alg.toString());
        if (!TextUtils.isEmpty(num)) {
            request.params("num", num);
        }
        request.params("platform", TsdConstant.PARAM_PLATFORM).execute(new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {

            }
        });
    }

    @Override
    public void coldStartHttp(String action, String ext) {
        String apiUrl = API_URL_UB + action;
        GetRequest request = OkGo.<String>get(apiUrl);
        request.params("appid", TtCloudManager.getAppId());
        request.params("sid", TtCloudManager.getSid());
        request.params("uid", FireDataManager.getGuid());
        if (!TextUtils.isEmpty(ext))
            request.params("ext", ext);
        request.params("platform", TsdConstant.PARAM_PLATFORM).execute(null);
    }

    @Override
    public void getBaiduAdKey(StringCallback call) {
        String apiUrl = API_URL_BAIDU_AD_KEY + TtCloudManager.getAppId();
        GetRequest<String> request = OkGo.get(apiUrl);
        request.execute(call);
    }

    public static void searchVideo(StringCallback callback, String keywords, String start) {
        OkGo.<String>get(API_URL_SEARCH).params("appid", TtCloudManager.getAppId())
                .params("md", "search")
                .params("sid", TtCloudManager.getSid())
                .params("uid", FireDataManager.getGuid())
                .params("st", start)
                .params("ct", 10)
                .params("kw", keywords)
                .params("platform", TsdConstant.PARAM_PLATFORM)
                .execute(callback);
    }

    @Override
    public void commentList(StringCallback callback, String iid, int current) {
        String apiUrl = API_URL_GET_COMMENT_LIST + TtCloudManager.getAppId() + "/list/" + iid + "/comment";
        OkGo.<String>get(apiUrl).params("st", String.valueOf(current))
                .params("ct", String.valueOf(TsdConstant.REQUEST_COUNT_CONTENT_LIST))
                .params("platform", TsdConstant.PARAM_PLATFORM).execute(callback);
    }

    @Override
    public void subCommentList(String iid, String parentCommentId, String superiorCommentId, int st, StringCallback callback) {
        String apiUrl = API_URL_GET_COMMENT_LIST + TtCloudManager.getAppId() + "/list/" + iid + "/subComment";
        OkGo.<String>get(apiUrl)
                .params("superiorCommentId", superiorCommentId)
                .params("st", st)
                .params("ct", TsdConstant.REQUEST_COUNT_CONTENT_LIST)
                .params("platform", TsdConstant.PARAM_PLATFORM).execute(callback);
    }

    @Override
    public void subComment(StringCallback callback, String iid, String userId, String avatar, String userNick,
                           SubCommEntity commEntity, String content) {

        String apiUrl = API_URL_POST_COMMENT + TtCloudManager.getAppId() + "/create/" + iid + ".json";
        PostRequest request = OkGo.<String>post(apiUrl);
        request.isMultipart(true);
        if (commEntity != null) {
            String parentId = commEntity.parentId;
            String parentIcon = commEntity.parentIcon;
            String parentNick = commEntity.parentNick;
            String parentCommentId = commEntity.parentCommentId;
            String superiorCommentId = commEntity.superiorCommentId;

            request.params("parentId", parentId);
            request.params("parentNick", parentNick);
            request.params("parentIcon", parentIcon);
            request.params("parentCommentId", parentCommentId);
            request.params("superiorCommentId", superiorCommentId);
        }

        request.params("userId", userId);
        request.params("userIcon", avatar);
        request.params("userNick", userNick);
        request.params("comment", content);

        request.params("platform", TsdConstant.PARAM_PLATFORM).execute(callback);
    }

    @Override
    public void comment(StringCallback callback, String iid, String userId, String avatar, String userNick, String content) {
        String apiUrl = API_URL_POST_COMMENT + TtCloudManager.getAppId() + "/create/" + iid + ".json";
        OkGo.<String>get(apiUrl)
                .params("userId", userId)
                .params("userIcon", avatar)
                .params("userNick", userNick)
                .params("comment", content)
                .params("platform", TsdConstant.PARAM_PLATFORM).execute(callback);
    }

    @Override
    public void like(StringCallback callback, String action, String iid) {
        String apiUrl = API_URL_POINT_UP + TtCloudManager.getAppId() + "/up/" + action + "/" + iid + ".json";
        commentToService(TtCloudManager.getAppId(), "", "up", "", "", "");
        OkGo.<String>get(apiUrl).execute(callback);
    }



}
