package ai.botbrain.ttcloud.sdk.net;


import com.lzy.okgo.callback.StringCallback;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/24.
 */
public interface RestApi {
    /**
     * 每次发版本需要修改的版本号.
     */
    int VERSION_CODE = 121;

    String API_BASE_URL_TTC = TtCloudManager.DEBUG ? "http://test.bot.firedata.cc" : "https://ttc.botbrain.ai";
    //String API_BASE_URL_TTC = "https://ttc.botbrain.ai";
    //https://testbkd.botbrain.ai/
    String API_BASE_URL_BKD = TtCloudManager.DEBUG ? "https://testbkd.botbrain.ai" : "https://bkd.botbrain.ai";

    String API_URL_ERROR_VID = API_BASE_URL_TTC + "/v3/v/video/error";

    String API_URL_UB = API_BASE_URL_TTC + "/v3/ub/";
    String API_URL_BAIDU_AD_KEY = API_BASE_URL_TTC + "/v3/config/baidu/";
    //String API_URL_AD_ERROR = API_BASE_URL_TTC + "/v3/ad/ub/aderror";
    String API_URL_AD_CLICK = API_BASE_URL_TTC + "/v3/ad/ub/adclick";

    String API_URL_SEARCH = API_BASE_URL_TTC + "/v3/v/search";
    String API_URL_CONFIG = API_BASE_URL_TTC + "/v3/config/";
    String API_URL_GET_FEED_LIST = API_BASE_URL_TTC + "/v3/data/feed";
    String API_URL_GET_YOUKU_SECRET = API_BASE_URL_TTC + "/v3/config/video/";

    String API_URL_POINT_UP = API_BASE_URL_BKD + "/interact/v1/";
    String API_URL_ARTICLE = API_BASE_URL_BKD + "/view/v1/";
    String API_URL_GET_COMMENT_LIST = API_BASE_URL_BKD + "/comment/v2/";
    String API_URL_POST_COMMENT = API_BASE_URL_BKD + "/comment/v2/";

    void getYouKuConfig();

    void getFeedData(StringCallback callback, int start, String sid, TopTitleEntity.Columns data,
                     int secondDirectoryPosition);

    void feedList(StringCallback callback, String columnid, int st, String time);

    void getConfig(StringCallback callback, String type);

    void adClickHttp(String params);

    void reportVid(int code, String iid);

    void commentToService(String iid, Object alg, String action, String columnid, String num,
                          String params);

    void commentList(StringCallback callback, String iid, int current);

    void subCommentList(String iid, String userId, String superiorCommentId, int st, StringCallback callback);

    void comment(StringCallback callback, String iid, String userId, String avatar, String userNick,
                 String content);

    void subComment(StringCallback callback, String iid, String userId, String avatar, String userNick,
                    SubCommEntity commEntity, String content);

    void like(StringCallback callback, String action, String iid);

    void coldStartHttp(String action, String ext);

    void getBaiduAdKey(StringCallback call);
}
