package ai.botbrain.ttcloud.sdk.adapter;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;

import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.widget.RecommendDialog;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class CardStyle2Adapter extends BaseAdapter {
    private static final String TAG = CardStyle2Adapter.class.getSimpleName();

    private Context mContext;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    private List<RecommendEntity.Datas> datases;
    private LayoutInflater inflater;

    public CardStyle2Adapter(Context context, List<RecommendEntity.Datas> datases) {
        this.mContext = context;
        inflater = LayoutInflater.from(context);
        this.datases = datases;
    }

    @Override
    public int getCount() {
        return datases == null ? 0 : datases.size();
    }

    @Override
    public Object getItem(int i) {
        return null;
    }

    @Override
    public long getItemId(int i) {
        return 0;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            convertView = inflater.inflate(R.layout.tsd_item_video_vertical, parent, false);
            viewHolder.iv_pic = (ImageView) convertView.findViewById(R.id.iv_pic);
            viewHolder.tv_left_down = (TextView) convertView.findViewById(R.id.tv_left_down);
            viewHolder.tv_right_down = (TextView) convertView.findViewById(R.id.tv_right_down);
            viewHolder.tv_first_line = (TextView) convertView.findViewById(R.id.tv_first_line);
            viewHolder.tv_second_line = (TextView) convertView.findViewById(R.id.tv_second_line);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        final RecommendEntity.Datas datasEntity = datases.get(position);
        String pic_url = null == datasEntity.pic_url ? "" : datasEntity.pic_url;
        String left_down = null == datasEntity.left_down ? "" : datasEntity.left_down;
        String right_down = null == datasEntity.right_down ? "" : datasEntity.right_down;
        final String first_line = null == datasEntity.first_line ? "" : datasEntity.first_line;
        String second_line = null == datasEntity.second_line ? "" : datasEntity.second_line;
        final String channel = null == datasEntity.channel ? "" : datasEntity.channel;
        final String iid = null == datasEntity.iid ? "" : datasEntity.iid;

        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                FireDataManager.clickContent("recommend", first_line, iid);
                //EventBus.getDefault().post(new BuriedPointEvent("click", iid, "{}", null, null));

                if (channel.equals(mContext.getResources().getString(R.string.tsd_movie))) {
                    List<RecommendEntity.MovieUrls> movieUrls = datasEntity.movie_urls;
                    final String url = null == movieUrls.get(0).sources ? "" : movieUrls.get(0).sources;
                    if (JsPresenter.getInstance().isEmpty()) {
                        new Thread() {
                            @Override
                            public void run() {
                                super.run();
                                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
                                mainHandler.post(new Runnable() {
                                    @Override
                                    public void run() {
                                        FireDataManager.play("recommend");
                                        JsPresenter.getInstance().StartPlayback(mContext, url, first_line, iid);
                                    }
                                });

                            }
                        }.start();
                    } else {
                        FireDataManager.play("recommend");
                        JsPresenter.getInstance().StartPlayback(mContext, url, first_line, iid);
                    }
                } else {
                    RecommendDialog dialog = new RecommendDialog(mContext, datasEntity);
                    dialog.show();
                }
            }
        });

        viewHolder.tv_left_down.setText(left_down);
        viewHolder.tv_right_down.setText(right_down);
        viewHolder.tv_first_line.setText(first_line);
        viewHolder.tv_second_line.setText(second_line);
        //ImageLoader.getInstance().displayImage(pic_url, viewHolder.iv_pic, options_common);
        Glide.with(mContext)
                .load(pic_url)
                .transition(new DrawableTransitionOptions().crossFade(500))
                .into(viewHolder.iv_pic);

        return convertView;
    }

    private static class ViewHolder {
        private TextView tv_left_down;
        private TextView tv_right_down;
        private TextView tv_first_line;
        private TextView tv_second_line;
        private ImageView iv_pic;
        // 亚健康 调理肠胃 排毒
        //
    }

}
