package ai.botbrain.ttcloud.sdk.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;

public class TsdChoiceLikeActivity extends Activity implements View.OnClickListener {

    private TopTitleEntity.ColdStart mColdStart;
    private String mAppName;

    private Button btn_ok;
    private TextView tv_title;
    private TextView ttc_tv_title;

    private List<Button> buttons;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tsd_activity_choice_like);
        initVariables();
        buttons = new ArrayList<>();
        initView();
        init();
    }

    private void initVariables() {
        Intent intnet = getIntent();
        mColdStart = (TopTitleEntity.ColdStart) intnet.getSerializableExtra("ACTION_COLDSTART");
        mAppName = intnet.getStringExtra("ACTION_APP_NAME");
    }

    private void init() {
        ttc_tv_title.setText(mAppName);
        if (null == mColdStart) return;
        setTitle();
        setBtn();
        setLabel();
    }

    private void setLabel() {
        try {
            ArrayList<Map> map = mColdStart.tags;
            for (int i = 0; i < map.size(); i++) {
                LinkedHashMap linkedTreeMap = (LinkedHashMap) map.get(i);
                String label = (String) linkedTreeMap.get("label");
                buttons.get(i).setVisibility(View.VISIBLE);
                buttons.get(i).setText(label);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTitle() {
        String custom = null == mColdStart.custom ? "" : mColdStart.custom;
        tv_title.setText(custom);
    }

    private void setBtn() {
        String confirm = null == mColdStart.confirm ? "" : mColdStart.confirm;
        btn_ok.setText(confirm);
    }

    private void initView() {
        Button btn_0 = (Button) findViewById(R.id.btn_0);
        Button btn_1 = (Button) findViewById(R.id.btn_1);
        Button btn_2 = (Button) findViewById(R.id.btn_2);
        Button btn_3 = (Button) findViewById(R.id.btn_3);
        Button btn_4 = (Button) findViewById(R.id.btn_4);

        Button btn_5 = (Button) findViewById(R.id.btn_5);
        Button btn_6 = (Button) findViewById(R.id.btn_6);
        Button btn_7 = (Button) findViewById(R.id.btn_7);
        Button btn_8 = (Button) findViewById(R.id.btn_8);
        Button btn_9 = (Button) findViewById(R.id.btn_9);

        btn_ok = (Button) findViewById(R.id.btn_ok);
        tv_title = (TextView) findViewById(R.id.tv_title);
        Button btn_skip = (Button) findViewById(R.id.btn_skip);
        ttc_tv_title = (TextView) findViewById(R.id.ttc_tv_title);

        buttons.add(btn_0);
        buttons.add(btn_1);
        buttons.add(btn_2);
        buttons.add(btn_3);
        buttons.add(btn_4);
        buttons.add(btn_5);
        buttons.add(btn_6);
        buttons.add(btn_7);
        buttons.add(btn_8);
        buttons.add(btn_9);

        for (Button btn : buttons) {
            btn.setOnClickListener(this);
        }
        btn_skip.setOnClickListener(this);
        btn_ok.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        if (v instanceof Button && buttons.contains(v)) {
            v.setSelected(!v.isSelected());
            setBtnOkColor();
            return;
        }
        if (v.getId() == R.id.btn_skip) {
            finish();
            return;
        }
        if (v.getId() == R.id.btn_ok && btn_ok.isSelected()) {
            http();
        }
    }

    private void http() {
        ArrayList<Object> list = new ArrayList<>();
        try {
            ArrayList<Map> map = mColdStart.tags;
            for (int i = 0; i < map.size(); i++) {
                LinkedHashMap linkedTreeMap = (LinkedHashMap) map.get(i);
                Object o = linkedTreeMap.get("topic");
                if (buttons.get(i).isSelected() && null != o) list.add(o);
            }
            String ext = GsonUtil.GsonString(list);
            new RestApiImpl().coldStartHttp("coldstart", ext);
            finish();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBtnOkColor() {
        btn_ok.setSelected(false);
        for (Button btn : buttons) {
            if (btn.isSelected()) btn_ok.setSelected(true);
        }
    }
}
