/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.widget;

import ai.botbrain.ttcloud.sdk.widget.PageIndicator;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;

public class TabPageIndicator
extends HorizontalScrollView
implements PageIndicator {
    private static final String LOG_TAG = "cube-views-page-indicator";
    private ViewHolderCreator mViewHolderCreator;
    private Runnable mTabSelector;
    private final View.OnClickListener mTabClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            ViewHolderBase viewHolderBase = (ViewHolderBase)view.getTag();
            int oldSelected = TabPageIndicator.this.mViewPager.getCurrentItem();
            int newSelected = viewHolderBase.getIndex();
            TabPageIndicator.this.mViewPager.setCurrentItem(newSelected);
            if (oldSelected == newSelected && TabPageIndicator.this.mTabReselectedListener != null) {
                TabPageIndicator.this.mTabReselectedListener.onTabReselected(newSelected);
            }
        }
    };
    private final LinearLayout mTabLayout;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private int mMaxTabWidth;
    private int mSelectedTabIndex = -1;
    private OnTabReselectedListener mTabReselectedListener;

    public void setViewHolderCreator(ViewHolderCreator viewHolderCreator) {
        this.mViewHolderCreator = viewHolderCreator;
    }

    public TabPageIndicator(Context context) {
        this(context, null);
    }

    public TabPageIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setHorizontalScrollBarEnabled(false);
        this.mTabLayout = new LinearLayout(context);
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
    }

    public void setOnTabReselectedListener(OnTabReselectedListener listener) {
        this.mTabReselectedListener = listener;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        boolean lockedExpanded = widthMode == 0x40000000;
        this.setFillViewport(lockedExpanded);
        int childCount = this.mTabLayout.getChildCount();
        this.mMaxTabWidth = childCount > 1 && (widthMode == 0x40000000 || widthMode == Integer.MIN_VALUE) ? (childCount > 2 ? (int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) * 0.4f) : View.MeasureSpec.getSize((int)widthMeasureSpec) / 2) : -1;
        int oldWidth = this.getMeasuredWidth();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int newWidth = this.getMeasuredWidth();
        if (lockedExpanded && oldWidth != newWidth) {
            this.updateTab(this.mSelectedTabIndex);
        }
    }

    private void animateToTab(int position) {
        final View tabView = this.mTabLayout.getChildAt(position);
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
        this.mTabSelector = new Runnable(){

            @Override
            public void run() {
                int scrollPos = tabView.getLeft() - (TabPageIndicator.this.getWidth() - tabView.getWidth()) / 2;
                TabPageIndicator.this.smoothScrollTo(scrollPos, 0);
                TabPageIndicator.this.mTabSelector = null;
            }
        };
        this.post(this.mTabSelector);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTabSelector != null) {
            this.post(this.mTabSelector);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
    }

    public void onPageScrollStateChanged(int i) {
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(i);
        }
    }

    public void onPageScrolled(int i, float v, int i1) {
        if (this.mListener != null) {
            this.mListener.onPageScrolled(i, v, i1);
        }
    }

    public void onPageSelected(int i) {
        this.moveToItem(i);
    }

    @Override
    public void setViewPager(ViewPager view) {
        PagerAdapter adapter;
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if ((adapter = view.getAdapter()) == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = view;
        view.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.notifyDataSetChanged();
    }

    @Override
    public void notifyDataSetChanged() {
        this.mTabLayout.removeAllViews();
        PagerAdapter adapter = this.mViewPager.getAdapter();
        int count = adapter.getCount();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        for (int i = 0; i < count; ++i) {
            ViewHolderBase viewHolder = this.mViewHolderCreator.createViewHolder();
            viewHolder.setIndex(i);
            View view = viewHolder.createView(layoutInflater, i);
            view.setFocusable(true);
            view.setOnClickListener(this.mTabClickListener);
            view.setTag((Object)viewHolder);
            if (view.getLayoutParams() == null) {
                this.mTabLayout.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
                continue;
            }
            this.mTabLayout.addView(view);
        }
        this.mSelectedTabIndex = this.mViewPager.getCurrentItem();
        this.updateTab(this.mSelectedTabIndex);
        this.requestLayout();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.moveToItem(initialPosition);
    }

    public void moveToItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        if (this.mSelectedTabIndex == item) {
            // empty if block
        }
        this.mSelectedTabIndex = item;
        this.mViewPager.setCurrentItem(item);
        if (this.mListener != null) {
            this.mListener.onPageSelected(item);
        }
        this.updateTab(item);
    }

    private void updateTab(int item) {
        int tabCount = this.mTabLayout.getChildCount();
        for (int i = 0; i < tabCount; ++i) {
            View child = this.mTabLayout.getChildAt(i);
            ViewHolderBase viewHolderBase = (ViewHolderBase)child.getTag();
            boolean isSelected = i == item;
            viewHolderBase.updateView(i, isSelected);
            if (!isSelected) continue;
            this.animateToTab(item);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public static abstract class ViewHolderCreator {
        public abstract ViewHolderBase createViewHolder();
    }

    public static abstract class ViewHolderBase {
        private int mIndex;

        private void setIndex(int index) {
            this.mIndex = index;
        }

        private int getIndex() {
            return this.mIndex;
        }

        public abstract View createView(LayoutInflater var1, int var2);

        public abstract void updateView(int var1, boolean var2);
    }

    public static interface OnTabReselectedListener {
        public void onTabReselected(int var1);
    }
}

