/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.widget;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.adapter.SubCommentAdapter;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentsEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.widget.TsdCircleImageView;
import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import android.widget.TextView;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;
import cn.bingoogolapple.refreshlayout.BGARefreshViewHolder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import java.util.ArrayList;
import java.util.List;

public class SubCommentsWidget
extends RelativeLayout
implements BGARefreshLayout.BGARefreshLayoutDelegate {
    private RequestOptions options_avatar = new RequestOptions().centerCrop().placeholder(R.drawable.tsd_def_avatar).error(R.drawable.tsd_def_avatar).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC).skipMemoryCache(false).priority(Priority.HIGH);
    private Context mContext;
    private TsdH5ReaderActivity h5ReaderActivity;
    private Scroller mScroller;
    private int mScreenHeigh = 0;
    private int downY = 0;
    private Boolean isMoving = false;
    private int viewHeight = 0;
    public boolean isShow = false;
    public boolean mEnabled = true;
    public boolean mOutsideTouchable = true;
    private int mDuration = 800;
    public String id;
    public SubCommentEntity topData;
    public List<SubCommentEntity> mDatas;
    public SubCommentAdapter mSubCommentAdapter;
    private TsdCircleImageView mCircleImageView;
    private TextView tv_user_nick;
    private TextView tv_content;
    private TextView tv_reply_count;
    public ListView mListView;
    private TextView tv_close;
    public TextView tv_widget_count;
    public ImageButton ib_widget_like;
    public TextView tv_widget_time;
    public onStatusListener statusListener;
    private int current = 0;

    public SubCommentsWidget(Context context) {
        super(context);
        this.init(context);
    }

    public SubCommentsWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SubCommentsWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private String getIid() {
        TsdH5ReaderActivity h5ReaderActivity = (TsdH5ReaderActivity)this.mContext;
        return h5ReaderActivity.iid;
    }

    public void renderReplyNum() {
        this.tv_reply_count.setText((CharSequence)(this.mDatas.size() + "\u6761\u56de\u590d"));
    }

    public void renderTop(SubCommentEntity data) {
        this.topData = data;
        String commentContent = null == data.commentContent ? "" : data.commentContent;
        String userNick = null == data.userNickName ? "" : data.userNickName;
        String userIcon = null == data.userAvatar ? "" : data.userAvatar;
        this.id = null == data.id ? "" : data.id;
        String subCommentNum = null == data.subCommentNum ? "" : data.subCommentNum;
        String commentTime = null == data.commentTime ? "" : data.commentTime;
        commentTime = TimeUtil.getStrTime(commentTime);
        commentTime = TimeUtil.getNiceDate(commentTime);
        this.tv_widget_time.setText((CharSequence)commentTime);
        this.current = 0;
        this.mDatas.clear();
        this.tv_user_nick.setText((CharSequence)userNick);
        this.tv_content.setText((CharSequence)commentContent);
        this.renderReplyNum();
        Glide.with((Context)ContextHolder.getContext()).setDefaultRequestOptions(this.options_avatar).load((Object)userIcon).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into((ImageView)this.mCircleImageView);
    }

    public void subComments(String iid, String parentCommentId, int st) {
        String superiorCommentId = this.h5ReaderActivity.mSubCommentsWidget.id;
        new RestApiImpl().subCommentList(iid, parentCommentId, superiorCommentId, st, new StringCallback(){

            public void onSuccess(Response<String> response) {
                String json = (String)response.body();
                SubCommentsWidget.this.renderList(json);
            }
        });
    }

    private void renderList(String json) {
        try {
            SubCommentsEntity entity = GsonUtil.GsonToBean(json, SubCommentsEntity.class);
            this.mDatas.addAll(entity.data);
            this.mSubCommentAdapter.notifyDataSetChanged();
        }
        catch (Exception e) {
            this.mSubCommentAdapter.notifyDataSetChanged();
            e.printStackTrace();
        }
        this.renderReplyNum();
    }

    private void initView(View view) {
        BGARefreshLayout mRefreshLayout2 = (BGARefreshLayout)view.findViewById(R.id.rl_modulename_refresh2);
        mRefreshLayout2.setDelegate((BGARefreshLayout.BGARefreshLayoutDelegate)this);
        mRefreshLayout2.setPullDownRefreshEnable(false);
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(this.mContext, true);
        refreshViewHolder.setLoadMoreBackgroundColorRes(R.color.tpp_color_white);
        mRefreshLayout2.setRefreshViewHolder((BGARefreshViewHolder)refreshViewHolder);
        this.mCircleImageView = (TsdCircleImageView)view.findViewById(R.id.iv_avatar);
        this.tv_close = (TextView)view.findViewById(R.id.tv_close);
        this.tv_widget_time = (TextView)view.findViewById(R.id.tv_widget_time);
        this.tv_user_nick = (TextView)view.findViewById(R.id.tv_user_nick);
        this.tv_content = (TextView)view.findViewById(R.id.tv_content);
        this.tv_reply_count = (TextView)view.findViewById(R.id.tv_reply_count);
        this.mListView = (ListView)view.findViewById(R.id.listview);
        this.ib_widget_like = (ImageButton)view.findViewById(R.id.ib_widget_like);
        this.tv_widget_count = (TextView)view.findViewById(R.id.tv_widget_count);
    }

    private void init(Context context) {
        this.mContext = context;
        this.h5ReaderActivity = (TsdH5ReaderActivity)this.mContext;
        this.mDatas = new ArrayList<SubCommentEntity>();
        this.mSubCommentAdapter = new SubCommentAdapter(context, this.mDatas);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        this.mScroller = new Scroller(context);
        this.mScreenHeigh = SubCommentsWidget.getWindowHeigh(context);
        final View view = LayoutInflater.from((Context)context).inflate(R.layout.tsd_widget_comments, null);
        this.initView(view);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        this.addView(view, (ViewGroup.LayoutParams)params);
        view.post(new Runnable(){

            @Override
            public void run() {
                SubCommentsWidget.this.viewHeight = view.getHeight();
            }
        });
        this.scrollTo(0, this.mScreenHeigh);
        this.tv_close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SubCommentsWidget.this.dismiss();
            }
        });
        this.mListView.setAdapter((ListAdapter)this.mSubCommentAdapter);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mEnabled) {
            return false;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.downY = (int)event.getY();
                if (!this.isShow) break;
                return true;
            }
            case 2: {
                int moveY = (int)event.getY();
                int scrollY = moveY - this.downY;
                if (scrollY > 0 && this.isShow) {
                    this.scrollTo(0, -Math.abs(scrollY));
                    break;
                }
                if (this.mScreenHeigh - this.getTop() > this.viewHeight || this.isShow) break;
                this.scrollTo(0, Math.abs(this.viewHeight - scrollY));
                break;
            }
            case 1: {
                if (this.isShow) {
                    if (this.getScrollY() <= -(this.viewHeight / 2)) {
                        this.startMoveAnim(this.getScrollY(), -(this.viewHeight - this.getScrollY()), this.mDuration);
                        this.isShow = false;
                    } else {
                        this.startMoveAnim(this.getScrollY(), -this.getScrollY(), this.mDuration);
                        this.isShow = true;
                    }
                }
                this.changed();
                break;
            }
            case 4: {
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    public void startMoveAnim(int startY, int dy, int duration) {
        this.isMoving = true;
        this.mScroller.startScroll(0, startY, 0, dy, duration);
        this.invalidate();
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.postInvalidate();
            this.isMoving = true;
        } else {
            this.isMoving = false;
        }
        super.computeScroll();
    }

    public void show() {
        if (this.mDatas != null && this.mDatas.size() > 0) {
            this.mDatas.clear();
            this.mSubCommentAdapter.notifyDataSetChanged();
        }
        if (!this.isShow) {
            this.startMoveAnim(-this.viewHeight, this.viewHeight, this.mDuration);
            this.isShow = true;
            this.changed();
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SubCommentsWidget.this.subComments(SubCommentsWidget.this.getIid(), SubCommentsWidget.this.id, SubCommentsWidget.this.current);
            }
        }, 800L);
    }

    public void dismiss() {
        if (this.isShow && !this.isMoving.booleanValue()) {
            this.startMoveAnim(0, -this.viewHeight, this.mDuration);
            this.isShow = false;
            this.changed();
        }
    }

    public boolean isShow() {
        return this.isShow;
    }

    public boolean isSlidingEnabled() {
        return this.mEnabled;
    }

    public void setSlidingEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public void setOnStatusListener(onStatusListener listener) {
        this.statusListener = listener;
    }

    public void setOutsideTouchable(boolean touchable) {
        this.mOutsideTouchable = touchable;
    }

    public void changed() {
        if (this.statusListener != null) {
            if (this.isShow) {
                this.statusListener.onShow();
            } else {
                this.statusListener.onDismiss();
            }
        }
    }

    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {
    }

    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        this.subComments(this.getIid(), this.id, ++this.current);
        return false;
    }

    public static int getWindowHeigh(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        int mScreenHeigh = dm.heightPixels;
        return mScreenHeigh;
    }

    static interface onStatusListener {
        public void onShow();

        public void onDismiss();
    }
}

