/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.widget;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

public class LoadingView
extends FrameLayout
implements View.OnClickListener {
    private View empty;
    private View error;
    private View loading;
    private State state;
    private OnRetryListener listener;
    private ImageView iv_error;
    private TextView tv_1;
    private TextView tv_2;

    public LoadingView(Context context) {
        super(context);
        this.initializeView(context);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initializeView(context);
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initializeView(context);
    }

    private void initializeView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.tsd_widget_loading_view, (ViewGroup)this);
        this.empty = this.findViewById(R.id.empty);
        this.loading = this.findViewById(R.id.loading);
        this.error = this.findViewById(R.id.error);
        this.iv_error = (ImageView)this.findViewById(R.id.iv_error);
        this.tv_1 = (TextView)this.findViewById(R.id.tv_1);
        this.tv_2 = (TextView)this.findViewById(R.id.tv_2);
        if (0 != ContextHolder.getLoadingErrorView()) {
            this.iv_error.setImageResource(ContextHolder.getLoadingErrorView());
            this.tv_1.setVisibility(8);
            this.tv_2.setVisibility(8);
        }
        this.setOnClickListener(this);
        this.notifyDataChanged(State.done);
    }

    public void notifyDataChanged(State state) {
        this.state = state;
        switch (state) {
            case ing: {
                this.setVisibility(0);
                this.loading.setVisibility(0);
                this.empty.setVisibility(8);
                this.error.setVisibility(8);
                break;
            }
            case empty: {
                this.setVisibility(0);
                this.loading.setVisibility(8);
                this.empty.setVisibility(0);
                this.error.setVisibility(8);
                break;
            }
            case error: {
                this.setVisibility(0);
                this.loading.setVisibility(8);
                this.empty.setVisibility(8);
                this.error.setVisibility(0);
                break;
            }
            case done: {
                this.setVisibility(8);
                break;
            }
        }
    }

    public void setOnRetryListener(OnRetryListener listener) {
        this.listener = listener;
    }

    public void onClick(View v) {
        if (this.listener != null && this.state == State.error) {
            this.listener.onRetry();
        }
    }

    public static enum State {
        ing,
        error,
        done,
        empty;

    }

    public static interface OnRetryListener {
        public void onRetry();
    }
}

