/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.widget;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.model.PublishCommentEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.KeyBoardUtil;
import ai.botbrain.ttcloud.sdk.util.ToastUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.TsdCircleImageView;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;

public class InputDailog
extends DialogFragment {
    private Button btn_publish;
    private EditText et_comment;
    private TsdCircleImageView mCircleImageView;
    private static final String ARG_PARAM1 = "arg_param1";
    private String mHintText;
    private RequestOptions options_avatar = new RequestOptions().centerCrop().error(R.drawable.tsd_def_avatar).diskCacheStrategy(DiskCacheStrategy.NONE).skipMemoryCache(true).priority(Priority.HIGH);
    private EditText et_here_speak;
    private TsdH5ReaderActivity h5ReaderActivity;
    private SubCommEntity subCommEntity;

    public static InputDailog newInstance(String hintText) {
        InputDailog inputDailog = new InputDailog();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_PARAM1, hintText);
        inputDailog.setArguments(bundle);
        return inputDailog;
    }

    public static InputDailog newInstance() {
        return InputDailog.newInstance("");
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mHintText = this.getArguments().getString(ARG_PARAM1);
        }
    }

    private void initView(View view) {
        this.mCircleImageView = (TsdCircleImageView)view.findViewById(R.id.iv_avatar);
        TextView tv_name = (TextView)view.findViewById(R.id.tv_name);
        this.et_here_speak = (EditText)view.findViewById(R.id.et_here_speak);
        String userNickName = ContextHolder.getUserNickName();
        tv_name.setText((CharSequence)userNickName);
        this.setAvatar();
    }

    private void setAvatar() {
        String userAvatar = ContextHolder.getUserAvatar();
        Glide.with((FragmentActivity)this.getActivity()).setDefaultRequestOptions(this.options_avatar).load((Object)userAvatar).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into((ImageView)this.mCircleImageView);
    }

    private void setWindow(Window window) {
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.gravity = 80;
        lp.alpha = 1.0f;
        lp.dimAmount = 0.5f;
        lp.width = -1;
        window.setAttributes(lp);
        window.addFlags(2);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (this.getActivity() instanceof TsdH5ReaderActivity) {
            this.h5ReaderActivity = (TsdH5ReaderActivity)this.getActivity();
        }
        Dialog dialog = new Dialog((Context)this.getActivity(), R.style.BottomDialog);
        dialog.requestWindowFeature(1);
        View contentview = View.inflate((Context)this.getActivity(), (int)R.layout.tsd_dialog_input, null);
        dialog.setContentView(contentview);
        dialog.setCanceledOnTouchOutside(true);
        Window window = dialog.getWindow();
        this.setWindow(window);
        this.et_comment = (EditText)contentview.findViewById(R.id.et_comment);
        if (!TextUtils.isEmpty((CharSequence)this.mHintText)) {
            this.et_comment.setHint((CharSequence)this.mHintText);
        }
        this.btn_publish = (Button)contentview.findViewById(R.id.btn_publish);
        this.et_comment.addTextChangedListener((TextWatcher)new MyTextWatcher());
        this.btn_publish.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TextUtils.isEmpty((CharSequence)InputDailog.this.et_comment.getText().toString())) {
                    Toast.makeText((Context)InputDailog.this.getActivity(), (CharSequence)"\u8f93\u5165\u5185\u5bb9\u4e3a\u7a7a", (int)1).show();
                } else {
                    Editable text = InputDailog.this.et_comment.getText();
                    if (!TextUtils.isEmpty((CharSequence)text)) {
                        String content = text.toString();
                        InputDailog.this.publish(content);
                    }
                }
            }
        });
        this.et_comment.setFocusable(true);
        this.et_comment.setFocusableInTouchMode(true);
        this.et_comment.requestFocus();
        this.initView(contentview);
        this.renderLikesCount();
        return dialog;
    }

    private void renderLikesCount() {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof TsdH5ReaderActivity) {
            TsdH5ReaderActivity h5ReaderActivity = (TsdH5ReaderActivity)activity;
            h5ReaderActivity.setTv_count();
        }
    }

    public void dismiss() {
        super.dismiss();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                KeyBoardUtil.hide((Activity)InputDailog.this.getActivity());
            }
        }, 200L);
    }

    public void publish(String content) {
        if (ContextHolder.isLogin()) {
            String userId = ContextHolder.getUserId();
            String userAvatar = ContextHolder.getUserAvatar();
            String userNickName = null == ContextHolder.getUserNickName() ? "unkonw" : ContextHolder.getUserNickName();
            String iid = (String)TsdSPUtils.get((Context)this.getActivity(), "iid", "");
            this.subCommEntity = this.getSubCreateComment();
            if (null != this.subCommEntity && this.h5ReaderActivity.mSubCommentsWidget.isShow()) {
                this.subCommEntity.superiorCommentId = this.h5ReaderActivity.mSubCommentsWidget.id;
            } else {
                this.subCommEntity = null;
            }
            new RestApiImpl().subComment(new CommentObserver(), iid, userId, userAvatar, userNickName, this.subCommEntity, content);
        }
    }

    public SubCommEntity getSubCreateComment() {
        this.subCommEntity = this.h5ReaderActivity.getSubCommentEntity();
        return this.subCommEntity;
    }

    private void renderData(String json) {
        PublishCommentEntity entity = GsonUtil.GsonToBean(json, PublishCommentEntity.class);
        this.et_comment.setText((CharSequence)"");
        SubCommentEntity subCommentEntity = entity.subCommentEntity;
        if (!this.h5ReaderActivity.mSubCommentsWidget.isShow()) {
            this.h5ReaderActivity.addComment(subCommentEntity);
        } else {
            subCommentEntity.parentCommentContent = this.h5ReaderActivity.getSubCommentEntity().parentCommentContent;
            this.h5ReaderActivity.addComment2(subCommentEntity);
            if (TextUtils.isEmpty((CharSequence)this.mHintText)) {
                subCommentEntity.parentCommentContent = null;
            }
        }
    }

    private class MyTextWatcher
    implements TextWatcher {
        private CharSequence temp;

        private MyTextWatcher() {
        }

        public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
            this.temp = charSequence;
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable editable) {
            if (this.temp.length() == 0) {
                InputDailog.this.btn_publish.setBackgroundResource(R.drawable.tsd_shape_pubsh_gay);
                InputDailog.this.et_here_speak.setText((CharSequence)"");
            } else {
                InputDailog.this.btn_publish.setBackgroundResource(R.drawable.tsd_shape_pubsh_blue);
                InputDailog.this.et_here_speak.setText(this.temp);
            }
            if (this.temp.length() > 100) {
                ToastUtil.showShort(ContextHolder.getContext(), "\u8f93\u5165\u7684\u5b57\u6570\u5df2\u8d85\u8fc7\u9650\u5236");
            }
        }
    }

    private final class CommentObserver
    extends StringCallback {
        private CommentObserver() {
        }

        public void onSuccess(Response<String> response) {
            InputDailog.this.dismiss();
            KeyBoardUtil.hide((Activity)InputDailog.this.getActivity());
            String json = (String)response.body();
            InputDailog.this.renderData(json);
        }

        public void onError(Response<String> response) {
            super.onError(response);
        }
    }
}

