/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.util;

import android.app.Activity;
import android.content.Context;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

public class KeyBoardUtil {
    private KeyBoardUtil() {
    }

    public static void show(Activity activity) {
        try {
            KeyBoardUtil.show(activity.getWindow().getCurrentFocus());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public static void show(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.showSoftInput(view, 2);
    }

    public static void hide(Activity activity) {
        try {
            KeyBoardUtil.hide(activity.getWindow().getCurrentFocus());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hide(View view) {
        try {
            InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public static void toggle(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.toggleSoftInput(0, 2);
    }

    public static void changeToEnglishInputType(EditText editText) {
        editText.setInputType(16);
    }

    public static void changeToChineseInputType(EditText editText) {
        editText.setInputType(1);
    }

    public static void setEnterKeyListener(EditText editText, final View.OnClickListener listener) {
        editText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 66 && event.getAction() == 0) {
                    listener.onClick(v);
                    return true;
                }
                return false;
            }
        });
    }
}

