/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InputMethodMemoryUtil {
    @TargetApi(value=19)
    public static void fixFocusedViewLeak(Application application) {
        Method finishInputLockedMethod;
        Field mHField;
        Field mServedViewField;
        if (Build.VERSION.SDK_INT < 15 || Build.VERSION.SDK_INT > 23) {
            return;
        }
        final InputMethodManager inputMethodManager = (InputMethodManager)application.getSystemService("input_method");
        try {
            mServedViewField = InputMethodManager.class.getDeclaredField("mServedView");
            mServedViewField.setAccessible(true);
            mHField = InputMethodManager.class.getDeclaredField("mServedView");
            mHField.setAccessible(true);
            finishInputLockedMethod = InputMethodManager.class.getDeclaredMethod("finishInputLocked", new Class[0]);
            finishInputLockedMethod.setAccessible(true);
            Method focusInMethod = InputMethodManager.class.getDeclaredMethod("focusIn", View.class);
            focusInMethod.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException unexpected) {
            Log.e((String)"IMMLeaks", (String)"Unexpected reflection exception", (Throwable)unexpected);
            return;
        }
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityDestroyed(Activity activity) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ReferenceCleaner cleaner = new ReferenceCleaner(inputMethodManager, mHField, mServedViewField, finishInputLockedMethod);
                View rootView = activity.getWindow().getDecorView().getRootView();
                ViewTreeObserver viewTreeObserver = rootView.getViewTreeObserver();
                viewTreeObserver.addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)cleaner);
            }
        });
    }

    static class ReferenceCleaner
    implements MessageQueue.IdleHandler,
    View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalFocusChangeListener {
        private final InputMethodManager inputMethodManager;
        private final Field mHField;
        private final Field mServedViewField;
        private final Method finishInputLockedMethod;

        ReferenceCleaner(InputMethodManager inputMethodManager, Field mHField, Field mServedViewField, Method finishInputLockedMethod) {
            this.inputMethodManager = inputMethodManager;
            this.mHField = mHField;
            this.mServedViewField = mServedViewField;
            this.finishInputLockedMethod = finishInputLockedMethod;
        }

        public void onGlobalFocusChanged(View oldFocus, View newFocus) {
            if (newFocus == null) {
                return;
            }
            if (oldFocus != null) {
                oldFocus.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            }
            Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
            newFocus.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
            Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)this);
        }

        public boolean queueIdle() {
            this.clearInputMethodManagerLeak();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TargetApi(value=19)
        private void clearInputMethodManagerLeak() {
            try {
                Object lock;
                Object object = lock = this.mHField.get(this.inputMethodManager);
                synchronized (object) {
                    View servedView = (View)this.mServedViewField.get(this.inputMethodManager);
                    if (servedView != null) {
                        boolean servedViewAttached;
                        boolean bl = servedViewAttached = servedView.getWindowVisibility() != 8;
                        if (servedViewAttached) {
                            servedView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                            servedView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                        } else {
                            Activity activity = this.extractActivity(servedView.getContext());
                            if (activity == null || activity.getWindow() == null) {
                                this.finishInputLockedMethod.invoke((Object)this.inputMethodManager, new Object[0]);
                            } else {
                                boolean windowAttached;
                                View decorView = activity.getWindow().peekDecorView();
                                boolean bl2 = windowAttached = decorView.getWindowVisibility() != 8;
                                if (!windowAttached) {
                                    this.finishInputLockedMethod.invoke((Object)this.inputMethodManager, new Object[0]);
                                } else {
                                    decorView.requestFocusFromTouch();
                                }
                            }
                        }
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException unexpected) {
                Log.e((String)"IMMLeaks", (String)"Unexpected reflection exception", (Throwable)unexpected);
            }
        }

        private Activity extractActivity(Context context) {
            while (true) {
                if (context instanceof Application) {
                    return null;
                }
                if (context instanceof Activity) {
                    return (Activity)context;
                }
                if (!(context instanceof ContextWrapper)) break;
                Context baseContext = ((ContextWrapper)context).getBaseContext();
                if (baseContext == context) {
                    return null;
                }
                context = baseContext;
            }
            return null;
        }
    }
}

