/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.presenter;

import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.util.CommonUtil;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import android.text.TextUtils;
import android.util.SparseArray;
import com.ak.android.engine.nav.NativeAd;
import com.qq.e.ads.nativ.NativeMediaADData;
import java.util.Iterator;
import java.util.List;

public class AdManager {
    private static String appid;
    private static String nativevideoposid;
    private static SparseArray<String> adSlots;
    private static SparseArray<NativeMediaADData> mediaADDataHashMap;
    private static SparseArray<NativeAd> mAd360EntitySparseArray;

    public static void init(List datas) {
        AdManager.clearAllAdSlots();
        if (null == datas) {
            return;
        }
        AdManager.removeUninitializedAds(datas);
    }

    private static void removeUninitializedAds(List datas) {
        int index = 0;
        Iterator sListIterator = datas.iterator();
        while (sListIterator.hasNext()) {
            Object o = sListIterator.next();
            AdManager.test(o, index, sListIterator);
            ++index;
        }
    }

    private static void test(Object o, int index, Iterator sListIterator) {
        if (o instanceof RecommendEntity.Data) {
            RecommendEntity.Data e = (RecommendEntity.Data)o;
            String type = AdManager.getType(e);
            AdManager.test2(type, e, index, sListIterator);
        }
    }

    private static void test2(String type, RecommendEntity.Data e, int index, Iterator sListIterator) {
        if (type.equals("ad")) {
            String adSrc = AdManager.getAdSrc(e);
            AdManager.test3(adSrc, e, index, sListIterator);
        }
    }

    private static void test3(String adSrc, RecommendEntity.Data e, int index, Iterator sListIterator) {
        if (adSrc.equals("qq.e")) {
            AdManager.saveQqAdInfo(e);
            adSlots.put(index, (Object)"qq.e");
            sListIterator.remove();
            return;
        }
        if (adSrc.equals("360")) {
            adSlots.put(index, (Object)"360");
            sListIterator.remove();
            return;
        }
    }

    private static String getType(RecommendEntity.Data data) {
        return null == data.type ? "" : data.type;
    }

    private static String getAdSrc(RecommendEntity.Data data) {
        RecommendEntity.Data2 data1 = data.data;
        return null == data1.src ? "" : data1.src;
    }

    public static String getAppId() {
        return appid;
    }

    public static String getNativevideoposid() {
        return nativevideoposid;
    }

    private static void clearAllAdSlots() {
        adSlots.clear();
        mediaADDataHashMap.clear();
        mAd360EntitySparseArray.clear();
    }

    private static void saveQqAdInfo(RecommendEntity.Data data) {
        appid = data.data.appid;
        nativevideoposid = data.data.nativevideoposid;
        if (!TextUtils.isEmpty((CharSequence)appid) && !TextUtils.isEmpty((CharSequence)nativevideoposid)) {
            CommonUtil.setAppId(ContextHolder.getContext(), appid);
            CommonUtil.setNativevideoposid(ContextHolder.getContext(), nativevideoposid);
        }
    }

    public static SparseArray<String> getAdSlots() {
        return adSlots;
    }

    public static void setMediaADDataHashMap(List<NativeMediaADData> ads) {
        for (int i = 0; i < ads.size(); ++i) {
            NativeMediaADData ad = ads.get(i);
            for (int j = 0; j < adSlots.size(); ++j) {
                int solt = adSlots.keyAt(i);
                mediaADDataHashMap.put(solt, (Object)ad);
            }
        }
    }

    public static void set360HashMap(NativeAd ad) {
        for (int j = 0; j < adSlots.size(); ++j) {
            int solt = adSlots.keyAt(j);
            String type = (String)adSlots.get(solt);
            if (!type.equals("360")) continue;
            mAd360EntitySparseArray.put(solt, (Object)ad);
        }
    }

    public static SparseArray<NativeMediaADData> getMediaADDataHashMap() {
        return mediaADDataHashMap;
    }

    public static SparseArray<NativeAd> getmAd360EntitySparseArray() {
        return mAd360EntitySparseArray;
    }

    static {
        adSlots = new SparseArray();
        mediaADDataHashMap = new SparseArray();
        mAd360EntitySparseArray = new SparseArray();
    }
}

