/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.net;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.model.YKSecretEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.YouKuManager;
import android.app.Application;
import android.text.TextUtils;
import com.firedata.sdk.Firedata;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.callback.Callback;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.GetRequest;
import com.lzy.okgo.request.PostRequest;

public class RestApiImpl
implements RestApi {
    @Override
    public void getConfig(StringCallback callback, String type) {
        String apiUrl = API_URL_CONFIG + TtCloudManager.getAppId();
        GetRequest request = OkGo.get((String)apiUrl);
        request.params("sid", TtCloudManager.getSid(), new boolean[0]);
        request.params("uid", FireDataManager.getGuid(), new boolean[0]);
        request.params("platform", "android", new boolean[0]);
        if (!TextUtils.isEmpty((CharSequence)type)) {
            request.params("type", type, new boolean[0]);
        }
        request.execute((Callback)callback);
    }

    @Override
    public void getYouKuConfig() {
        String apiUrl = API_URL_GET_YOUKU_SECRET + TtCloudManager.getAppId();
        GetRequest request = OkGo.get((String)apiUrl);
        request.params("uid", FireDataManager.getGuid(), new boolean[0]);
        request.params("src", "youku", new boolean[0]);
        request.params("platform", "android", new boolean[0]);
        request.execute((Callback)new StringCallback(){

            public void onSuccess(Response<String> response) {
                String s = (String)response.body();
                try {
                    YKSecretEntity entity = GsonUtil.GsonToBean(s, YKSecretEntity.class);
                    YKSecretEntity.Data data = entity.data;
                    String clientId = data.clientId;
                    String secret = data.clientSecret;
                    YouKuManager.setLog(true);
                    YouKuManager.setClientIdAndSecret(clientId, secret);
                    YouKuManager.onInitial((Application)ContextHolder.getContext());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onError(Response<String> response) {
                super.onError(response);
            }
        });
    }

    private String getColumnid(TopTitleEntity.Columns data, int secondDirectoryPosition) {
        String out_id = data.id;
        String in_id = "";
        if (null != data.subColumns && data.subColumns.size() > 0) {
            in_id = data.subColumns.get((int)secondDirectoryPosition).id;
        }
        if (out_id.equals(in_id)) {
            return out_id;
        }
        if (TextUtils.isEmpty((CharSequence)in_id)) {
            return out_id;
        }
        return out_id + "_" + in_id;
    }

    @Override
    public void feedList(StringCallback callback, String columnid, int st, String time) {
        GetRequest request = OkGo.get((String)API_URL_GET_FEED_LIST);
        request.params("appid", TtCloudManager.getAppId(), new boolean[0]);
        if (null != time) {
            request.params("time", time, new boolean[0]);
        }
        request.params("columnid", columnid, new boolean[0]);
        request.params("uid", Firedata.getGuid(), new boolean[0]);
        request.params("st", "" + st, new boolean[0]);
        request.params("ct", "6", new boolean[0]);
        request.params("platform", "android", new boolean[0]);
        if (st == 0) {
            request.params("widen", "1", new boolean[0]);
        }
        request.execute((Callback)callback);
    }

    @Override
    public void getFeedData(StringCallback callback, int start, String sid, TopTitleEntity.Columns data, int secondDirectoryPosition) {
        String columnid = this.getColumnid(data, secondDirectoryPosition);
        GetRequest request = OkGo.get((String)API_URL_GET_FEED_LIST);
        request.params("appid", TtCloudManager.getAppId(), new boolean[0]);
        request.params("columnid", columnid, new boolean[0]);
        request.params("uid", FireDataManager.getGuid(), new boolean[0]);
        request.params("st", start + "", new boolean[0]);
        request.params("ct", 6, new boolean[0]);
        request.params("sid", sid, new boolean[0]);
        request.params("sdk", "2.0", new boolean[0]);
        request.params("city", "1", new boolean[0]);
        request.params("platform", "android", new boolean[0]);
        request.params("network", "1", new boolean[0]);
        request.params("versionCode", String.valueOf(121), new boolean[0]);
        request.execute((Callback)callback);
    }

    @Override
    public void adClickHttp(String params) {
        ((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)OkGo.get((String)API_URL_AD_CLICK).params("appid", TtCloudManager.getAppId(), new boolean[0])).params("md", "home", new boolean[0])).params("uid", FireDataManager.getGuid(), new boolean[0])).params("sid", TtCloudManager.getSid(), new boolean[0])).params("params", params, new boolean[0])).params("platform", "android", new boolean[0])).execute((Callback)new StringCallback(){

            public void onSuccess(Response<String> response) {
            }
        });
    }

    @Override
    public void reportVid(int code, String iid) {
        ((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)OkGo.get((String)API_URL_AD_CLICK).params("appid", TtCloudManager.getAppId(), new boolean[0])).params("md", "1", new boolean[0])).params("uid", "1", new boolean[0])).params("sid", "1", new boolean[0])).params("iid", iid, new boolean[0])).params("platform", "android", new boolean[0])).execute((Callback)new StringCallback(){

            public void onSuccess(Response<String> response) {
            }
        });
    }

    @Override
    public void commentToService(String iid, Object alg, String action, String columnid, String num, String params) {
        String apiUrl = API_URL_UB + action;
        GetRequest request = OkGo.get((String)apiUrl);
        request.params("appid", TtCloudManager.getAppId(), new boolean[0]);
        request.params("columnid", columnid, new boolean[0]);
        request.params("sid", TtCloudManager.getSid(), new boolean[0]);
        request.params("uid", FireDataManager.getGuid(), new boolean[0]);
        if (!TextUtils.isEmpty((CharSequence)params)) {
            request.params("params", params, new boolean[0]);
        }
        if (!TextUtils.isEmpty((CharSequence)iid)) {
            request.params("iid", iid, new boolean[0]);
        }
        if (null != alg) {
            request.params("alg", alg.toString(), new boolean[0]);
        }
        if (!TextUtils.isEmpty((CharSequence)num)) {
            request.params("num", num, new boolean[0]);
        }
        request.params("platform", "android", new boolean[0]).execute((Callback)new StringCallback(){

            public void onSuccess(Response<String> response) {
            }
        });
    }

    @Override
    public void coldStartHttp(String action, String ext) {
        String apiUrl = API_URL_UB + action;
        GetRequest request = OkGo.get((String)apiUrl);
        request.params("appid", TtCloudManager.getAppId(), new boolean[0]);
        request.params("sid", TtCloudManager.getSid(), new boolean[0]);
        request.params("uid", FireDataManager.getGuid(), new boolean[0]);
        if (!TextUtils.isEmpty((CharSequence)ext)) {
            request.params("ext", ext, new boolean[0]);
        }
        request.params("platform", "android", new boolean[0]).execute(null);
    }

    public static void searchVideo(StringCallback callback, String keywords, String start) {
        ((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)OkGo.get((String)API_URL_SEARCH).params("appid", TtCloudManager.getAppId(), new boolean[0])).params("md", "search", new boolean[0])).params("sid", TtCloudManager.getSid(), new boolean[0])).params("uid", FireDataManager.getGuid(), new boolean[0])).params("st", start, new boolean[0])).params("ct", 10, new boolean[0])).params("kw", keywords, new boolean[0])).params("platform", "android", new boolean[0])).execute((Callback)callback);
    }

    @Override
    public void commentList(StringCallback callback, String iid, int current) {
        String apiUrl = API_URL_GET_COMMENT_LIST + TtCloudManager.getAppId() + "/list/" + iid + "/comment";
        ((GetRequest)((GetRequest)((GetRequest)OkGo.get((String)apiUrl).params("st", String.valueOf(current), new boolean[0])).params("ct", String.valueOf(10), new boolean[0])).params("platform", "android", new boolean[0])).execute((Callback)callback);
    }

    @Override
    public void subCommentList(String iid, String parentCommentId, String superiorCommentId, int st, StringCallback callback) {
        String apiUrl = API_URL_GET_COMMENT_LIST + TtCloudManager.getAppId() + "/list/" + iid + "/subComment";
        ((GetRequest)((GetRequest)((GetRequest)((GetRequest)OkGo.get((String)apiUrl).params("superiorCommentId", superiorCommentId, new boolean[0])).params("st", st, new boolean[0])).params("ct", 10, new boolean[0])).params("platform", "android", new boolean[0])).execute((Callback)callback);
    }

    @Override
    public void subComment(StringCallback callback, String iid, String userId, String avatar, String userNick, SubCommEntity commEntity, String content) {
        String apiUrl = API_URL_POST_COMMENT + TtCloudManager.getAppId() + "/create/" + iid + ".json";
        PostRequest request = OkGo.post((String)apiUrl);
        request.isMultipart(true);
        if (commEntity != null) {
            String parentId = commEntity.parentId;
            String parentIcon = commEntity.parentIcon;
            String parentNick = commEntity.parentNick;
            String parentCommentId = commEntity.parentCommentId;
            String superiorCommentId = commEntity.superiorCommentId;
            request.params("parentId", parentId, new boolean[0]);
            request.params("parentNick", parentNick, new boolean[0]);
            request.params("parentIcon", parentIcon, new boolean[0]);
            request.params("parentCommentId", parentCommentId, new boolean[0]);
            request.params("superiorCommentId", superiorCommentId, new boolean[0]);
        }
        request.params("userId", userId, new boolean[0]);
        request.params("userIcon", avatar, new boolean[0]);
        request.params("userNick", userNick, new boolean[0]);
        request.params("comment", content, new boolean[0]);
        request.params("platform", "android", new boolean[0]).execute((Callback)callback);
    }

    @Override
    public void comment(StringCallback callback, String iid, String userId, String avatar, String userNick, String content) {
        String apiUrl = API_URL_POST_COMMENT + TtCloudManager.getAppId() + "/create/" + iid + ".json";
        ((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)OkGo.get((String)apiUrl).params("userId", userId, new boolean[0])).params("userIcon", avatar, new boolean[0])).params("userNick", userNick, new boolean[0])).params("comment", content, new boolean[0])).params("platform", "android", new boolean[0])).execute((Callback)callback);
    }

    @Override
    public void like(StringCallback callback, String action, String iid) {
        String apiUrl = API_URL_POINT_UP + TtCloudManager.getAppId() + "/up/" + action + "/" + iid + ".json";
        OkGo.get((String)apiUrl).execute((Callback)callback);
    }
}

