/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.fragment;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.adapter.RecommendHomeAdapter;
import ai.botbrain.ttcloud.sdk.fragment.LazyLoadFragment;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.LoadingView;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;
import cn.bingoogolapple.refreshlayout.BGARefreshViewHolder;
import com.firedata.sdk.Firedata;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class RecommendHomeFragment
extends LazyLoadFragment
implements LoadingView.OnRetryListener,
AdapterView.OnItemClickListener,
BGARefreshLayout.BGARefreshLayoutDelegate,
RecommendHomeAdapter.NotiListener {
    public Context mContext;
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private LoadingView mLoadingView;
    public ListView mListView;
    private String cacheData;
    private int position;
    private int pageCurrent = 0;
    private int secondDirectoryPosition;
    private boolean PULL_TO_REFRESH = true;
    private String mSid;
    private List<RecommendEntity.Data> mDatas;
    private RecommendHomeAdapter recommendHomeAdapter;
    private TopTitleEntity.Columns mColumns;
    private FeedListObserver feedListObserver;
    private RestApi restApi;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private BGARefreshLayout mRefreshLayout;

    public static RecommendHomeFragment newInstance(int position, TopTitleEntity.Columns columns) {
        RecommendHomeFragment fragment = new RecommendHomeFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_PARAM1, position);
        args.putSerializable(ARG_PARAM2, (Serializable)columns);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mDatas = new ArrayList<RecommendEntity.Data>();
        this.feedListObserver = new FeedListObserver();
        this.restApi = new RestApiImpl();
        if (this.getArguments() != null) {
            this.position = this.getArguments().getInt(ARG_PARAM1);
            this.mColumns = (TopTitleEntity.Columns)this.getArguments().getSerializable(ARG_PARAM2);
            if (null == this.mColumns) {
                this.mColumns = new TopTitleEntity.Columns();
            }
        }
        List<TopTitleEntity.SubColumns> mSubColumns = this.mColumns.subColumns;
        this.recommendHomeAdapter = new RecommendHomeAdapter(this.mContext, this.mDatas, mSubColumns);
        this.recommendHomeAdapter.setNotiListener(this);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mListView = (ListView)this.findViewById(R.id.listview);
        ViewGroup.LayoutParams params = this.mListView.getLayoutParams();
        params.height = this.mListView.getHeight();
        params.height = 500;
        this.mListView.setLayoutParams(params);
        this.mListView.setAdapter((ListAdapter)this.recommendHomeAdapter);
        this.mListView.setRecyclerListener(new AbsListView.RecyclerListener(){

            public void onMovedToScrapHeap(View view) {
                int p = view.getId();
                if (p == ((RecommendHomeFragment)RecommendHomeFragment.this).recommendHomeAdapter.currentPlayingPosition && null != ((RecommendHomeFragment)RecommendHomeFragment.this).recommendHomeAdapter.youkuPlayerView && ((RecommendHomeFragment)RecommendHomeFragment.this).recommendHomeAdapter.youkuPlayerView.isPlaying()) {
                    ((RecommendHomeFragment)RecommendHomeFragment.this).recommendHomeAdapter.youkuPlayerView.pause();
                }
            }
        });
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mLoadingView = (LoadingView)((Object)this.findViewById(R.id.loading_view));
        this.mLoadingView.setOnRetryListener(this);
        this.cacheData = (String)TsdSPUtils.get(this.mContext, "pref_recommended_Home" + this.position, "");
        this.renderFeedList(this.cacheData, true);
        this.isCanLoadData();
    }

    @Override
    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.initRefreshLayout(view);
        return view;
    }

    @Override
    protected int setContentView() {
        return R.layout.tsd_fragment_recommend_home;
    }

    private void initRefreshLayout(View view) {
        this.mRefreshLayout = (BGARefreshLayout)view.findViewById(R.id.rl_modulename_refresh);
        this.mRefreshLayout.setDelegate((BGARefreshLayout.BGARefreshLayoutDelegate)this);
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(this.mContext, true);
        refreshViewHolder.setLoadingMoreText("\u52aa\u529b\u63a8\u8350\u4e2d");
        this.mRefreshLayout.setRefreshViewHolder((BGARefreshViewHolder)refreshViewHolder);
    }

    @Override
    protected void lazyLoad() {
        this.mRefreshLayout.beginRefreshing();
    }

    public void onPause() {
        super.onPause();
        Firedata.pageViewEnd((String)"recommend");
        if (null != this.recommendHomeAdapter && null != this.recommendHomeAdapter.youkuPlayerView) {
            this.recommendHomeAdapter.youkuPlayerView.onPause();
        }
    }

    public void onResume() {
        super.onResume();
        Firedata.pageViewStart((String)"recommend");
        if (null != this.recommendHomeAdapter && null != this.recommendHomeAdapter.youkuPlayerView) {
            this.recommendHomeAdapter.initPlayer(this.recommendHomeAdapter.youkuPlayerView);
            this.recommendHomeAdapter.youkuPlayerView.pause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (null != this.recommendHomeAdapter && null != this.recommendHomeAdapter.youkuPlayerView) {
            this.recommendHomeAdapter.youkuPlayerView.onDestroy();
        }
    }

    public synchronized void renderFeedList(String response, boolean cache) {
        try {
            response = response.equals("") ? "error" : response;
            RecommendEntity recommendEntity = GsonUtil.GsonToBean(response, RecommendEntity.class);
            TsdSPUtils.put(this.mContext, "pref_recommended_Home" + this.position, response);
            this.cacheData = response;
            if (this.PULL_TO_REFRESH) {
                this.mDatas.clear();
                this.pageCurrent = 0;
            }
            this.mDatas.addAll(recommendEntity.data);
            this.recommendHomeAdapter.notifyDataSetChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public void resetVideo() {
        if (null != this.recommendHomeAdapter) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (RecommendHomeFragment.this.recommendHomeAdapter.resetDatas()) {
                        RecommendHomeFragment.this.mainHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                RecommendHomeFragment.this.recommendHomeAdapter.notifyDataSetChanged();
                            }
                        }, 2000L);
                    }
                }
            }).start();
        }
    }

    public void onStart() {
        super.onStart();
    }

    public void onStop() {
        super.onStop();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mContext = activity;
    }

    public void onDetach() {
        super.onDetach();
        this.mContext = null;
    }

    private void setSelectedState(int secondDirectoryPosition) {
        List<TopTitleEntity.SubColumns> labelDatas = this.mColumns.subColumns;
        if (null == labelDatas) {
            return;
        }
        for (int i = 0; i < labelDatas.size(); ++i) {
            TopTitleEntity.SubColumns labelData = labelDatas.get(i);
            labelData.isSelected = i == secondDirectoryPosition;
        }
    }

    public void refresh(int secondDirectoryPosition) {
        this.secondDirectoryPosition = secondDirectoryPosition;
        this.setSelectedState(secondDirectoryPosition);
        this.PULL_TO_REFRESH = true;
        this.mSid = TimeUtil.getTimestamp();
        this.restApi.getFeedData(this.feedListObserver, 0, this.mSid, this.mColumns, secondDirectoryPosition);
    }

    @Override
    public void onRetry() {
        this.mLoadingView.notifyDataChanged(LoadingView.State.ing);
        FireDataManager.refresh("recommend");
        this.PULL_TO_REFRESH = true;
        this.mSid = TimeUtil.getTimestamp();
        this.restApi.getFeedData(this.feedListObserver, 0, this.mSid, this.mColumns, this.secondDirectoryPosition);
    }

    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {
        FireDataManager.refresh("recommend");
        this.PULL_TO_REFRESH = true;
        this.mSid = TimeUtil.getTimestamp();
        this.restApi.getFeedData(this.feedListObserver, 0, this.mSid, this.mColumns, this.secondDirectoryPosition);
    }

    private String getSid() {
        if (TextUtils.isEmpty((CharSequence)this.mSid)) {
            this.mSid = TimeUtil.getTimestamp();
        }
        return this.mSid;
    }

    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        FireDataManager.loadMore("recommend");
        this.pageCurrent += 6;
        this.PULL_TO_REFRESH = false;
        this.restApi.getFeedData(this.feedListObserver, this.pageCurrent, this.getSid(), this.mColumns, this.secondDirectoryPosition);
        return true;
    }

    @Override
    public void notifyData() {
        this.recommendHomeAdapter.notifyDataSetChanged();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mDatas.get(position) instanceof RecommendEntity.Data) {
            RecommendEntity.Data data = this.mDatas.get(position);
            this.recommendHomeAdapter.notifyDataSetChanged();
            if (data.type.equals("seeHere")) {
                this.mDatas.remove(position);
                this.mListView.smoothScrollToPosition(0);
                this.mRefreshLayout.beginRefreshing();
            } else if (data.type.equals("feed")) {
                data.data.has_read = true;
                RecommendEntity.Data2 data2 = data.data;
                String iid = null == data2.iid ? "" : data2.iid;
                Object alg = null == data2.alg ? "" : data2.alg;
                Intent intent = new Intent();
                intent.setClass(this.mContext, TsdH5ReaderActivity.class);
                intent.putExtra("extra_iid", iid);
                EventBus.getDefault().post((Object)new BuriedPointEvent("click", iid, alg, null, null));
                this.startActivity(intent);
            }
        }
    }

    private final class FeedListObserver
    extends StringCallback {
        private FeedListObserver() {
        }

        public void onError(Response<String> response) {
            super.onError(response);
            if (TextUtils.isEmpty((CharSequence)RecommendHomeFragment.this.cacheData)) {
                RecommendHomeFragment.this.mLoadingView.notifyDataChanged(LoadingView.State.error);
            }
            RecommendHomeFragment.this.mRefreshLayout.endRefreshing();
            RecommendHomeFragment.this.mRefreshLayout.endLoadingMore();
        }

        public void onSuccess(Response<String> response) {
            String s = (String)response.body();
            RecommendHomeFragment.this.mLoadingView.notifyDataChanged(LoadingView.State.done);
            RecommendHomeFragment.this.mRefreshLayout.endRefreshing();
            RecommendHomeFragment.this.mRefreshLayout.endLoadingMore();
            RecommendHomeFragment.this.renderFeedList(s, false);
        }
    }
}

