/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.fragment;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdChoiceLikeActivity;
import ai.botbrain.ttcloud.sdk.adapter.MyFragmentPagerAdapter;
import ai.botbrain.ttcloud.sdk.fragment.RecommendHomeFragment;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.ClickCategoryEvent;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.AppsListPresenter;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.LoadingView;
import ai.botbrain.ttcloud.sdk.widget.MyViewPager;
import ai.botbrain.ttcloud.sdk.widget.TabPageIndicator;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.firedata.sdk.Firedata;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class IndexFragment
extends Fragment
implements LoadingView.OnRetryListener {
    private static final String TAG = IndexFragment.class.getSimpleName();
    private TopTitleEntity topTitleEntity;
    private RestApi restApi;
    private int tab_position = 0;
    private String currentSubColumnsId;
    private String last_label_name;
    private String cache_title;
    private ArrayList<String> tabTitleArray;
    private List<String> label_idList;
    private View rootView;
    public LoadingView mLoadingView;
    private MyViewPager mViewPager;
    private TabPageIndicator mPageIndicator;
    private boolean isInitTop;
    private FragmentPagerAdapter adapter;
    private String arg_type;
    public static final String ARG_FEED_TYPE = "arg_type_video";
    public static final String TYPE_ARTICLE = "article";
    public static final String TYPE_VIDEO = "video";
    public AppNameListener appNameListener;
    private static final String VERSION_KEY = "version_key";

    public static IndexFragment newInstance(String type) {
        IndexFragment fragment = new IndexFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_FEED_TYPE, type);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static IndexFragment newInstance() {
        return IndexFragment.newInstance(null);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        ViewGroup parent;
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.tsd_fragment_index, container, false);
            this.initView(this.rootView);
        }
        if ((parent = (ViewGroup)this.rootView.getParent()) != null) {
            parent.removeView(this.rootView);
        }
        return this.rootView;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.cache_title = (String)TsdSPUtils.get((Context)this.getActivity(), "pref_channel" + this.arg_type, "");
        if (!TextUtils.isEmpty((CharSequence)this.cache_title)) {
            this.renderConfig(this.cache_title);
        }
        this.restApi.getConfig(new ConfigObserver(), this.arg_type);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.arg_type = this.getArguments().getString(ARG_FEED_TYPE);
        }
        this.mLoadingView = new LoadingView(ContextHolder.getContext());
        this.restApi = new RestApiImpl();
        AppsListPresenter.upload(ContextHolder.getContext());
        this.initJsHttp();
        this.initData();
    }

    private void initData() {
        this.label_idList = new ArrayList<String>();
    }

    private void cache(String response) {
        TsdSPUtils.put((Context)this.getActivity(), "pref_channel" + this.arg_type, response);
    }

    private ArrayList<String> getTabTitleArray(TopTitleEntity topTitleEntity) {
        this.label_idList.clear();
        if (null == topTitleEntity || null == topTitleEntity.data) {
            return null;
        }
        this.tabTitleArray = new ArrayList();
        List<TopTitleEntity.Columns> datas = topTitleEntity.data.columns;
        if (null == datas || datas.size() == 0) {
            return null;
        }
        for (TopTitleEntity.Columns data : datas) {
            String label_name = data.name;
            String label_id = data.id;
            this.tabTitleArray.add(label_name);
            this.label_idList.add(label_id);
        }
        return this.tabTitleArray;
    }

    private void renderConfig(String response) {
        if (TextUtils.isEmpty((CharSequence)response)) {
            return;
        }
        this.cache(response);
        try {
            this.topTitleEntity = GsonUtil.GsonToBean(response, TopTitleEntity.class);
            this.coldStart(this.topTitleEntity);
            String app_name = this.topTitleEntity.appName;
            if (this.appNameListener != null) {
                this.appNameListener.appName(app_name);
            }
            this.initSecondaryDirectoryStatus(this.topTitleEntity);
            this.initView(this.getView());
            this.tabTitleArray = this.getTabTitleArray(this.topTitleEntity);
            this.initTabLayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void coldStart(TopTitleEntity topTitleEntity) {
        String enable;
        TopTitleEntity.Data data = topTitleEntity.data;
        if (null == data.coldStart) {
            return;
        }
        TopTitleEntity.ColdStart coldStart = data.coldStart;
        String appName = null == topTitleEntity.appName ? "" : topTitleEntity.appName;
        String string2 = enable = null == coldStart.enable ? "" : coldStart.enable;
        if (enable.equals("on") && this.isFirstLauncher()) {
            Intent intent = new Intent();
            intent.setClass((Context)this.getActivity(), TsdChoiceLikeActivity.class);
            intent.putExtra("ACTION_COLDSTART", (Serializable)coldStart);
            intent.putExtra("ACTION_APP_NAME", appName);
            this.getActivity().startActivity(intent);
        }
    }

    public void setAppNameListener(AppNameListener listener) {
        this.appNameListener = listener;
    }

    private synchronized void initTabLayout() {
        if (!this.isInitTop) {
            this.adapter = new MyFragmentPagerAdapter(this.getChildFragmentManager(), this.topTitleEntity.data);
            this.mViewPager.setAdapter((PagerAdapter)this.adapter);
            this.isInitTop = true;
        } else {
            this.adapter.notifyDataSetChanged();
        }
        this.mPageIndicator.setViewPager(this.mViewPager, 0);
        this.mPageIndicator.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                try {
                    IndexFragment.this.tab_position = position;
                    IndexFragment.this.slideEventSend(position);
                    int count = null == ((IndexFragment)IndexFragment.this).topTitleEntity.data.columns ? 0 : ((IndexFragment)IndexFragment.this).topTitleEntity.data.columns.size();
                    for (int i = 0; i < count; ++i) {
                        Fragment fragment = IndexFragment.this.getVisibleFragment(i);
                        if (!(fragment instanceof RecommendHomeFragment)) continue;
                        ((RecommendHomeFragment)fragment).resetVideo();
                    }
                    IndexFragment.this.getSubColumnsIdBy(IndexFragment.this.tab_position, 0);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    @Override
    public void onRetry() {
        this.restApi.getConfig(new ConfigObserver(), this.arg_type);
    }

    private void initView(View view) {
        RelativeLayout rl_title = (RelativeLayout)view.findViewById(R.id.rl_title);
        this.mLoadingView = (LoadingView)view.findViewById(R.id.loading_view);
        this.mLoadingView.setOnRetryListener(this);
        this.mViewPager = (MyViewPager)view.findViewById(R.id.bot_news_pager);
        this.mPageIndicator = (TabPageIndicator)view.findViewById(R.id.indicator);
        this.mPageIndicator.setViewHolderCreator(new TabPageIndicator.ViewHolderCreator(){

            @Override
            public TabPageIndicator.ViewHolderBase createViewHolder() {
                return new DemoViewHolder();
            }
        });
        this.mPageIndicator.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                IndexFragment.this.slideEventSend(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        if (ContextHolder.isShowActionBar()) {
            rl_title.setVisibility(8);
        }
        this.mViewPager.setOffscreenPageLimit(10);
    }

    private void initSecondaryDirectoryStatus(TopTitleEntity topTitleEntity) {
        List<TopTitleEntity.Columns> datas = topTitleEntity.data.columns;
        if (null == datas || datas.size() <= 0) {
            return;
        }
        for (TopTitleEntity.Columns labelData : datas) {
            List<TopTitleEntity.SubColumns> labelDatas = labelData.subColumns;
            if (null == labelDatas || labelDatas.size() <= 0) continue;
            TopTitleEntity.SubColumns data = labelDatas.get(0);
            data.isSelected = true;
        }
    }

    private void initJsHttp() {
        new Thread(){

            @Override
            public void run() {
                super.run();
                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
            }
        }.start();
    }

    private Fragment getVisibleFragment(int position) {
        Fragment someFragment = this.getChildFragmentManager().findFragmentByTag("android:switcher:" + R.id.bot_news_pager + ":" + position);
        if (someFragment != null && someFragment.getView() != null) {
            return someFragment;
        }
        return null;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(String event) {
        try {
            String[] ss = event.split("://");
            String a = ss[1].split("/")[0];
            for (int i = 0; i < this.label_idList.size(); ++i) {
                String label_id = this.label_idList.get(i);
                if (!a.equals(label_id)) continue;
                this.mViewPager.setCurrentItem(i);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getSubColumnsIdBy(int tab_position, int subColumns_position) {
        if (null == this.topTitleEntity || null == this.topTitleEntity.data) {
            return;
        }
        try {
            TopTitleEntity.Columns columns = this.topTitleEntity.data.columns.get(tab_position);
            if (null == columns.subColumns || columns.subColumns.size() <= 0) {
                return;
            }
            this.currentSubColumnsId = columns.subColumns.get((int)subColumns_position).id;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onMessageEvent(ClickCategoryEvent event) {
        int position = event.position;
        RecommendHomeFragment fragment = (RecommendHomeFragment)this.getVisibleFragment(this.tab_position);
        this.getSubColumnsIdBy(this.tab_position, position);
        if (null != fragment) {
            fragment.refresh(position);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onMessageEvent(BuriedPointEvent event) {
        if (null == this.topTitleEntity || null == this.topTitleEntity.data) {
            return;
        }
        String columns_id = this.topTitleEntity.data.columns.get((int)this.tab_position).id;
        String iid = event.getIid();
        Object alg = event.getAlg();
        String action = event.getAction();
        String num = event.getNum();
        this.currentSubColumnsId = null == this.currentSubColumnsId ? "" : this.currentSubColumnsId;
        this.restApi.commentToService(iid, alg, action, columns_id + "_" + this.currentSubColumnsId, num, null);
    }

    private void slideEventSend(int position) {
        this.tab_position = position;
        if (null == this.topTitleEntity || null == this.topTitleEntity.data) {
            return;
        }
        if (null == this.topTitleEntity.data.columns) {
            return;
        }
        if (position >= this.topTitleEntity.data.columns.size()) {
            return;
        }
        String label_id = this.topTitleEntity.data.columns.get((int)position).id;
        LogUtil.i(TAG, label_id);
        if (!TextUtils.isEmpty((CharSequence)this.last_label_name)) {
            Firedata.pageViewEnd((String)this.last_label_name);
        }
        Firedata.pageViewStart((String)label_id);
        this.last_label_name = label_id;
    }

    public void onStart() {
        super.onStart();
        EventBus.getDefault().register((Object)this);
    }

    public void onStop() {
        super.onStop();
        EventBus.getDefault().unregister((Object)this);
    }

    private boolean isFirstLauncher() {
        SharedPreferences prefs;
        int lastVersion;
        int currentVersion = IndexFragment.getAppVersionCode(ContextHolder.getContext());
        if (currentVersion > (lastVersion = (prefs = PreferenceManager.getDefaultSharedPreferences((Context)ContextHolder.getContext())).getInt(VERSION_KEY, 0))) {
            prefs.edit().putInt(VERSION_KEY, currentVersion).apply();
            return true;
        }
        return false;
    }

    public static int getAppVersionCode(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            return pi.versionCode;
        }
        catch (Exception e) {
            Log.e((String)"VersionInfo", (String)"Exception", (Throwable)e);
            return 16843292;
        }
    }

    private final class ConfigObserver
    extends StringCallback {
        private ConfigObserver() {
        }

        public void onError(Response<String> response) {
            super.onError(response);
            if (TextUtils.isEmpty((CharSequence)IndexFragment.this.cache_title)) {
                IndexFragment.this.mLoadingView.notifyDataChanged(LoadingView.State.error);
            }
        }

        public void onSuccess(Response<String> response) {
            String s = (String)response.body();
            IndexFragment.this.mLoadingView.notifyDataChanged(LoadingView.State.done);
            IndexFragment.this.renderConfig(s);
        }
    }

    private class DemoViewHolder
    extends TabPageIndicator.ViewHolderBase {
        private TextView mTitleTextView;
        private final int COLOR_TEXT_SELECTED = Color.parseColor((String)"#37baf9");
        private final int COLOR_TEXT_NORMAL = Color.parseColor((String)"#333333");

        private DemoViewHolder() {
        }

        @Override
        public View createView(LayoutInflater layoutInflater, int position) {
            ViewGroup nullParent = null;
            View view = layoutInflater.inflate(R.layout.tsd_ht_views_bimai_cat_item, nullParent);
            this.mTitleTextView = (TextView)view.findViewById(R.id.tv_ht_bimai_cat_item_title);
            return view;
        }

        @Override
        public void updateView(int position, boolean isCurrent) {
            if (null != IndexFragment.this.tabTitleArray && IndexFragment.this.tabTitleArray.size() > position) {
                this.mTitleTextView.setText((CharSequence)IndexFragment.this.tabTitleArray.get(position));
            }
            if (isCurrent) {
                this.mTitleTextView.setTextColor(this.COLOR_TEXT_SELECTED);
            } else {
                this.mTitleTextView.setTextColor(this.COLOR_TEXT_NORMAL);
            }
        }
    }

    public static interface AppNameListener {
        public void appName(String var1);
    }
}

