/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.adapter;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.adapter.TsdBaseAdapter;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.widget.TsdCircleImageView;
import android.app.Activity;
import android.content.Context;
import android.text.Html;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import java.util.List;

public class ContentAdapter
extends TsdBaseAdapter
implements View.OnClickListener {
    private Context mContext;
    private List mData;
    private static final int TYPE_NO_COMMENT = 0;
    private static final int TYPE_NOR = 1;
    private static final int TYPE_ALL_COMPLETE = 2;
    private static final int TYPE_COUNT = 3;

    public ContentAdapter(Context context, List data) {
        this.mContext = context;
        this.mData = data;
    }

    @Override
    public int getCount() {
        return null == this.mData || this.mData.size() == 0 ? 1 : this.mData.size();
    }

    @Override
    public Object getItem(int i) {
        return null;
    }

    @Override
    public long getItemId(int i) {
        return 0L;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.mData.size() == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        int type = this.getItemViewType(position);
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            switch (type) {
                case 0: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_include_no_comment, null);
                    viewHolder.tv_no_comment = (TextView)convertView.findViewById(R.id.tv_no_comment);
                    break;
                }
                case 1: {
                    convertView = View.inflate((Context)this.mContext, (int)R.layout.tsd_adapter_content, null);
                    viewHolder.tv_content = (TextView)convertView.findViewById(R.id.tv_content);
                    viewHolder.ll_reply = (LinearLayout)convertView.findViewById(R.id.ll_reply);
                    viewHolder.tv_user_nick = (TextView)convertView.findViewById(R.id.tv_user_nick);
                    viewHolder.tv_subComment = (TextView)convertView.findViewById(R.id.tv_subComment);
                    viewHolder.iv_avatar = (TsdCircleImageView)convertView.findViewById(R.id.iv_avatar);
                    viewHolder.tv_time = (TextView)convertView.findViewById(R.id.tv_time);
                    viewHolder.tv_all_reply = (TextView)convertView.findViewById(R.id.tv_all_reply);
                    viewHolder.tv_reply = (TextView)convertView.findViewById(R.id.tv_reply);
                    viewHolder.tv_all_reply.setOnClickListener((View.OnClickListener)this);
                    viewHolder.tv_reply.setOnClickListener((View.OnClickListener)this);
                    break;
                }
            }
            if (null != convertView) {
                convertView.setTag((Object)viewHolder);
            }
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        if (type == 1) {
            viewHolder.tv_all_reply.setTag((Object)position);
            viewHolder.tv_reply.setTag((Object)position);
            this.renderNor(viewHolder, position);
        } else if (type == 0) {
            this.renderNoComment(viewHolder);
        } else if (type == 2) {
            // empty if block
        }
        return convertView;
    }

    private void renderNoComment(ViewHolder viewHolder) {
        if (ContextHolder.getHideComment()) {
            viewHolder.tv_no_comment.setText((CharSequence)this.mContext.getResources().getString(R.string.tsd_no_comments));
        } else {
            viewHolder.tv_no_comment.setText((CharSequence)this.mContext.getResources().getString(R.string.tsd_no_comments_click_publish));
        }
    }

    private void setllReply(SubCommentEntity.LatestsubComment mLatestsubComment, ViewHolder viewHolder) {
        if (null == mLatestsubComment) {
            viewHolder.ll_reply.setVisibility(8);
            return;
        }
        viewHolder.ll_reply.setVisibility(0);
        String commentContent = mLatestsubComment.commentContent;
        String userNick = null == mLatestsubComment.userNick ? "" : mLatestsubComment.userNick;
        userNick = userNick + ":";
        viewHolder.tv_subComment.setText((CharSequence)Html.fromHtml((String)("<font color='#406599'>" + userNick + "</font>" + commentContent)));
    }

    private void renderNor(ViewHolder viewHolder, int position) {
        String subCommentNum;
        SubCommentEntity data = (SubCommentEntity)this.mData.get(position);
        SubCommentEntity.LatestsubComment mLatestsubComment = data.latestsubComment;
        String commentContent = null == data.commentContent ? "" : data.commentContent;
        String userIcon = null == data.userAvatar ? "" : data.userAvatar;
        String commentTime = null == data.commentTime ? "" : data.commentTime;
        commentTime = TimeUtil.getStrTime(commentTime);
        commentTime = TimeUtil.getNiceDate(commentTime);
        String userNick = null == data.userNickName ? "" : data.userNickName;
        String string2 = subCommentNum = null == data.subCommentNum ? "" : data.subCommentNum;
        if (subCommentNum.equals("0")) {
            subCommentNum = "";
        }
        viewHolder.tv_reply.setText((CharSequence)(subCommentNum + "\u56de\u590d"));
        this.setllReply(mLatestsubComment, viewHolder);
        viewHolder.tv_content.setText((CharSequence)commentContent);
        viewHolder.tv_user_nick.setText((CharSequence)userNick);
        viewHolder.tv_time.setText((CharSequence)commentTime);
        Glide.with((Context)this.mContext).setDefaultRequestOptions(this.options_avatar).load((Object)userIcon).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(500)).into((ImageView)viewHolder.iv_avatar);
    }

    public void clickAllReply(int position) {
        Activity activity = (Activity)this.mContext;
        if (!(activity instanceof TsdH5ReaderActivity)) {
            return;
        }
        SubCommentEntity data = (SubCommentEntity)this.mData.get(position);
        TsdH5ReaderActivity readerActivity = (TsdH5ReaderActivity)activity;
        readerActivity.showContentWidget(data);
        SubCommEntity subCommEntity = new SubCommEntity();
        subCommEntity.parentId = data.id;
        subCommEntity.parentCommentId = data.id;
        subCommEntity.superiorCommentId = data.id;
        subCommEntity.parentNick = data.userNickName;
        subCommEntity.parentIcon = data.userAvatar;
        readerActivity.setSubCommEntity(subCommEntity);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_all_reply || id2 == R.id.tv_reply) {
            int position = (Integer)v.getTag();
            this.clickAllReply(position);
        }
    }

    private static class ViewHolder {
        private TextView tv_content;
        private TextView tv_subComment;
        private LinearLayout ll_reply;
        private TextView tv_all_reply;
        private TextView tv_reply;
        private TextView tv_no_comment;
        private TextView tv_user_nick;
        private TextView tv_time;
        private TsdCircleImageView iv_avatar;

        private ViewHolder() {
        }
    }
}

