/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.activity;

import ai.botbrain.ttcloud.api.TtCloudListener;
import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.adapter.ContentAdapter;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentsEntity;
import ai.botbrain.ttcloud.sdk.model.UpCountEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.swipeBack.SwipeBackActivity;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.KeyBoardUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.ScreenUtils;
import ai.botbrain.ttcloud.sdk.util.ToastUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.InputDailog;
import ai.botbrain.ttcloud.sdk.widget.SubCommentsWidget;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AdapterView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;
import cn.bingoogolapple.refreshlayout.BGARefreshViewHolder;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class TsdH5ReaderActivity
extends SwipeBackActivity
implements TextView.OnEditorActionListener,
AdapterView.OnItemClickListener,
BGARefreshLayout.BGARefreshLayoutDelegate {
    private static final String TAG = TsdH5ReaderActivity.class.getSimpleName();
    private Context mContext;
    private ImageButton btn_up;
    private WebView mWebView;
    private ListView mListView;
    private TextView tv_count;
    private ContentAdapter mAdapter;
    private LinearLayout bottom_bar;
    private TextView tv_title;
    public SubCommentsWidget mSubCommentsWidget;
    private RestApi restApi;
    private CommentListObserver commentListObserver;
    private LikeObserver likeObserver;
    private BGARefreshLayout mRefreshLayout;
    private RelativeLayout rl_container;
    public String iid;
    private String title;
    private String mColumnId;
    private String contentUrl;
    private String shareThumb;
    private String toast_liked;
    private String toast_complete;
    private boolean isClickLike = false;
    private SubCommEntity mSubCommEntity;
    public InputDailog dialog;
    private static final String EXTRA_URL = "extra_url";
    private String mUrl;
    private List<SubCommentEntity> datas;
    private int likesCount;
    private int current = 0;
    private boolean isShownLoadMoreView = false;
    boolean isCanLoadMore = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 19) {
            WindowManager.LayoutParams localLayoutParams = this.getWindow().getAttributes();
            localLayoutParams.flags = 0x4000000 | localLayoutParams.flags;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        }
        this.setContentView(R.layout.tsd_activity_h5_reader2);
        this.initVariables();
        this.initView();
    }

    public void showInputDialog() {
        this.dialog = InputDailog.newInstance("\u56de\u590d" + this.mSubCommEntity.parentNick);
        this.dialog.show(this.getSupportFragmentManager(), "dialog");
    }

    public void setSubCommEntity(SubCommEntity subCommEntity) {
        this.mSubCommEntity = subCommEntity;
    }

    public SubCommEntity getSubCommentEntity() {
        return this.mSubCommEntity;
    }

    private void initVariables() {
        this.mContext = this;
        this.initResString();
        this.dialog = new InputDailog();
        this.restApi = new RestApiImpl();
        this.commentListObserver = new CommentListObserver();
        this.likeObserver = new LikeObserver();
        this.initParams();
        if (null == this.datas) {
            this.datas = new ArrayList<SubCommentEntity>();
        }
        this.mAdapter = new ContentAdapter(this.mContext, this.datas);
    }

    private void initResString() {
        this.toast_liked = ContextHolder.getContext().getResources().getString(R.string.tsd_toast_liked);
        this.toast_complete = ContextHolder.getContext().getResources().getString(R.string.tsd_toast_complete);
    }

    private void initRefreshLayout() {
        this.mRefreshLayout = (BGARefreshLayout)this.findViewById(R.id.rl_modulename_refresh);
        this.mRefreshLayout.setDelegate((BGARefreshLayout.BGARefreshLayoutDelegate)this);
        this.mRefreshLayout.setPullDownRefreshEnable(false);
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(this.mContext, true);
        this.mRefreshLayout.setRefreshViewHolder((BGARefreshViewHolder)refreshViewHolder);
    }

    public void showContentWidget(SubCommentEntity data) {
        this.mSubCommentsWidget.show();
        this.mSubCommentsWidget.renderTop(data);
    }

    private void setSubWidgetPaddTopHeight() {
        int top = ScreenUtils.getStatusHeight((Activity)this);
        this.rl_container.setPadding(0, top, 0, 0);
    }

    private void initView() {
        this.initRefreshLayout();
        this.rl_container = (RelativeLayout)this.findViewById(R.id.rl_container);
        this.setSubWidgetPaddTopHeight();
        this.mSubCommentsWidget = (SubCommentsWidget)this.findViewById(R.id.contents_widget);
        this.mSubCommentsWidget.setEnabled(true);
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        ImageView iv_back = (ImageView)this.findViewById(R.id.iv_back);
        this.mListView = (ListView)this.findViewById(R.id.listview);
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.addWebViewToListView(this.mListView);
        this.tv_count = (TextView)this.findViewById(R.id.tv_count);
        this.btn_up = (ImageButton)this.findViewById(R.id.btn_up);
        this.bottom_bar = (LinearLayout)this.findViewById(R.id.bottom_bar);
        this.initWebView();
        this.contentUrl = TextUtils.isEmpty((CharSequence)this.contentUrl) ? "" : this.contentUrl;
        this.mWebView.loadUrl(this.contentUrl + "&type=2");
        this.restApi.like(this.likeObserver, "get", this.iid);
        this.hideBottomLayout();
        iv_back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TsdH5ReaderActivity.this.finish();
            }
        });
    }

    private void hideBottomLayout() {
        if (ContextHolder.getHideComment()) {
            this.bottom_bar.setVisibility(8);
        } else {
            this.bottom_bar.setVisibility(0);
        }
    }

    private void addWebViewToListView(ListView listView) {
        View view = View.inflate((Context)this.mContext, (int)R.layout.tsd_adapter_webview, null);
        this.mWebView = (WebView)view.findViewById(R.id.content);
        listView.addHeaderView(view, null, false);
    }

    private void initParams() {
        Intent intent = this.getIntent();
        if (intent != null) {
            this.iid = intent.getStringExtra("extra_iid");
            TsdSPUtils.put(this.mContext, "iid", this.iid);
            if (intent.hasExtra("extra_column_id")) {
                this.mColumnId = intent.getStringExtra("extra_column_id");
            }
            this.mUrl = intent.getStringExtra(EXTRA_URL);
            this.contentUrl = this.getContentUrlByIid(this.iid);
            LogUtil.i(TAG, "contentUrl:" + this.contentUrl);
        }
    }

    private void setlikeCount() {
        this.tv_count.setVisibility(0);
        this.mSubCommentsWidget.tv_widget_count.setVisibility(0);
        this.btn_up.setImageResource(R.drawable.tsd_like_press);
        this.mSubCommentsWidget.ib_widget_like.setImageResource(R.drawable.tsd_like_press);
        this.btn_up.setActivated(true);
        this.mSubCommentsWidget.ib_widget_like.setActivated(true);
    }

    public void clickUp(View view) {
        if (!this.isClickLike) {
            this.setlikeCount();
            TtCloudListener.Article article = new TtCloudListener.Article();
            article.setContentTitle(this.title);
            article.setContentUrl(this.contentUrl);
            ContextHolder.getTtCloudListener().onLiked(article, ContextHolder.getUser());
            this.isClickLike = true;
            this.restApi.like(this.likeObserver, "count", this.iid);
        } else {
            ToastUtil.showShort(ContextHolder.getContext(), this.toast_liked);
        }
    }

    public void back(View view) {
        this.finish();
    }

    public void openShare(View view) {
        TtCloudListener.Article article = new TtCloudListener.Article();
        article.setContentTitle(this.title);
        article.setContentUrl(this.contentUrl + "&type=4");
        if (!TextUtils.isEmpty((CharSequence)this.shareThumb)) {
            article.setThumb(this.shareThumb);
        }
        ContextHolder.getTtCloudListener().onShare(view, article, ContextHolder.getUser(), new TtCloudListener.ResultCallBack(){

            @Override
            public void success() {
            }

            @Override
            public void failed() {
            }

            @Override
            public void setUserInfo(TtCloudListener.User user) {
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
        boolean handled = false;
        if (actionId == 6) {
            ToastUtil.showShort(ContextHolder.getContext(), this.toast_complete);
            handled = true;
            KeyBoardUtil.hide((Activity)this.mContext);
        }
        return handled;
    }

    private void setTextSize() {
        this.mWebView.getSettings().setSupportZoom(true);
        int size = ContextHolder.getFont_size();
        if (size == 12) {
            this.mWebView.getSettings().setTextSize(WebSettings.TextSize.SMALLER);
        } else if (size == 18) {
            this.mWebView.getSettings().setTextSize(WebSettings.TextSize.LARGER);
        } else if (size == 20) {
            this.mWebView.getSettings().setTextSize(WebSettings.TextSize.LARGEST);
        } else {
            this.mWebView.getSettings().setTextSize(WebSettings.TextSize.NORMAL);
        }
    }

    @JavascriptInterface
    public void getImagesFromHtml(String json) {
        try {
            JSONArray jsonArray = new JSONArray(json);
            this.shareThumb = jsonArray.optString(0);
            LogUtil.i(TAG, "This method is called!" + this.shareThumb);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebView() {
        WebChromeClient mWebChromeClient = new WebChromeClient();
        this.mWebView.setWebChromeClient(mWebChromeClient);
        this.mWebView.addJavascriptInterface((Object)this, "botbrain");
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                TsdH5ReaderActivity.this.title = view.getTitle();
                TsdH5ReaderActivity.this.tv_title.setText((CharSequence)TsdH5ReaderActivity.this.title);
                TsdH5ReaderActivity.this.mListView.setAdapter((ListAdapter)TsdH5ReaderActivity.this.mAdapter);
                TsdH5ReaderActivity.this.current = 0;
                TsdH5ReaderActivity.this.datas.clear();
                TsdH5ReaderActivity.this.restApi.commentList(TsdH5ReaderActivity.this.commentListObserver, TsdH5ReaderActivity.this.iid, TsdH5ReaderActivity.this.current);
            }
        });
        this.setTextSize();
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setBlockNetworkImage(false);
        this.mWebView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.mWebView.getSettings().setUserAgentString(this.mWebView.getSettings().getUserAgentString());
        this.mWebView.getSettings().setDatabaseEnabled(true);
        this.mWebView.setScrollBarStyle(0);
        LogUtil.i(TAG, this.mWebView.getSettings().getUserAgentString());
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.getSettings().setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT > 15) {
            this.mWebView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 17) {
            this.fixWebView();
        }
    }

    @TargetApi(value=11)
    private void fixWebView() {
        this.mWebView.removeJavascriptInterface("searchBoxJavaBridge_");
    }

    private void renderCommentList(String json) {
        SubCommentsEntity entity = GsonUtil.GsonToBean(json, SubCommentsEntity.class);
        this.datas.addAll(entity.data);
        if (this.datas.size() > 0 && !this.isShownLoadMoreView) {
            this.isShownLoadMoreView = true;
        }
        if (this.datas.size() <= 0 || this.current <= 0 || entity.data.size() == 0) {
            // empty if block
        }
        if (entity.data.size() < 6 && this.datas.size() != 0) {
            this.mRefreshLayout.setIsShowLoadingMoreView(false);
            View v = View.inflate((Context)this.mContext, (int)R.layout.tsd_item_all_complete, null);
            this.mListView.addFooterView(v);
            this.isCanLoadMore = false;
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void writeCommentClick(View view) {
        if (!ContextHolder.isLogin()) {
            ContextHolder.getTtCloudListener().onComment(view, null, null);
        } else {
            TsdH5ReaderActivity tsdH5ReaderActivity = this;
            tsdH5ReaderActivity.dialog.newInstance().show(this.getSupportFragmentManager(), "dialog");
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (position == 1 && this.datas.size() == 0 && !ContextHolder.getHideComment()) {
            InputDailog.newInstance().show(this.getSupportFragmentManager(), "dialog");
            return;
        }
        if (this.datas.size() > position - 1) {
            this.mAdapter.clickAllReply(--position);
        }
    }

    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {
    }

    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        if (!this.isCanLoadMore) {
            return this.isCanLoadMore;
        }
        this.current += 10;
        this.restApi.commentList(this.commentListObserver, this.iid, this.current);
        return this.isCanLoadMore;
    }

    public void addComment2(SubCommentEntity data) {
        this.mSubCommentsWidget.mDatas.add(0, data);
        this.mSubCommentsWidget.mListView.smoothScrollToPosition(0);
        this.mSubCommentsWidget.mSubCommentAdapter.notifyDataSetChanged();
        this.mSubCommentsWidget.renderReplyNum();
    }

    public void addComment(SubCommentEntity subCommentEntity) {
        if (!this.isShownLoadMoreView) {
            this.isShownLoadMoreView = true;
        }
        this.datas.add(0, subCommentEntity);
        this.mAdapter.notifyDataSetChanged();
    }

    private void isShowLoadMoreView() {
        if (this.datas.size() == 0) {
            this.mRefreshLayout.setIsShowLoadingMoreView(false);
        } else {
            this.mRefreshLayout.setIsShowLoadingMoreView(true);
        }
    }

    public void setTv_count() {
        if (this.likesCount > 0) {
            this.tv_count.setVisibility(0);
            this.tv_count.setText((CharSequence)String.valueOf(this.likesCount));
            this.mSubCommentsWidget.tv_widget_count.setVisibility(0);
            this.mSubCommentsWidget.tv_widget_count.setText((CharSequence)String.valueOf(this.likesCount));
        } else {
            this.tv_count.setVisibility(8);
            this.mSubCommentsWidget.tv_widget_count.setVisibility(8);
        }
    }

    private String getContentUrlByIid(String iid) {
        String contentUrl = RestApiImpl.API_URL_ARTICLE + TtCloudManager.getAppId() + "/article/" + iid + "?platform=android&apt=" + TtCloudManager.getAppId();
        if (!TextUtils.isEmpty((CharSequence)this.mColumnId)) {
            contentUrl = contentUrl + "&columnid=" + this.mColumnId;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            return this.mUrl;
        }
        return contentUrl;
    }

    private final class LikeObserver
    extends StringCallback {
        private LikeObserver() {
        }

        public void onSuccess(Response<String> response) {
            String s = (String)response.body();
            try {
                UpCountEntity countEntity = GsonUtil.GsonToBean(s, UpCountEntity.class);
                TsdH5ReaderActivity.this.likesCount = Integer.valueOf(countEntity.data);
                TsdH5ReaderActivity.this.setTv_count();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final class CommentListObserver
    extends StringCallback {
        private CommentListObserver() {
        }

        public void onError(Response<String> response) {
            super.onError(response);
            TsdH5ReaderActivity.this.mRefreshLayout.endLoadingMore();
            TsdH5ReaderActivity.this.isShowLoadMoreView();
        }

        public void onSuccess(Response<String> response) {
            String s = (String)response.body();
            TsdH5ReaderActivity.this.mRefreshLayout.endLoadingMore();
            TsdH5ReaderActivity.this.renderCommentList(s);
            TsdH5ReaderActivity.this.isShowLoadMoreView();
        }
    }
}

