/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.api;

import ai.botbrain.ttcloud.api.TtCloudListener;
import ai.botbrain.ttcloud.api.TtcClient;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.activity.TsdSearchActivity;
import ai.botbrain.ttcloud.sdk.fragment.IndexFragment;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.Ad360Mamager;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.OkHttpManager;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;

public class TtCloudManager {
    public static boolean DEBUG = false;
    private static boolean mShowResponse = false;
    public static boolean LOG = true;
    private static String appId;
    private static String appKey;
    private static String sid;

    public static void init(Application application, TtcClient client) {
        try {
            ApplicationInfo appInfo = application.getPackageManager().getApplicationInfo(application.getPackageName(), 128);
            appId = appInfo.metaData.getString("TTC_APPID");
            appKey = appInfo.metaData.getString("TTC_APPKEY");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (null != client) {
            LOG = client.isShowLog();
            mShowResponse = client.isShowResponse();
            DEBUG = client.isDebug();
        }
        TtCloudManager.hideComment(client);
        ContextHolder.initialContext((Context)application);
        OkHttpManager.initOkHttp3(mShowResponse);
        Ad360Mamager.initSdk(false);
        sid = TimeUtil.getTimestamp();
        new RestApiImpl().getYouKuConfig();
        FireDataManager.init(application, appId, appKey);
    }

    private static void hideComment(TtcClient client) {
        if (null != client && client.isHideComment()) {
            ContextHolder.setHideComment();
        }
    }

    public static void init(Application application) {
        TtCloudManager.init(application, null);
    }

    public static void hideActionBar(boolean b) {
        ContextHolder.setIsShowActionBar(b);
    }

    public static String getAppId() {
        return appId;
    }

    public static String getSid() {
        return sid;
    }

    public static void setCallBack(TtCloudListener ttCloudListener) {
        ContextHolder.initTtCloudListener(ttCloudListener);
    }

    public static void login(TtCloudListener.User user) {
        ContextHolder.initalUser(user);
    }

    public static void logout() {
        TsdSPUtils.remove(ContextHolder.getContext(), "pre_user_id");
        ContextHolder.clearUser();
    }

    public static boolean isLogin() {
        return ContextHolder.isLogin();
    }

    public static void setNotScroll() {
        ContextHolder.setCanScroll(false);
    }

    public static void setLoadingErrorView(int loadingErrorView) {
        ContextHolder.showLoadErrorView(loadingErrorView);
    }

    protected static void setFontSize(int size) {
        ContextHolder.setFont_size(size);
    }

    public static void openArticleDetailActivity(Context context, String extra_iid) {
        Intent intent = new Intent();
        intent.setClass(context, TsdH5ReaderActivity.class);
        intent.putExtra("extra_iid", extra_iid);
        context.startActivity(intent);
    }

    public static void openSearchActivity(Context context) {
        Intent intent = new Intent();
        intent.setClass(context, TsdSearchActivity.class);
        context.startActivity(intent);
    }

    public static void setAppId(String appId) {
        TtCloudManager.appId = appId;
    }

    public static IndexFragment getVideoFragment() {
        return IndexFragment.newInstance("video");
    }

    public static IndexFragment getNewsFragment() {
        return IndexFragment.newInstance("article");
    }

    public static IndexFragment getDefaultFragment() {
        return IndexFragment.newInstance();
    }

    static {
        sid = "";
    }
}

