/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mma.mobile.tracking.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import cn.com.mma.mobile.tracking.util.CommonUtil;
import cn.com.mma.mobile.tracking.util.LocationUtil;
import cn.com.mma.mobile.tracking.util.Logger;
import cn.com.mma.mobile.tracking.util.Reflection;
import cn.com.mma.mobile.tracking.util.SharedPreferencedUtil;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DeviceInfoUtil {
    private static final String SHA1_ALGORITHM = "SHA-1";
    private static final String CHAR_SET = "iso-8859-1";
    public static Map<String, String> deviceParams;

    public static String getOSVersion() {
        try {
            return Build.VERSION.RELEASE;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getDevice() {
        try {
            return Build.MODEL;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getResolution(Context context) {
        if (DeviceInfoUtil.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
            try {
                WindowManager wm = (WindowManager)context.getSystemService("window");
                DisplayMetrics metrics = new DisplayMetrics();
                wm.getDefaultDisplay().getMetrics(metrics);
                return String.valueOf(metrics.widthPixels) + "x" + metrics.heightPixels;
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static String getCarrier(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return manager.getNetworkOperatorName();
    }

    public static String getImei(Context context) {
        if (DeviceInfoUtil.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
            try {
                TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
                return manager.getDeviceId();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static String getLocale() {
        Locale locale = Locale.getDefault();
        return String.valueOf(locale.getLanguage()) + "_" + locale.getCountry();
    }

    public static String appVersion(Context context) {
        String result = "1.0";
        try {
            result = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static String getIP(Context context) {
        String ip = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            NetworkInterface inf = interfaces.nextElement();
            Enumeration<InetAddress> enumAddress = inf.getInetAddresses();
            while (enumAddress.hasMoreElements()) {
                InetAddress in = enumAddress.nextElement();
                if (in.isLinkLocalAddress()) continue;
                return in.getHostAddress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String getModel() {
        String device = Build.DEVICE;
        String id = Build.ID;
        String display = Build.DISPLAY;
        String product = Build.PRODUCT;
        String board = Build.BOARD;
        String brand = Build.BRAND;
        String model = Build.MODEL;
        return String.valueOf(device) + "," + id + "," + display + "," + product + "," + board + "," + brand + "," + model;
    }

    public static boolean isWifi(Context context) {
        if (DeviceInfoUtil.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            try {
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                return cm.getNetworkInfo(1).getState() == NetworkInfo.State.CONNECTED;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isNetworkAvailable(Context context) {
        if (context != null) {
            ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivity == null) {
                return false;
            }
            NetworkInfo[] info = connectivity.getAllNetworkInfo();
            if (info != null) {
                int i = 0;
                while (i < info.length) {
                    if (info[i].getState() == NetworkInfo.State.CONNECTED) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public static String getAppName(Context context) {
        ApplicationInfo info = null;
        try {
            PackageManager manager = context.getPackageManager();
            info = manager.getApplicationInfo(context.getPackageName(), 128);
            String appName = info.loadLabel(manager).toString();
            return appName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getPackageName(Context context) {
        try {
            return context.getPackageName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getMacAddress(Context context) {
        String result = "";
        if (DeviceInfoUtil.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            try {
                WifiInfo wifiInfo;
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
                    result = wifiInfo.getMacAddress();
                }
            }
            catch (Exception e) {
                result = "";
            }
        }
        return result;
    }

    public static String getODIN1(Context context) {
        String androidId = "";
        try {
            androidId = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            return DeviceInfoUtil.SHA1(androidId);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (halfbyte >= 0 && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
            ++i;
        }
        return buf.toString();
    }

    private static String SHA1(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA1_ALGORITHM);
            md.update(text.getBytes(CHAR_SET), 0, text.length());
            byte[] sha1hash = md.digest();
            return DeviceInfoUtil.convertToHex(sha1hash);
        }
        catch (Exception e) {
            Logger.e("ODIN Error generating generating SHA-1: " + e);
            return null;
        }
    }

    public static Map<String, String> fulfillTrackingInfo(Context context) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("LBS", LocationUtil.getInstance(context).getLocation());
        String mac = DeviceInfoUtil.getMacAddress(context);
        if (mac != null) {
            mac = mac.replaceAll(":", "").toUpperCase();
            params.put("MAC", mac);
        }
        params.put("ANDROIDID", DeviceInfoUtil.getAndroidId(context));
        params.put("OSVS", DeviceInfoUtil.getOSVersion());
        params.put("TERM", DeviceInfoUtil.getDevice());
        params.put("WIFI", DeviceInfoUtil.isWifi(context) ? "1" : "0");
        params.put("ANAME", DeviceInfoUtil.getAppName(context));
        params.put("AKEY", DeviceInfoUtil.getPackageName(context));
        params.put("OS", "0");
        params.put("SCWH", DeviceInfoUtil.getResolution(context));
        params.put("IMEI", DeviceInfoUtil.getImei(context));
        params.put("SDKVS", "1.3.1");
        params.put("AAID", Reflection.getPlayAdId(context));
        deviceParams = params;
        return params;
    }

    private static String generateAndroidId(Context mContext) {
        try {
            String android_id = Settings.Secure.getString((ContentResolver)mContext.getContentResolver(), (String)"android_id");
            if (android_id == null || android_id.equals("9774d56d682e549c") || android_id.length() < 15) {
                SecureRandom random = new SecureRandom();
                android_id = new BigInteger(64, random).toString(16);
            }
            android_id = CommonUtil.md5(android_id);
            SharedPreferencedUtil.putString(mContext, "cn.com.mma.mobile.tracking.other", "android_id", android_id);
            return android_id;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getAndroidId(Context mContext) {
        String android_id = SharedPreferencedUtil.getString(mContext, "cn.com.mma.mobile.tracking.other", "android_id");
        if (android_id == null || android_id.equals("") || android_id.equals("null")) {
            android_id = DeviceInfoUtil.generateAndroidId(mContext);
        }
        return android_id;
    }

    public static boolean isEmulator(Context context) {
        boolean result = false;
        String android_id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (android_id != null && android_id.equals("9774d56d682e549c")) {
            result = true;
        }
        return result;
    }

    public static boolean checkPermission(Context context, String permission) {
        try {
            int result = context.checkCallingOrSelfPermission(permission);
            return result == 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

