package ai.botbrain.ttcloud.sdk.widget;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;

import java.util.ArrayList;
import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.adapter.SubCommentAdapter;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentsEntity;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 2017/8/1.
 */

public class SubCommentsWidget extends RelativeLayout implements BGARefreshLayout.BGARefreshLayoutDelegate {

    private RequestOptions options_avatar = new RequestOptions()
            .centerCrop()
            .placeholder(R.drawable.tsd_def_avatar)
            .error(R.drawable.tsd_def_avatar)
            .diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)
            .skipMemoryCache(false)
            .priority(Priority.HIGH);

    private Context mContext;
    private TsdH5ReaderActivity h5ReaderActivity;

    private Scroller mScroller;

    private int mScreenHeigh = 0;
    private int downY = 0;
    //private int upY = 0;
    private Boolean isMoving = false;
    private int viewHeight = 0;
    public boolean isShow = false;
    public boolean mEnabled = true;
    public boolean mOutsideTouchable = true;
    private int mDuration = 800;

    public SubCommentsWidget(Context context) {
        super(context);
        init(context);
    }

    public SubCommentsWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public SubCommentsWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context);
    }

    private String getIid() {
        TsdH5ReaderActivity h5ReaderActivity = (TsdH5ReaderActivity) mContext;
        return h5ReaderActivity.iid;
    }

    public String id;

    public SubCommentEntity topData;

    public void renderReplyNum() {
        tv_reply_count.setText(mDatas.size() + "条回复");
    }

    public void renderTop(SubCommentEntity data) {
        topData = data;
        String commentContent = null == data.commentContent ? "" : data.commentContent;
        String userNick = null == data.userNickName ? "" : data.userNickName;
        String userIcon = null == data.userAvatar ? "" : data.userAvatar;
        id = null == data.id ? "" : data.id;
        String subCommentNum = null == data.subCommentNum ? "" : data.subCommentNum;
        String commentTime = null == data.commentTime ? "" : data.commentTime;
        commentTime = TimeUtil.getStrTime(commentTime);
        commentTime = TimeUtil.getNiceDate(commentTime);
        tv_widget_time.setText(commentTime);

        current = 0;
        mDatas.clear();

        tv_user_nick.setText(userNick);
        tv_content.setText(commentContent);
        renderReplyNum();

        Glide.with(ai.botbrain.ttcloud.sdk.util.ContextHolder.getContext()).setDefaultRequestOptions(options_avatar).load(userIcon).transition(
                new DrawableTransitionOptions().crossFade(500)).into(mCircleImageView);

    }

    public void subComments(String iid, String parentCommentId, int st) {
        String superiorCommentId = h5ReaderActivity.mSubCommentsWidget.id;
        new RestApiImpl().subCommentList(iid, parentCommentId, superiorCommentId, st, new StringCallback() {
            @Override
            public void onSuccess(Response<String> response) {
                String json = response.body();
                renderList(json);
            }
        });
    }

    public List<SubCommentEntity> mDatas;
    public SubCommentAdapter mSubCommentAdapter;

    private void renderList(String json) {
        try {
            SubCommentsEntity entity = GsonUtil.GsonToBean(json, SubCommentsEntity.class);
            mDatas.addAll(entity.data);
            mSubCommentAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            mSubCommentAdapter.notifyDataSetChanged();
            e.printStackTrace();
        }
        renderReplyNum();
    }

    private TsdCircleImageView mCircleImageView;
    private TextView tv_user_nick;
    private TextView tv_content;
    private TextView tv_reply_count;
    public ListView mListView;
    private TextView tv_close;
    public TextView tv_widget_count;
    public ImageButton ib_widget_like;
    public TextView tv_widget_time;

    private void initView(View view) {
        BGARefreshLayout mRefreshLayout2 = (BGARefreshLayout) view.findViewById(R.id.rl_modulename_refresh2);
        mRefreshLayout2.setDelegate(this);
        mRefreshLayout2.setPullDownRefreshEnable(false);
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(mContext, true);
        refreshViewHolder.setLoadMoreBackgroundColorRes(R.color.tpp_color_white);
        mRefreshLayout2.setRefreshViewHolder(refreshViewHolder);

        mCircleImageView = (TsdCircleImageView) view.findViewById(R.id.iv_avatar);
        tv_close = (TextView) view.findViewById(R.id.tv_close);
        tv_widget_time = (TextView) view.findViewById(R.id.tv_widget_time);

        tv_user_nick = (TextView) view.findViewById(R.id.tv_user_nick);
        tv_content = (TextView) view.findViewById(R.id.tv_content);
        tv_reply_count = (TextView) view.findViewById(R.id.tv_reply_count);
        mListView = (ListView) view.findViewById(R.id.listview);
        ib_widget_like = (ImageButton) view.findViewById(R.id.ib_widget_like);
        tv_widget_count = (TextView) view.findViewById(R.id.tv_widget_count);
    }

    private void init(Context context) {
        this.mContext = context;
        h5ReaderActivity = (TsdH5ReaderActivity) mContext;
        mDatas = new ArrayList<>();
        mSubCommentAdapter = new SubCommentAdapter(context, mDatas);
        setDescendantFocusability(FOCUS_AFTER_DESCENDANTS);
        setFocusable(true);
        mScroller = new Scroller(context);
        mScreenHeigh = getWindowHeigh(context);
        final View view = LayoutInflater.from(context).inflate(R.layout.tsd_widget_comments, null);
        initView(view);

        LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);// 如果不给他设这个，它的布局的MATCH_PARENT就不知道该是多少
        addView(view, params);// ViewGroup的大小，
        view.post(new Runnable() {

            @Override
            public void run() {
                viewHeight = view.getHeight();
            }
        });
        SubCommentsWidget.this.scrollTo(0, mScreenHeigh);
        tv_close.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

        mListView.setAdapter(mSubCommentAdapter);

    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!mEnabled) {
            return false;
        }
        return super.onInterceptTouchEvent(ev);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:
                downY = (int) event.getY();
                //如果完全显示的时候，让布局得到触摸监听，如果不显示，触摸事件不拦截，向下传递
                if (isShow) {
                    return true;
                }
                break;
            case MotionEvent.ACTION_MOVE:
                // 拖动时候Y坐标
                int moveY = (int) event.getY();
                /**
                 * 拖动时候Y的方向距离
                 */
                int scrollY = moveY - downY;
                //向下滑动
                if (scrollY > 0 && isShow) {
                    scrollTo(0, -Math.abs(scrollY));
                } else {
                    if (mScreenHeigh - this.getTop() <= viewHeight && !isShow) {
                        scrollTo(0, Math.abs(viewHeight - scrollY));
                    }
                }
                break;
            case MotionEvent.ACTION_UP:
                //upY = (int) event.getY();
                if (isShow) {
                    if (this.getScrollY() <= -(viewHeight / 2)) {
                        startMoveAnim(this.getScrollY(), -(viewHeight - this.getScrollY()), mDuration);
                        isShow = false;
                    } else {
                        startMoveAnim(this.getScrollY(), -this.getScrollY(), mDuration);
                        isShow = true;
                    }
                }
                changed();
                break;
            case MotionEvent.ACTION_OUTSIDE:
                break;
            default:
                break;
        }
        return super.onTouchEvent(event);
    }

    /**
     * 拖动动画
     *
     * @param startY
     * @param dy       移动到某点的Y坐标距离
     * @param duration 时间
     */
    public void startMoveAnim(int startY, int dy, int duration) {
        isMoving = true;
        mScroller.startScroll(0, startY, 0, dy, duration);
        invalidate();//通知UI线程的更新
    }

    @Override
    public void computeScroll() {
        if (mScroller.computeScrollOffset()) {
            scrollTo(mScroller.getCurrX(), mScroller.getCurrY());
            // 更新界面
            postInvalidate();
            isMoving = true;
        } else {
            isMoving = false;
        }
        super.computeScroll();
    }

    /**
     * 开打界面
     */
    public void show() {
        if (mDatas != null && mDatas.size() > 0) {
            mDatas.clear();
            mSubCommentAdapter.notifyDataSetChanged();
        }
        if (!isShow) {
            SubCommentsWidget.this.startMoveAnim(-viewHeight, viewHeight, mDuration);
            isShow = true;
            changed();
        }
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                subComments(getIid(), id, current);
            }
        }, 800);
    }

    /**
     * 关闭界面
     */
    public void dismiss() {
        if (isShow && !isMoving) {
            SubCommentsWidget.this.startMoveAnim(0, -viewHeight, mDuration);
            isShow = false;
            changed();
        }
    }

    /**
     * 是否打开
     */
    public boolean isShow() {
        return isShow;
    }

    /**
     * 获取是否可以拖动
     */
    public boolean isSlidingEnabled() {
        return mEnabled;
    }

    /**
     * 设置是否可以拖动
     */
    public void setSlidingEnabled(boolean enabled) {
        mEnabled = enabled;
    }

    /**
     * 设置监听接口，实现遮罩层效果
     */
    public void setOnStatusListener(onStatusListener listener) {
        this.statusListener = listener;
    }

    public void setOutsideTouchable(boolean touchable) {
        mOutsideTouchable = touchable;
    }

    /**
     * 显示状态发生改变时候执行回调借口
     */
    public void changed() {
        if (statusListener != null) {
            if (isShow) {
                statusListener.onShow();
            } else {
                statusListener.onDismiss();
            }
        }
    }

    public onStatusListener statusListener;
    // 当前页
    private int current = 0;

    @Override
    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {

    }

    @Override
    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        subComments(getIid(), id, ++current);
        return false;
    }

    interface onStatusListener {
        void onShow();

        void onDismiss();
    }

    public static int getWindowHeigh(Context context) {
        WindowManager wm = (WindowManager) (context.getSystemService(Context.WINDOW_SERVICE));
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        int mScreenHeigh = dm.heightPixels;
        return mScreenHeigh;
    }

}
