package ai.botbrain.ttcloud.sdk.util;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;

/**
 * 像素和dp之间的转�?
 * @author Administrator
 *
 */
public class DensityUtil {
	 /** 
     * 根据手机的分辨率�? dp 的单�? 转成�? px(像素) 
     */  
    public static int dip2px(Context context, float dpValue) {  
        final float scale = context.getResources().getDisplayMetrics().density;  
        return (int) (dpValue * scale + 0.5f);  
    }  
  
    /** 
     * 根据手机的分辨率�? px(像素) 的单�? 转成�? dp 
     */  
    public static int px2dip(Context context, float pxValue) {  
        final float scale = context.getResources().getDisplayMetrics().density;  
        return (int) (pxValue / scale + 0.5f);  
    }  
    
    /**
     * 将px值转换为sp值，保证文字大小不变
     * 
     * @param pxValue
     *            （DisplayMetrics类中属�?�scaledDensity�?
     * @return
     */ 
    public static int px2sp(Context context, float pxValue) { 
        final float fontScale = context.getResources().getDisplayMetrics().scaledDensity; 
        return (int) (pxValue / fontScale + 0.5f); 
    } 
   
    public static int sp2px(Context context, float spValue) {
    	if(context==null){
    		return 0;
    	}
        final float fontScale = context.getResources().getDisplayMetrics().scaledDensity; 
        return (int) (spValue * fontScale + 0.5f); 
    } 
    
    public static int[] getScreenMetrics(Activity ctx){
    	int[] results = new int[2];
    	DisplayMetrics outMetrics = new DisplayMetrics();
    	ctx.getWindowManager().getDefaultDisplay().getMetrics(outMetrics);
    	results[0] = outMetrics.widthPixels;
    	results[1] = outMetrics.heightPixels;
    	
    	return results;
    }
}
