package ai.botbrain.ttcloud.sdk.util;

import com.ak.android.engine.nav.NativeAdLoaderListener;
import com.ak.android.engine.navbase.NativeAdLoader;
import com.ak.android.shell.AKAD;

import org.greenrobot.eventbus.EventBus;

import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.model.AdEntity;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/4/21.
 */

public class Ad360Mamager {
    private static final String TAG = Ad360Mamager.class.getSimpleName();

    public static void initSdk(boolean isAdTest) {
        AKAD.initSdk(ContextHolder.getContext(), TtCloudManager.DEBUG, isAdTest);
    }

    public static NativeAdLoader initAd(NativeAdLoaderListener nativeAdLoaderListener) {
        String appid = CommonUtil.get360AppId(ContextHolder.getContext());
        LogUtil.i(TAG, "appid:" + appid);
        return AKAD.getNativeAdLoader(ContextHolder.getContext(), appid, nativeAdLoaderListener);
    }

    public static void loadAd(NativeAdLoader mNativeLoader) {
        if (mNativeLoader != null) {
            mNativeLoader.loadAds();
        }
    }

    public static void adError() {
        try {
            String appid = CommonUtil.get360AppId(ContextHolder.getContext());
            AdEntity adEntity = new AdEntity();
            adEntity.src = TsdConstant.TYPE_360;
            adEntity.appid = appid;
            String params = GsonUtil.GsonString(adEntity);
            EventBus.getDefault().post(new BuriedPointEvent(TsdConstant.ACTION_AD_ERROR, null, null, params, null));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
