package ai.botbrain.ttcloud.sdk.presenter;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Environment;
import android.webkit.MimeTypeMap;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import ai.botbrain.ttcloud.sdk.util.LogUtil;

import static android.content.Context.DOWNLOAD_SERVICE;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class DownLoadApkManager {

    private Context mContext;
    private String apkName;

    public DownLoadApkManager(Context context) {
        this.mContext = context;
        mContext.registerReceiver(downloadCompleteReceiver, new IntentFilter(DownloadManager.ACTION_DOWNLOAD_COMPLETE));
    }

    private String savedName;

    public void downloadApk(String apkUrl, String apkName) {
        this.apkName = apkName;
        Uri uri = Uri.parse(apkUrl);
        DownloadManager downloadManager = (DownloadManager) mContext.getSystemService(DOWNLOAD_SERVICE);

        DownloadManager.Request request = new DownloadManager.Request(uri);
        // 设置允许使用的网络类型，这里是移动网络和wifi都可以
        request.setAllowedNetworkTypes(request.NETWORK_MOBILE | request.NETWORK_WIFI);
        //设置是否允许漫游
        request.setAllowedOverRoaming(false);
        //设置文件类型
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String mimeString = mimeTypeMap.getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl(apkUrl));
        request.setMimeType(mimeString);
        //在通知栏中显示
        request.setNotificationVisibility(request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);
        request.setTitle(apkName);
        request.setVisibleInDownloadsUi(true);
        //sdcard目录下的download文件夹
        //request.setDestinationInExternalPublicDir("/download", "downloadtest.apk");
        LogUtil.i("DownLoadApkManager", generateSavedName(apkName));
        request.setDestinationInExternalPublicDir("/download", generateSavedName(apkName));
        // 将下载请求放入队列
        downloadManager.enqueue(request);
    }

    private BroadcastReceiver downloadCompleteReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            /**下载完成后安装APK**/
            File f = new File(sd_path + "/download/" + apkName);
            File f2 = new File(sd_path + "/download/" + apkName + ".apk");
            f.renameTo(f2);
            installApk();
        }
    };

    private void installApk() {
        Intent i = new Intent(Intent.ACTION_VIEW);
        //String filePath = "/sdcard/download/downloadtest.apk";
        String filePath = Environment.getExternalStorageDirectory().getPath() + savedName + ".apk";

        i.setDataAndType(Uri.parse("file://" + filePath), "application/vnd.android.package-archive");
        mContext.startActivity(i);
    }

    private String generateSavedName(String apkName) {
        String savedName;
        try {
            savedName = URLEncoder.encode(apkName, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            savedName = apkName;
        }
        this.savedName = savedName;
        return savedName;
    }

    private String sd_path = Environment.getExternalStorageDirectory().getPath() + "//";

    /**
     * 判断app是否已经下载
     *
     * @param apkName
     * @return
     */
    public boolean isDownload(String apkName) {
        File file = new File(sd_path + "/download/" + apkName);
        return file.exists();
    }

}
