package ai.botbrain.ttcloud.sdk.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.firedata.sdk.Firedata;
import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdChoiceLikeActivity;
import ai.botbrain.ttcloud.sdk.adapter.MyFragmentPagerAdapter;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.ClickCategoryEvent;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.AppsListPresenter;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.LoadingView;
import ai.botbrain.ttcloud.sdk.widget.MyViewPager;
import ai.botbrain.ttcloud.sdk.widget.TabPageIndicator;

import static ai.botbrain.ttcloud.sdk.TsdConstant.PREF_CHANNEL;
import static android.R.attr.versionName;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class IndexFragment extends Fragment implements LoadingView.OnRetryListener {
    private static final String TAG = IndexFragment.class.getSimpleName();

    private TopTitleEntity topTitleEntity;
    private RestApi restApi;

    private int tab_position = 0;
    private String currentSubColumnsId;
    private String last_label_name;
    private String cache_title;
    private ArrayList<String> tabTitleArray;
    private List<String> label_idList;

    private View rootView;
    public LoadingView mLoadingView;
    private MyViewPager mViewPager;
    private TabPageIndicator mPageIndicator;

    private boolean isInitTop;
    private FragmentPagerAdapter adapter;

    private String arg_type;
    public static final String ARG_FEED_TYPE = "arg_type_video";

    public static final String TYPE_ARTICLE = "article";
    public static final String TYPE_VIDEO = "video";

    public static IndexFragment newInstance(final String type) {
        IndexFragment fragment = new IndexFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_FEED_TYPE, type);
        fragment.setArguments(bundle);
        return fragment;
    }

    @SuppressWarnings("unused")
    public static IndexFragment newInstance() {
        return newInstance(null);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (rootView == null) {
            rootView = inflater.inflate(R.layout.tsd_fragment_index, container, false);
            initView(rootView);
        }
        ViewGroup parent = (ViewGroup) rootView.getParent();
        if (parent != null) {
            parent.removeView(rootView);
        }
        return rootView;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        cache_title = (String) TsdSPUtils.get(getActivity(), PREF_CHANNEL + arg_type, "");
        if (!TextUtils.isEmpty(cache_title)) {
            renderConfig(cache_title);
        }
        restApi.getConfig(new ConfigObserver(), arg_type);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            arg_type = getArguments().getString(ARG_FEED_TYPE);
        }
        mLoadingView = new LoadingView(ContextHolder.getContext());
        restApi = new RestApiImpl();
        AppsListPresenter.upload(ContextHolder.getContext());
        initJsHttp();
        initData();
    }

    private void initData() {
        label_idList = new ArrayList<>();
    }

    private void cache(String response) {
        TsdSPUtils.put(getActivity(), PREF_CHANNEL + arg_type, response);
    }

    private ArrayList<String> getTabTitleArray(TopTitleEntity topTitleEntity) {
        label_idList.clear();
        if (null == topTitleEntity || null == topTitleEntity.data) {
            return null;
        }
        tabTitleArray = new ArrayList<>();
        List<TopTitleEntity.Columns> datas = topTitleEntity.data.columns;
        if (null == datas || datas.size() == 0) return null;
        for (TopTitleEntity.Columns data : datas) {
            String label_name = data.name;
            String label_id = data.id;
            tabTitleArray.add(label_name);
            label_idList.add(label_id);
        }

        return tabTitleArray;
    }

    private void renderConfig(String response) {
        if (TextUtils.isEmpty(response)) {
            return;
        }
        cache(response);
        try {
            topTitleEntity = GsonUtil.GsonToBean(response, TopTitleEntity.class);
            coldStart(topTitleEntity);
            String app_name = topTitleEntity.appName;
            if (appNameListener != null)
                appNameListener.appName(app_name);
            initSecondaryDirectoryStatus(topTitleEntity);
            initView(getView());
            tabTitleArray = getTabTitleArray(topTitleEntity);
            initTabLayout();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void coldStart(TopTitleEntity topTitleEntity) {
        TopTitleEntity.Data data = topTitleEntity.data;
        if (null == data.coldStart) return;
        TopTitleEntity.ColdStart coldStart = data.coldStart;
        String appName = null == topTitleEntity.appName ? "" : topTitleEntity.appName;

        String enable = null == coldStart.enable ? "" : coldStart.enable;

        if (enable.equals("on") && isFirstLauncher()) {
            Intent intent = new Intent();
            intent.setClass(getActivity(), TsdChoiceLikeActivity.class);
            intent.putExtra("ACTION_COLDSTART", coldStart);
            intent.putExtra("ACTION_APP_NAME", appName);
            getActivity().startActivity(intent);
        }

    }

    public void setAppNameListener(AppNameListener listener) {
        appNameListener = listener;
    }

    public AppNameListener appNameListener;

    public interface AppNameListener {
        void appName(String appName);
    }

    private synchronized void initTabLayout() {
        if (!isInitTop) {
            adapter = new MyFragmentPagerAdapter(getChildFragmentManager(), topTitleEntity.data);
            mViewPager.setAdapter(adapter);
            isInitTop = true;
        } else {
            adapter.notifyDataSetChanged();
        }

        mPageIndicator.setViewPager(mViewPager, 0);

        mPageIndicator.setOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            @Override
            public void onPageSelected(final int position) {
                try {
                    //TODO 空指针处理
                    tab_position = position;

                    slideEventSend(position);
                    final int count = null == topTitleEntity.data.columns ? 0 : topTitleEntity.data.columns.size();
                    for (int i = 0; i < count; i++) {
                        Fragment fragment = getVisibleFragment(i);
                        if (fragment instanceof RecommendHomeFragment) {
                            ((RecommendHomeFragment) fragment).resetVideo();
                        }
                    }

                    getSubColumnsIdBy(tab_position, 0);
                } catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
    }

    @Override
    public void onRetry() {
        restApi.getConfig(new ConfigObserver(), arg_type);
    }

    private class DemoViewHolder extends TabPageIndicator.ViewHolderBase {

        private TextView mTitleTextView;
        private final int COLOR_TEXT_SELECTED = Color.parseColor("#37baf9");
        private final int COLOR_TEXT_NORMAL = Color.parseColor("#333333");

        @Override
        public View createView(LayoutInflater layoutInflater, int position) {
            final ViewGroup nullParent = null;
            View view = layoutInflater.inflate(R.layout.tsd_ht_views_bimai_cat_item, nullParent);
            mTitleTextView = (TextView) view.findViewById(R.id.tv_ht_bimai_cat_item_title);
            return view;
        }

        @Override
        public void updateView(int position, boolean isCurrent) {
            if (null != tabTitleArray && tabTitleArray.size() > position)
                mTitleTextView.setText(tabTitleArray.get(position));
            if (isCurrent) {
                mTitleTextView.setTextColor(COLOR_TEXT_SELECTED);
            } else {
                mTitleTextView.setTextColor(COLOR_TEXT_NORMAL);
            }
        }
    }

    private void initView(View view) {
        RelativeLayout rl_title = (RelativeLayout) view.findViewById(R.id.rl_title);
        mLoadingView = (LoadingView) view.findViewById(R.id.loading_view);
        mLoadingView.setOnRetryListener(this);
        mViewPager = (MyViewPager) view.findViewById(R.id.bot_news_pager);
        mPageIndicator = (TabPageIndicator) view.findViewById(R.id.indicator);

        mPageIndicator.setViewHolderCreator(new TabPageIndicator.ViewHolderCreator() {
            @Override
            public TabPageIndicator.ViewHolderBase createViewHolder() {
                return new DemoViewHolder();
            }
        });

        mPageIndicator.setOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            @Override
            public void onPageSelected(int position) {
                slideEventSend(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        if (ContextHolder.isShowActionBar()) {
            rl_title.setVisibility(View.GONE);
        }

        mViewPager.setOffscreenPageLimit(10);
    }

    private void initSecondaryDirectoryStatus(TopTitleEntity topTitleEntity) {
        List<TopTitleEntity.Columns> datas = topTitleEntity.data.columns;
        if (null == datas || datas.size() <= 0) return;
        for (TopTitleEntity.Columns labelData : datas) {
            List<TopTitleEntity.SubColumns> labelDatas = labelData.subColumns;
            if (null != labelDatas && labelDatas.size() > 0) {
                TopTitleEntity.SubColumns data = labelDatas.get(0);
                data.isSelected = true;
            }
        }
    }

    private void initJsHttp() {
        new Thread() {
            @Override
            public void run() {
                super.run();
                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
            }
        }.start();
    }

    private Fragment getVisibleFragment(int position) {
        Fragment someFragment = getChildFragmentManager().findFragmentByTag("android:switcher:" + R.id.bot_news_pager + ":" + position);
        if (someFragment != null) {
            if (someFragment.getView() != null) {
                return someFragment;
            }
        }
        return null;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEvent(String event) {
        try {
            String[] ss = event.split("://");
            String a = ss[1].split("/")[0];
            for (int i = 0; i < label_idList.size(); i++) {
                String label_id = label_idList.get(i);
                if (a.equals(label_id)) {
                    mViewPager.setCurrentItem(i);
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getSubColumnsIdBy(int tab_position, int subColumns_position) {
        if (null == topTitleEntity || null == topTitleEntity.data) {
            return;
        }
        try {
            TopTitleEntity.Columns columns = topTitleEntity.data.columns.get(tab_position);
            if (null == columns.subColumns || columns.subColumns.size() <= 0)
                return;

            currentSubColumnsId = columns.subColumns.get(subColumns_position).id;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(ClickCategoryEvent event) {
        int position = event.position;
        RecommendHomeFragment fragment = (RecommendHomeFragment) getVisibleFragment(tab_position);

        getSubColumnsIdBy(tab_position, position);
        if (null != fragment)
            fragment.refresh(position);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(BuriedPointEvent event) {
        if (null == topTitleEntity || null == topTitleEntity.data) {
            return;
        }
        String columns_id = topTitleEntity.data.columns.get(tab_position).id;

        String iid = event.getIid();
        Object alg = event.getAlg();
        String action = event.getAction();
        String num = event.getNum();
        currentSubColumnsId = null == currentSubColumnsId ? "" : currentSubColumnsId;
        restApi.commentToService(iid, alg, action, columns_id + "_" + currentSubColumnsId, num, null);
    }

    private void slideEventSend(int position) {
        tab_position = position;
        if (null == topTitleEntity || null == topTitleEntity.data) {
            return;
        }
        if (null == topTitleEntity.data.columns)
            return;
        if (position >= topTitleEntity.data.columns.size())
            return;
        String label_id = topTitleEntity.data.columns.get(position).id;
        LogUtil.i(TAG, label_id);

        if (!TextUtils.isEmpty(last_label_name)) {
            Firedata.pageViewEnd(last_label_name);
        }
        Firedata.pageViewStart(label_id);
        last_label_name = label_id;
    }

    @Override
    public void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        EventBus.getDefault().unregister(this);
    }

    private final class ConfigObserver extends StringCallback {

        @Override
        public void onError(Response<String> response) {
            super.onError(response);
            if (TextUtils.isEmpty(cache_title)) {
                mLoadingView.notifyDataChanged(LoadingView.State.error);
            }
        }

        @Override
        public void onSuccess(Response<String> response) {
            String s = response.body();
            mLoadingView.notifyDataChanged(LoadingView.State.done);
            renderConfig(s);

        }
    }

    private static final String VERSION_KEY = "version_key";

    private boolean isFirstLauncher() {
        int currentVersion = getAppVersionCode(ContextHolder.getContext());
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ContextHolder.getContext());
        int lastVersion = prefs.getInt(VERSION_KEY, 0);
        if (currentVersion > lastVersion) {
            prefs.edit().putInt(VERSION_KEY, currentVersion).apply();
            return true;
        }
        return false;
    }

    /**
     * 返回当前程序版本名
     */
    public static int getAppVersionCode(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            return pi.versionCode;
        } catch (Exception e) {
            Log.e("VersionInfo", "Exception", e);
        }
        return versionName;
    }

}
