package ai.botbrain.ttcloud.sdk.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;

import com.lzy.okgo.callback.StringCallback;
import com.lzy.okgo.model.Response;
import com.qq.e.ads.nativ.NativeMediaADData;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.adapter.GraphicAdapter;
import ai.botbrain.ttcloud.sdk.banner.Banner;
import ai.botbrain.ttcloud.sdk.banner.BannerConfig;
import ai.botbrain.ttcloud.sdk.banner.listener.OnBannerListener;
import ai.botbrain.ttcloud.sdk.model.AddADEvent;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.DislikeEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.model.TsdFontSizeEvent;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.AdManager;
import ai.botbrain.ttcloud.sdk.util.BannerGlideImageloader;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.LoadingView;
import ai.botbrain.ttcloud.sdk.widget.UpdateStateView;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/22.
 */
public class GraphicFragment extends LazyLoadFragment implements AdapterView.OnItemClickListener,
        LoadingView.OnRetryListener, BGARefreshLayout.BGARefreshLayoutDelegate, OnBannerListener {
    private static final String TAG = GraphicFragment.class.getSimpleName();

    private Context mContext;
    private boolean PULL_TO_REFRESH = true;

    private static final String EXTRA_URL = "extra_url";

    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";
    private static final String ARG_PARAM3 = "param3";

    private int st = 0;
    private int position;

    private String id;
    private String cacheData;

    private ListView mListView;
    private UpdateStateView tsd_usv;
    private LoadingView mLoadingView;
    private GraphicAdapter mAdapter;
    private List<Object> datas;
    private BGARefreshLayout mRefreshLayout;

    private RestApi restApi;
    private FeedDataObserver feedDataObserver;
    private TopTitleEntity.Columns mColumns;

    public GraphicFragment() {
    }

    @SuppressWarnings("uncheck")
    public static GraphicFragment newInstance(int position, TopTitleEntity.Columns columns) {
        String id = null == columns ? "" : columns.id;
        GraphicFragment fragment = new GraphicFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_PARAM1, position);
        args.putString(ARG_PARAM2, id);
        args.putSerializable(ARG_PARAM3, columns);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        restApi = new RestApiImpl();
        datas = new ArrayList<>();
        feedDataObserver = new FeedDataObserver();
        if (getArguments() != null) {
            position = getArguments().getInt(ARG_PARAM1);
            id = getArguments().getString(ARG_PARAM2);
            mColumns = (TopTitleEntity.Columns) getArguments().getSerializable(ARG_PARAM3);
        }
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        initRefreshLayout(view);
        return view;
    }

    @Override
    protected int setContentView() {
        return R.layout.tsd_fragment_graphic;
    }

    private void initRefreshLayout(View view) {
        mRefreshLayout = (BGARefreshLayout) view.findViewById(R.id.rl_modulename_refresh);
        mRefreshLayout.setDelegate(this);
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(mContext, true);
        refreshViewHolder.setPullDownRefreshText("下拉推荐");
        refreshViewHolder.setRefreshingText("努力推荐中");
        refreshViewHolder.setReleaseRefreshText("释放推荐");
        refreshViewHolder.setLoadingMoreText("努力推荐中");
        mRefreshLayout.setRefreshViewHolder(refreshViewHolder);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mLoadingView = findViewById(R.id.loading_view);
        tsd_usv = findViewById(R.id.tsd_usv);
        mLoadingView.setOnRetryListener(this);
        mListView = findViewById(R.id.listview);
        mListView.setOnItemClickListener(this);

        mAdapter = new GraphicAdapter(mContext, mColumns, datas);
        mListView.setAdapter(mAdapter);

        lazyLoadCache();
        isCanLoadData();
    }

    private void lazyLoadCache() {
        cacheData = (String) TsdSPUtils.get(ContextHolder.getContext(), TsdConstant.PREF_GRAPHIC + position, "");
        renderFeedList(cacheData, true);
    }

    @Override
    protected void lazyLoad() {
        mRefreshLayout.beginRefreshing();
    }

    private void showtsd_usv(final int count) {
        tsd_usv.postDelayed(new Runnable() {
            @Override
            public void run() {
                tsd_usv.show(count);
            }
        }, 1000);
    }

    private void refresh(RecommendEntity entity) {
        mRefreshLayout.endRefreshing();
        if (!entity.data.isEmpty())
            showtsd_usv(entity.data.size());
        else
            showtsd_usv(0);
        removeTop(datas);
        removeSeeHere(datas);
        injectSeeHere(entity.data);
        datas.addAll(0, entity.data);
    }

    private void loadMore(RecommendEntity entity) {
        mRefreshLayout.endLoadingMore();
        datas.addAll(entity.data);
    }

    public synchronized void renderFeedList(String json, boolean PULL_TO_REFRESH) {
        try {
            RecommendEntity entity = GsonUtil.GsonToBean(json, RecommendEntity.class);
            renderBanner(entity);
            TsdSPUtils.put(ContextHolder.getContext(), TsdConstant.PREF_GRAPHIC + position, json);
            cacheData = json;
            if (PULL_TO_REFRESH) {
                refresh(entity);
            } else {
                loadMore(entity);
            }
            AdManager.init(datas);
            mAdapter.loadAD();
            mAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<RecommendEntity.Banner> mBanners;

    private void renderBanner(RecommendEntity entity) {
        List<String> images = new ArrayList<>();
        List<String> titles = new ArrayList<>();
        if (mBanners != null) mBanners.clear();
        mBanners = entity.banner;
        if (null == mBanners || mBanners.size() == 0) return;
        for (RecommendEntity.Banner banner : mBanners) {
            String url = banner.url;
            String title = banner.title;
            images.add(url);
            titles.add(title);
        }

        View headerView = View.inflate(mContext, R.layout.tsd_custom_header, null);
        final Banner banner = (Banner) headerView.findViewById(R.id.banner);
        banner.setImages(images);
        banner.setImageLoader(new BannerGlideImageloader());
        banner.setBannerStyle(BannerConfig.CIRCLE_INDICATOR_TITLE_INSIDE);
        banner.setBannerTitles(titles);
        banner.start();
        banner.setOnBannerListener(this);
        mRefreshLayout.setCustomHeaderView(headerView, true);
    }

    private String getPubTime2() {
        String pub_time;
        try {
            RecommendEntity.Data data = (RecommendEntity.Data) datas.get(0);
            RecommendEntity.Data2 data2 = data.data;
            pub_time = data2.pub_time;
        } catch (Exception e) {
            pub_time = "0";
        }
        return pub_time;
    }

    private void removeTop(List datas) {
        if (null == datas || datas.size() == 0)
            return;
        Object o = datas.get(0);
        if (o instanceof RecommendEntity.Data) {
            RecommendEntity.Data data = (RecommendEntity.Data) o;
            String flag = null == data.flag ? "" : data.flag;
            if (flag.equals("top")) datas.remove(0);
        }
    }

    private void removeSeeHere(List datas) {
        Iterator iterator = datas.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof RecommendEntity.Data) {
                RecommendEntity.Data i = (RecommendEntity.Data) o;
                if (i.type.equals("seeHere")) iterator.remove();
            }
        }
    }

    private void injectSeeHere(List<RecommendEntity.Data> datas) {
        if (this.datas.size() <= 0 || datas.size() <= 0)
            return;
        RecommendEntity.Data data = new RecommendEntity.Data();
        data.type = "seeHere";
        datas.add(data);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        //super.onSaveInstanceState(outState);
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        RecommendEntity.Data data = (RecommendEntity.Data) datas.get(position);
        mAdapter.notifyDataSetChanged();
        if (data.type.equals("seeHere")) {
            datas.remove(position);
            mListView.smoothScrollToPosition(0);
            mRefreshLayout.beginRefreshing();
        } else {
            goToReaderActivity(data);
        }
    }

    private void goToReaderActivity(RecommendEntity.Data data) {
        data.data.has_read = true;
        RecommendEntity.Data2 data2 = data.data;
        String iid = null == data2.iid ? "" : data2.iid;
        Object alg = null == data2.alg ? "" : data2.alg;
        Intent intent = new Intent();
        intent.setClass(mContext, TsdH5ReaderActivity.class);
        intent.putExtra(TsdConstant.EXTRA_IID, iid);
        intent.putExtra(TsdConstant.EXTRA_COLUMN_ID, id);
        EventBus.getDefault().post(new BuriedPointEvent(TsdConstant.ACTION_CLICK, iid, alg, null, null));
        startActivity(intent);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        mContext = activity;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mContext = null;
    }

    @Override
    public void onRetry() {
        mLoadingView.notifyDataChanged(LoadingView.State.ing);
        PULL_TO_REFRESH = true;
        restApi.feedList(feedDataObserver, id, 0, TimeUtil.getTime());
    }

    @Override
    public void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(DislikeEvent event) {
        BaseAdapter adapter = event.adapter;
        if (mAdapter != adapter) {
            return;
        }
        int position = event.position;
        LogUtil.i(TAG, "要删除的位置：" + position);
        try {
            if (datas.get(position) instanceof RecommendEntity.Data) {
                List<Object> das = datas;
                RecommendEntity.Data data = (RecommendEntity.Data) das.get(position);
                String title = data.data.title;
                LogUtil.i(TAG, title);
                datas.remove(position);
                mAdapter.notifyDataSetChanged();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(TsdFontSizeEvent event) {
        int font_size = event.font_size;
        ContextHolder.setFont_size(font_size);
        mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {
        PULL_TO_REFRESH = true;
        String time = getPubTime2();
        restApi.feedList(feedDataObserver, id, 0, time);
    }

    @Override
    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        PULL_TO_REFRESH = false;
        st = st + 1;
        restApi.feedList(feedDataObserver, id, st, null);
        return true;
    }

    @Override
    public void OnBannerClick(int position) {
        String iid = mBanners.get(position).linkUrl;
        String linkType = mBanners.get(position).linkType;
        String title = mBanners.get(position).title;
        if (linkType.equals("1"))
            return;
        if (linkType.equals("3") || linkType.equals("2")) {
            Intent intent = new Intent();
            intent.setClass(mContext, TsdH5ReaderActivity.class);
            intent.putExtra(TsdConstant.EXTRA_IID, iid);
            intent.putExtra(TsdConstant.EXTRA_COLUMN_ID, id);
            intent.putExtra(EXTRA_URL, iid);
            startActivity(intent);
            return;
        }
        /*
        if (linkType.equals("2")) {
            Intent intent = new Intent();
            intent.putExtra("webAddress", iid);
            intent.putExtra("title", title);
            intent.setClass(mContext, TsdH5Activity.class);
            mContext.startActivity(intent);
        }
        */
    }

    private final class FeedDataObserver extends StringCallback {

        @Override
        public void onError(Response<String> response) {
            super.onError(response);
            if (TextUtils.isEmpty(cacheData)) {
                mLoadingView.notifyDataChanged(LoadingView.State.error);
            }
            if (response.getException() instanceof UnknownHostException) {
                tsd_usv.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        tsd_usv.showUnknownHostException();
                    }
                }, 2000);
            }
            mRefreshLayout.endRefreshing();
            mRefreshLayout.endLoadingMore();
        }

        @Override
        public void onSuccess(Response<String> response) {
            final String json = response.body();
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    mLoadingView.notifyDataChanged(LoadingView.State.done);
                    renderFeedList(json, PULL_TO_REFRESH);
                }
            }, 1000);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(AddADEvent event) {
        if (mAdapter != event.adapter) {
            return;
        }
        String type = event.type;
        int position = event.position;
        if (position >= 0 && position <= datas.size()) {
            if (type.equals(TsdConstant.TYPE_QQ)) {
                NativeMediaADData mediaADData = event.mediaADData;
                datas.add(position, mediaADData);
            }
            mAdapter.notifyDataSetChanged();
        }
    }
}
