package ai.botbrain.ttcloud.sdk.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ak.android.engine.nav.NativeAd;
import com.ak.android.engine.nav.NativeAdLoaderListener;
import com.ak.android.engine.navbase.NativeAdLoader;
import com.ak.android.shell.AKAD;
import com.baidu.mobad.feeds.BaiduNative;
import com.baidu.mobad.feeds.NativeErrorCode;
import com.baidu.mobad.feeds.NativeResponse;
import com.baidu.mobad.feeds.RequestParameters;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.firedata.sdk.Firedata;
import com.firedata.sdk.Props;
import com.qq.e.ads.nativ.NativeMediaAD;
import com.qq.e.ads.nativ.NativeMediaADData;
import com.youku.cloud.module.PlayerErrorInfo;
import com.youku.cloud.player.PlayerListener;
import com.youku.cloud.player.VideoDefinition;
import com.youku.cloud.player.YoukuPlayerView;
import com.youku.cloud.player.YoukuUIListener;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;
import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.activity.TsdH5Activity;
import ai.botbrain.ttcloud.sdk.activity.TsdVideoFullscreenActivity;
import ai.botbrain.ttcloud.sdk.disLike.FitPopupUtil;
import ai.botbrain.ttcloud.sdk.model.Ad360Entity;
import ai.botbrain.ttcloud.sdk.model.AdEntity;
import ai.botbrain.ttcloud.sdk.model.BuriedPointEvent;
import ai.botbrain.ttcloud.sdk.model.DislikeEvent;
import ai.botbrain.ttcloud.sdk.model.RecommendEntity;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.presenter.DownLoadApkManager;
import ai.botbrain.ttcloud.sdk.presenter.GetInjectJsNet;
import ai.botbrain.ttcloud.sdk.presenter.JsPresenter;
import ai.botbrain.ttcloud.sdk.util.AdQqManager;
import ai.botbrain.ttcloud.sdk.util.CommonUtil;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.NetworkUtil;
import ai.botbrain.ttcloud.sdk.widget.AnthologyDialog;
import ai.botbrain.ttcloud.sdk.widget.CommonDialog;
import ai.botbrain.ttcloud.sdk.widget.NetDialog;
import ai.botbrain.ttcloud.sdk.widget.NoScrollGridView;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class RecommendHomeAdapter extends BaseAdapter {
    private static final String TAG = RecommendHomeAdapter.class.getSimpleName();

    private final Context mContext;
    private RestApi restApi;
    //private NativeMediaAD mADManager;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    private static final int TYPE_CARD_STYLE1 = 0;
    private static final int TYPE_CARD_STYLE2 = 1;
    private static final int TYPE_VIDEO_STYLE_DEFAULT = 2;

    private static final int TYPE_QQ_AD = 3;
    private static final int TYPE_360_AD = 4;
    private static final int TYPE_BAIDU_AD = 5;

    private static final int TYPE_BOTBRAIN_AD = 6;
    private static final int TYPE_FILM = 7;
    private static final int TYPE_SUBCOLUMNS = 8;

    private static final int TYPE_NO_PIC = 9;
    private static final int TYPE_ONE_SMALL = 10;
    private static final int TYPE_ONE_BIG = 11;
    private static final int TYPE_THREE_PIC = 12;
    private static final int TYPE_SEE_HERE = 13;

    private static final int TYPE_COUNT = 14;

    private static final String CARD_STYLE1 = "1";
    private static final String CARD_STYLE2 = "2";
    private static final String TYPE_CARD = "card";

    private List<RecommendEntity.Data> mData;
    private String iid;
    private String extraVid;

    private List<TopTitleEntity.SubColumns> mSubColumnses;
    private NetDialog mNetDialog;
    public YoukuPlayerView youkuPlayerView;
    public int currentPlayingPosition = 0;

    private RequestOptions options_common = new RequestOptions()
            .centerCrop()
            .placeholder(R.drawable.tsd_bg_place)
            .error(R.drawable.tsd_bg_place)
            .diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)
            .skipMemoryCache(false)
            .priority(Priority.HIGH);

    public RecommendHomeAdapter(Context context, List<RecommendEntity.Data> data, List<TopTitleEntity.SubColumns> columns) {
        this.mContext = context;
        restApi = new RestApiImpl();
        this.mData = data;
        this.mSubColumnses = columns;
        this.mNetDialog = new NetDialog(mContext);
        //init360Ad();
    }

    private YoukuPlayerView getYoukuPlayerView() {
        synchronized (this) {
            if (youkuPlayerView == null) {
                View youku_player = View.inflate(mContext, R.layout.tsd_view_youku, null);
                youkuPlayerView = (YoukuPlayerView) youku_player.findViewById(R.id.baseview);
                ViewGroup group = (ViewGroup) youkuPlayerView.getParent();
                group.removeAllViewsInLayout();
            } else {
                ViewGroup group = (ViewGroup) youkuPlayerView.getParent();
                if (group != null) {
                    int childCount = group.getChildCount();
                    if (childCount > 1) {
                        group.removeViewAt(1);
                    }
                }
            }
        }
        return youkuPlayerView;
    }

    @Override
    public int getCount() {
        int i = 0;
        if (mSubColumnses != null && mSubColumnses.size() > 0) {
            i = 1;
        }
        return null == mData ? i : mData.size();
    }

    @Override
    public Object getItem(int i) {
        return mData.get(i);
    }

    @Override
    public long getItemId(int i) {
        return i;
    }

    @Override
    public int getViewTypeCount() {
        return TYPE_COUNT;
    }

    @Override
    public int getItemViewType(int position) {
        if (position == 0 && mSubColumnses != null && mSubColumnses.size() > 0) {
            return TYPE_SUBCOLUMNS;
        }

        RecommendEntity.Data data = mData.get(position);
        String type = data.type;
        String style = data.style == null ? "" : data.style;

        if (type.equals("film")) {
            return TYPE_FILM;
        } else if (type.equals(TYPE_CARD) && style.equals(CARD_STYLE1)) {
            return TYPE_CARD_STYLE1;
        } else if (type.equals(TYPE_CARD) && style.equals(CARD_STYLE2)) {
            return TYPE_CARD_STYLE2;
        } else if (type.equals("ad") && data.data.src.equals("botbrain")) {
            return TYPE_BOTBRAIN_AD;
        } else if (type.equals("ad") && data.data.src.equals("qq.e")) {
            return TYPE_QQ_AD;
        } else if (type.equals("ad") && data.data.src.equals("baidu")) {
            return TYPE_BAIDU_AD;
        } else if (type.equals("ad") && data.data.src.equals("360")) {
            return TYPE_360_AD;
        } else if (type.equals("feed")) {
            RecommendEntity.Data2 data2 = data.data;
            String[] imgs = data2.images;
            String coverUrl = data2.cover_url;
            if (!TextUtils.isEmpty(coverUrl)) {
                return TYPE_ONE_BIG;
            } else if (TextUtils.isEmpty(coverUrl) && null != imgs && imgs.length == 0) {
                return TYPE_NO_PIC;
            } else if (TextUtils.isEmpty(coverUrl) && null != imgs && imgs.length == 1) {
                return TYPE_ONE_SMALL;
            } else if (TextUtils.isEmpty(coverUrl) && null != imgs && imgs.length >= 3) {
                return TYPE_THREE_PIC;
            } else {
                return TYPE_NO_PIC;
            }
        } else {
            return TYPE_VIDEO_STYLE_DEFAULT;
        }

    }

    private void initViewDisLike(View convertView, ViewHolder viewHolder) {
        viewHolder.iv_dislike = (ImageView) convertView.findViewById(R.id.iv_dislike);
        viewHolder.iv_dislike.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int position2 = (int) v.getTag();
                initPopup(v, position2);
            }
        });
    }

    private void initViewCommon(View convertView, ViewHolder viewHolder) {
        viewHolder.mTitle = (TextView) convertView.findViewById(R.id.item_title);
        viewHolder.mSource = (TextView) convertView.findViewById(R.id.item_source);
        viewHolder.tsd_tv_stickied = (TextView) convertView.findViewById(R.id.tsd_tv_stickied);
        viewHolder.tsd_article_divider = convertView.findViewById(R.id.tsd_article_divider);
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup viewGroup) {
        final ViewHolder viewHolder;
        int currentType = getItemViewType(position);
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            switch (currentType) {
                case TYPE_CARD_STYLE1:
                    convertView = View.inflate(mContext, R.layout.tsd_item_card_style1_gridview, null);
                    viewHolder.tv_name = (TextView) convertView.findViewById(R.id.tv_name);
                    viewHolder.btn_more = (Button) convertView.findViewById(R.id.btn_more);
                    viewHolder.listview_item_gridview = (NoScrollGridView) convertView.findViewById(R.id.listview_item_gridview);
                    break;
                case TYPE_CARD_STYLE2:
                    convertView = View.inflate(mContext, R.layout.tsd_item_card_style2_gridview, null);
                    viewHolder.tv_name = (TextView) convertView.findViewById(R.id.tv_name);
                    viewHolder.btn_more = (Button) convertView.findViewById(R.id.btn_more);
                    viewHolder.listview_item_gridview = (NoScrollGridView) convertView.findViewById(R.id.listview_item_gridview);
                    break;
                case TYPE_VIDEO_STYLE_DEFAULT:
                    convertView = View.inflate(mContext, R.layout.tsd_item_short_video, null);
                    viewHolder.iv_pic = (ImageView) convertView.findViewById(R.id.iv_pic);
                    viewHolder.container = (FrameLayout) convertView.findViewById(R.id.container);
                    viewHolder.iv_play = (ImageView) convertView.findViewById(R.id.iv_play);
                    viewHolder.tv_left_up = (TextView) convertView.findViewById(R.id.tv_left_up);
                    viewHolder.tv_left_down = (TextView) convertView.findViewById(R.id.tv_left_down);
                    viewHolder.tv_right_down = (TextView) convertView.findViewById(R.id.tv_right_down);
                    viewHolder.rl_bg = (RelativeLayout) convertView.findViewById(R.id.rl_bg);
                    break;
                case TYPE_BOTBRAIN_AD:
                case TYPE_360_AD:
                case TYPE_QQ_AD:
                    convertView = View.inflate(mContext, R.layout.tsd_item_qq_ad2, null);
                    viewHolder.adInfoContainer = (LinearLayout) convertView.findViewById(R.id.ad_info);
                    viewHolder.logo = (ImageView) convertView.findViewById(R.id.img_logo);
                    viewHolder.iv_ad = (ImageView) convertView.findViewById(R.id.iv_ad);
                    viewHolder.poster = (ImageView) convertView.findViewById(R.id.img_poster);
                    viewHolder.name = (TextView) convertView.findViewById(R.id.text_title);
                    viewHolder.desc = (TextView) convertView.findViewById(R.id.text_desc);
                    viewHolder.download = (Button) convertView.findViewById(R.id.btn_download);
                    viewHolder.rl_ad = (RelativeLayout) convertView.findViewById(R.id.rl_ad);
                    break;
                case TYPE_BAIDU_AD:
                    convertView = View.inflate(mContext, R.layout.tsd_item_baidu_ad, null);
                    viewHolder.adInfoContainer = (LinearLayout) convertView.findViewById(R.id.ad_info);
                    viewHolder.logo = (ImageView) convertView.findViewById(R.id.img_logo);
                    viewHolder.iv_ad = (ImageView) convertView.findViewById(R.id.iv_ad);
                    viewHolder.img_baidu_poster = (ImageView) convertView.findViewById(R.id.img_baidu_poster);
                    viewHolder.name = (TextView) convertView.findViewById(R.id.text_title);
                    viewHolder.desc = (TextView) convertView.findViewById(R.id.text_desc);
                    //viewHolder.download = (Button) convertView.findViewById(R.id.btn_download);
                    viewHolder.rl_ad = (RelativeLayout) convertView.findViewById(R.id.rl_ad);
                    break;
                case TYPE_FILM:
                    convertView = View.inflate(mContext, R.layout.tsd_item_movie, null);
                    viewHolder.tvTittle = (TextView) convertView.findViewById(R.id.tv_title);
                    viewHolder.tvNew = (TextView) convertView.findViewById(R.id.tv_gengxin);
                    viewHolder.tvDir = (TextView) convertView.findViewById(R.id.tv_daoyan);
                    viewHolder.tvAct = (TextView) convertView.findViewById(R.id.tv_zhuyan);
                    viewHolder.pic = (ImageView) convertView.findViewById(R.id.pic);
                    viewHolder.lin = (LinearLayout) convertView.findViewById(R.id.lin);
                    viewHolder.tv_line2 = (TextView) convertView.findViewById(R.id.tv_line2);
                    break;
                case TYPE_SUBCOLUMNS:
                    convertView = View.inflate(mContext, R.layout.tsd_item_sec_dire, null);
                    viewHolder.gridView = (NoScrollGridView) convertView.findViewById(R.id.listview_item_gridview);
                    break;
                case TYPE_SEE_HERE:
                    convertView = View.inflate(mContext, R.layout.tsd_item_see_here, null);
                    break;
                case TYPE_NO_PIC:
                    convertView = View.inflate(mContext, R.layout.tsd_item_article_plain, null);
                    initViewDisLike(convertView, viewHolder);
                    initViewCommon(convertView, viewHolder);
                    break;
                case TYPE_ONE_SMALL:
                    convertView = View.inflate(mContext, R.layout.tsd_item_article_small, null);
                    viewHolder.mRightImage = (ImageView) convertView.findViewById(R.id.right_image);
                    initViewDisLike(convertView, viewHolder);
                    initViewCommon(convertView, viewHolder);
                    break;
                case TYPE_THREE_PIC:
                    convertView = View.inflate(mContext, R.layout.tsd_item_article_multi_pics, null);
                    viewHolder.mImageLeft = (ImageView) convertView.findViewById(R.id.left_image);
                    viewHolder.mImageMid = (ImageView) convertView.findViewById(R.id.mid_image);
                    viewHolder.mImageRight = (ImageView) convertView.findViewById(R.id.right_image);
                    initViewDisLike(convertView, viewHolder);
                    initViewCommon(convertView, viewHolder);
                    break;
                case TYPE_ONE_BIG:
                    convertView = View.inflate(mContext, R.layout.tsd_item_article_big_pic, null);
                    viewHolder.mBigImage = (ImageView) convertView.findViewById(R.id.big_image);
                    initViewDisLike(convertView, viewHolder);
                    initViewCommon(convertView, viewHolder);
                    break;
            }
            if (convertView != null)
                convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        if (null != convertView)
            convertView.setId(position);

        if (currentType == TYPE_SUBCOLUMNS) {
            renderSubColumns(viewHolder);
        } else if (currentType == TYPE_CARD_STYLE1) {
            renderCardStyle1(viewHolder, position);
        } else if (currentType == TYPE_CARD_STYLE2) {
            renderCardStyle2(viewHolder, position);
        } else if (currentType == TYPE_VIDEO_STYLE_DEFAULT) {
            renderVideoStyleDefault(viewHolder, position);
        } else if (currentType == TYPE_QQ_AD) {
            renderQQAd(viewHolder, position, convertView);
        } else if (currentType == TYPE_360_AD) {
            render360Ad(viewHolder, position, convertView);
        } else if (currentType == TYPE_BAIDU_AD) {
            renderBaiduAd(viewHolder, position, convertView);
        } else if (currentType == TYPE_BOTBRAIN_AD) {
            renderBotAd(viewHolder, position, convertView);
        } else if (currentType == TYPE_FILM) {
            renderFilm(viewHolder, position, convertView);
        } else if (currentType == TYPE_THREE_PIC || currentType == TYPE_NO_PIC || currentType == TYPE_ONE_SMALL || currentType == TYPE_ONE_BIG) {
            viewHolder.iv_dislike.setTag(position);

            viewHolder.mTitle.setTextSize(ContextHolder.getFont_size());

            RecommendEntity.Data data = mData.get(position);
            RecommendEntity.Data2 data2 = data.data;
            if (data2 == null) {
                return convertView;
            }
            boolean has_read = data2.has_read;
            String channel = data2.channel == null ? "" : data2.channel;
            String coverUrl = data2.cover_url == null ? "" : data2.cover_url;
            String[] images = data2.images;
            String flag = data.flag == null ? "" : data.flag;
            if (flag.equals("top")) {
                viewHolder.tsd_tv_stickied.setVisibility(View.VISIBLE);
            } else {
                viewHolder.tsd_tv_stickied.setVisibility(View.GONE);
            }
            viewHolder.mTitle.setText(data2.title);
            if (has_read) {
                viewHolder.mTitle.setTextColor(mContext.getResources().getColor(R.color.tsd_item_hasread));
            } else {
                viewHolder.mTitle.setTextColor(mContext.getResources().getColor(R.color.tsd_item_title));
            }

            viewHolder.mSource.setText(channel);
            if (currentType == TYPE_ONE_BIG) {
                Glide.with(mContext).load(coverUrl).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mBigImage);
            } else if (currentType == TYPE_ONE_SMALL) {
                Glide.with(mContext).load(images[0]).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mRightImage);
            } else if (currentType == TYPE_THREE_PIC) {
                Glide.with(mContext).setDefaultRequestOptions(options_common).load(images[0]).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mImageLeft);
                Glide.with(mContext).applyDefaultRequestOptions(options_common).load(images[1]).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mImageMid);
                Glide.with(mContext).load(images[2]).transition(new DrawableTransitionOptions().crossFade(TsdConstant.CROSSFADEDURATION)).into(viewHolder.mImageRight);
            }

            if ((position + 1) < mData.size()) {
                RecommendEntity.Data data22 = mData.get(position + 1);
                if (data22.type.equals("seeHere")) {
                    viewHolder.tsd_article_divider.setVisibility(View.GONE);
                } else {
                    viewHolder.tsd_article_divider.setVisibility(View.VISIBLE);
                }
            }
        }

        return convertView;
    }

    private void startDownApk(String apkUrl, String apkName) {
        DownLoadApkManager downLoadApkManager = new DownLoadApkManager(ContextHolder.getContext());
        downLoadApkManager.downloadApk(apkUrl, apkName);
    }

    private void openH5Activity(String webAddress, String title) {
        Intent intent = new Intent();
        intent.putExtra("webAddress", webAddress);
        intent.putExtra("title", title);
        intent.setClass(mContext, TsdH5Activity.class);
        mContext.startActivity(intent);
    }

    private class ViewHolder {
        private TextView tv_name;
        private TextView tv_left_up;
        private TextView tv_left_down;
        private TextView tv_right_down;
        private TextView name, desc;
        private TextView tvTittle;
        private TextView tvNew;
        private TextView tvDir;
        private TextView tvAct;
        private TextView mTitle;
        private TextView mSource;
        private TextView tsd_tv_stickied;

        private Button btn_more;
        private Button download;

        private ImageView pic;
        private ImageView iv_ad;
        private ImageView img_baidu_poster;
        private ImageView iv_pic;
        private ImageView iv_play;
        private ImageView mImageLeft;
        private ImageView iv_dislike;
        private ImageView mImageMid;
        private ImageView mImageRight;
        private ImageView mBigImage;
        private ImageView mRightImage;
        private ImageView logo, poster;

        private LinearLayout adInfoContainer;
        private RelativeLayout rl_bg;
        private RelativeLayout rl_ad;
        private NoScrollGridView listview_item_gridview;
        private FrameLayout container;

        private NoScrollGridView gridView;
        private LinearLayout lin;
        private TextView tv_line2;

        private View tsd_article_divider;
    }

    public synchronized void initPlayer(YoukuPlayerView youkuPlayerView) {
        youkuPlayerView.release();
        youkuPlayerView.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View view, int i, KeyEvent keyEvent) {
                return false;
            }
        });
        youkuPlayerView.attachActivity((Activity) mContext);
        youkuPlayerView.setPreferVideoDefinition(VideoDefinition.VIDEO_HD);
        youkuPlayerView.setPlayerListener(new MyPlayerListener());
        youkuPlayerView.setUseOrientation(false);
        youkuPlayerView.setUIListener(new YoukuUIListener() {
            @Override
            public void onBackBtnClick() {
            }

            @Override
            public void onFullBtnClick() {
                Intent intent = new Intent();
                intent.setClass(mContext, TsdVideoFullscreenActivity.class);
                intent.putExtra("vid", extraVid);
                mContext.startActivity(intent);
            }
        });
    }

    private class MyPlayerListener extends PlayerListener {
        @Override
        public void onSeekComplete() {
            super.onSeekComplete();
        }

        @Override
        public void onComplete() {
            super.onComplete();
        }

        @Override
        public void onError(int code, PlayerErrorInfo info) {
            super.onError(code, info);
            new RestApiImpl().reportVid(code, iid);
        }

        @Override
        public void OnCurrentPositionChanged(int msec) {
            super.OnCurrentPositionChanged(msec);
        }

        @Override
        public void onVideoNeedPassword(int code) {
            super.onVideoNeedPassword(code);
        }
    }

    private void adExposure(NativeMediaADData nativeMediaADData) {
        LogUtil.i(TAG, nativeMediaADData.getTitle() + " onADExposure");
        AdEntity adEntity = new AdEntity();
        adEntity.setDes(nativeMediaADData.getDesc());
        adEntity.setSrc("qq.e");
        adEntity.setTitle(nativeMediaADData.getTitle());
        String params = GsonUtil.GsonString(adEntity);
        EventBus.getDefault().post(new BuriedPointEvent("adshow", null, null, params, null));

        FireDataManager.qqAdShow(nativeMediaADData);
    }

    private void adClick(NativeMediaADData ad) {
        LogUtil.i(TAG, ad.getTitle() + " onADClicked");
        AdEntity adEntity = new AdEntity();
        adEntity.setDes(ad.getDesc());
        adEntity.setSrc("qq.e");
        adEntity.setTitle(ad.getTitle());
        String params = GsonUtil.GsonString(adEntity);
        restApi.adClickHttp(params);

        FireDataManager.qqAdClick(ad);
    }
    /*
    public void loadAD(SparseArray<String> AD_COUNT) {
        boolean b = CommonUtil.getIsLoadAd(mContext.getApplicationContext());
        for (int i = 0; i < AD_COUNT.size(); i++) {
            int key = AD_COUNT.keyAt(i);
            String TYPE = AD_COUNT.get(key);
            if (TYPE.equals("qq.e")) {
                if (mADManager != null && b) {
                    try {
                        mADManager.loadAD(1);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                Ad360Mamager.loadAd(mNativeLoader);
            }
        }

    }
    */

    private void setDatas(List data, int position) {
        try {
            RecommendEntity.Data data1 = (RecommendEntity.Data) data.get(position);
            RecommendEntity.Data2 data2 = data1.data;
            data2.isContainYouKu = true;
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public boolean resetDatas() {
        boolean flag = false;
        try {
            for (Object obj : mData) {
                if (obj instanceof RecommendEntity.Data) {
                    RecommendEntity.Data data = (RecommendEntity.Data) obj;
                    if (null != data.data && data.data.isContainYouKu) {
                        data.data.isContainYouKu = false;
                        flag = true;
                    }
                }
            }
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
        return flag;
    }

    private String getLabel_id(String channel) {
        String label_id = "tv";
        if (TextUtils.isEmpty(channel)) {
            return label_id;
        }
        if (channel.equals(mContext.getResources().getString(R.string.tsd_tv_series))) {
            label_id = "tv";
        } else if (channel.equals(mContext.getResources().getString(R.string.tsd_movie))) {
            label_id = "movie";
        } else if (channel.equals(mContext.getResources().getString(R.string.tsd_variety))) {
            label_id = "zongyi";
        } else if (channel.equals(mContext.getResources().getString(R.string.tsd_anime))) {
            label_id = "cartoon";
        }
        return label_id;
    }

    private StringBuffer getTypes(List<String> types) {
        StringBuffer str1 = new StringBuffer();
        if (types.size() > 8) {
            for (int i = 0; i < 8; i++) {
                str1.append(types.get(i)).append(mContext.getResources().getString(R.string.tsd_str_empty));
            }
        } else {
            for (int i = 0; i < types.size(); i++) {
                str1.append(types.get(i)).append(mContext.getResources().getString(R.string.tsd_str_empty));
            }
        }
        return str1;
    }

    private StringBuffer getActors(List<String> actors) {
        StringBuffer str1 = new StringBuffer();
        if (actors.size() > 6) {
            for (int i = 0; i < 6; i++) {
                str1.append(actors.get(i)).append(mContext.getResources().getString(R.string.tsd_str_empty));
            }
        } else {
            for (int i = 0; i < actors.size(); i++) {
                str1.append(actors.get(i)).append(mContext.getResources().getString(R.string.tsd_str_empty));
            }
        }
        return str1;
    }

    private String getMoveShowTime(String pub_time) {
        if (pub_time != null && pub_time.length() > 4) {
            return pub_time.substring(0, 4);
        } else {
            return pub_time;
        }
    }

    private void renderSubColumns(ViewHolder viewHolder) {
        SecondaryDirectoryAdapter secondaryDirectoryAdapter = new SecondaryDirectoryAdapter(mContext, mSubColumnses);
        viewHolder.gridView.setAdapter(secondaryDirectoryAdapter);
    }

    private void renderFilm(ViewHolder viewHolder, int position, View convertView) {
        final RecommendEntity.Data e = mData.get(position);
        final RecommendEntity.Data2 entity = e.data;

        final List<String> directors = entity.directors;
        final List<String> areas = entity.areas;
        final List<String> types = entity.types;
        final List<String> actors = entity.actors;
        final RecommendEntity.Newest newest = entity.newest;

        final String channel = null == entity.channel ? "" : entity.channel;
        final String pub_time = null == entity.pub_time ? "" : entity.pub_time;
        final String picurl = null == entity.picurl ? "" : entity.picurl;
        final String d_score = null == entity.d_score ? "" : entity.d_score;
        final String area = null == areas || areas.size() == 0 ? "" : areas.get(0);
        final String director = null == directors || directors.size() == 0 ? "" : directors.get(0);
        final Boolean is_all = entity.is_all;
        final StringBuffer str_type = getTypes(types);

        final String episode = null == newest || null == newest.episode ? "" : newest.episode;

        final String title = null == entity.title ? "" : entity.title;
        final String label_id = getLabel_id(channel);
        final String iid = null == entity.iid ? "" : entity.iid;
        final Object alg = null == entity.alg ? "" : entity.alg;

        Glide.with(mContext).load(picurl).transition(new DrawableTransitionOptions().crossFade(500)).into(viewHolder.pic);
        viewHolder.tvTittle.setText(title);

        convertView.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View arg0) {

                Props props = new Props();
                props.event("iid", entity.iid).event("alg", entity.alg.toString());
                Firedata.event(label_id + "_" + label_id, "click", props);
                if (channel.equals(mContext.getResources().getString(R.string.tsd_movie))) {
                    FireDataManager.clickContent(label_id, title, iid);
                    EventBus.getDefault().post(new BuriedPointEvent("click", iid, alg, null, null));
                    if (JsPresenter.getInstance().isEmpty()) {
                        new Thread() {
                            @Override
                            public void run() {
                                super.run();
                                FireDataManager.play(getLabel_id(channel));
                                JsPresenter.getInstance().setData(GetInjectJsNet.getInstance().getJsHttp());
                                mainHandler.post(new Runnable() {
                                    @Override
                                    public void run() {
                                        FireDataManager.play(getLabel_id(channel));
                                        JsPresenter.getInstance().StartPlayback(mContext, entity.url, title, iid);
                                    }
                                });

                            }
                        }.start();
                    } else {
                        FireDataManager.play(getLabel_id(channel));
                        JsPresenter.getInstance().StartPlayback(mContext, entity.url, entity.title, iid);
                    }

                } else {
                    showAnthologyDialog(entity);
                }
            }
        });

        String movie = mContext.getResources().getString(R.string.tsd_movie);
        String variety = mContext.getResources().getString(R.string.tsd_variety);
        String anime = mContext.getResources().getString(R.string.tsd_anime);

        if (!entity.channel.equals(movie)) {
            // 非电影
            viewHolder.tvNew.setVisibility(View.VISIBLE);
            viewHolder.lin.setVisibility(View.GONE);
            if (is_all && episode.length() <= 6) {
                String all_episodes = mContext.getResources().getString(R.string.tsd_all_episodes);
                viewHolder.tvNew.setText(String.format(all_episodes, episode));
            } else {
                String tv_series_update_stat = mContext.getResources().getString(R.string.tv_series_update_stat);
                viewHolder.tvNew.setText(String.format(tv_series_update_stat, episode));
            }
        } else {
            // 电影的设置
            viewHolder.tvNew.setVisibility(View.GONE);
            viewHolder.lin.setVisibility(View.VISIBLE);
            String move_line2 = mContext.getResources().getString(R.string.tsd_move_line2);
            viewHolder.tv_line2.setText(String.format(move_line2, getMoveShowTime(pub_time), d_score));
        }

        if (channel.equals(variety) || channel.equals(anime)) {
            // 综艺或动漫
            String area_status = mContext.getResources().getString(R.string.tsd_area_status);
            viewHolder.tvDir.setText(String.format(area_status, area));

            String type_status = mContext.getResources().getString(R.string.tsd_type_status);
            viewHolder.tvAct.setText(String.format(type_status, str_type));
        } else {
            String director_status = mContext.getResources().getString(R.string.tsd_director_status);
            viewHolder.tvDir.setText(String.format(director_status, director));

            String starring = mContext.getResources().getString(R.string.tsd_starring);
            viewHolder.tvAct.setText(String.format(starring, getActors(actors)));
        }
    }

    private void showAnthologyDialog(RecommendEntity.Data2 entity) {
        AnthologyDialog dialog = new AnthologyDialog(mContext, entity);
        dialog.show();
    }

    private void renderBotAd(ViewHolder viewHolder, int position, View convertView) {
        RecommendEntity.Data data = mData.get(position);
        final RecommendEntity.Data2 data1 = data.data;
        final String title = null == data1.title ? "" : data1.title;
        String desc = null == data1.des ? "" : data1.des;
        String pic_url = null == data1.pic_url ? "" : data1.pic_url;
        final String type = null == data1.type ? "" : data1.type;
        final String url = null == data1.url ? "" : data1.url;

        if (type.equals("apk")) {
            String download = mContext.getResources().getString(R.string.tsd_download);
            viewHolder.download.setText(download);
        } else if (type.equals("h5")) {
            String rs_browse = mContext.getResources().getString(R.string.tsd_browse);
            viewHolder.download.setText(rs_browse);
        }

        convertView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                FireDataManager.botAdClick(data1);
                restApi.adClickHttp(GsonUtil.GsonString(data1));
                if (type.equals("apk")) {
                    startDownApk(url, title);
                } else if (type.equals("h5")) {
                    openH5Activity(url, title);
                }
            }
        });
        viewHolder.name.setText(title);
        viewHolder.desc.setText(desc);
        Glide.with(mContext).load(pic_url).transition(new DrawableTransitionOptions().crossFade(500)).into(viewHolder.poster);
    }

    private void fetBaiduAd(final RecommendEntity.Data2 data2) {
        String AD_PLACE_ID = data2.appid;
        final BaiduNative baidu = new BaiduNative(mContext, AD_PLACE_ID, new BaiduNative.BaiduNativeNetworkListener() {

            @Override
            public void onNativeFail(NativeErrorCode arg0) {
                Log.i(TAG, "" + arg0.name());
            }

            @Override
            public void onNativeLoad(List<NativeResponse> arg0) {
                if (arg0 != null && arg0.size() > 0) {
                    NativeResponse response = arg0.get(0);
                    if (data2.response == null) {
                        data2.response = response;
                        if (null != mNotiListener)
                            mNotiListener.notifyData();
                    }
                }
            }

        });

        RequestParameters requestParameters =
                new RequestParameters.Builder()
                        .downloadAppConfirmPolicy(
                                RequestParameters.DOWNLOAD_APP_CONFIRM_ONLY_MOBILE).build();

        baidu.makeRequest(requestParameters);
    }

    private void renderBaiduAd(final ViewHolder viewHolder, final int position, final View convertView) {
        RecommendEntity.Data data = mData.get(position);
        final RecommendEntity.Data2 data2 = data.data;

        NativeResponse response = data2.response;
        if (null == response)
            fetBaiduAd(data2);
        String desc = null == response ? "" : response.getDesc();
        String imageUrl = null == response ? "" : response.getImageUrl();
        String title = null == response ? "" : response.getTitle();
        viewHolder.desc.setText(desc);
        viewHolder.name.setText(title);
        Glide.with(mContext).setDefaultRequestOptions(options_common).load(imageUrl)
                .transition(new DrawableTransitionOptions().crossFade(500))
                .into(viewHolder.img_baidu_poster);
        if (null != response)
            response.recordImpression(convertView);
        convertView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                NativeResponse response = data2.response;
                response.handleClick(v);
            }
        });

    }

    private void fetch360Ad(final RecommendEntity.Data2 data2) {
        String adPlaceId = data2.appid;
        NativeAdLoader adLoader = AKAD.getNativeAdLoader(ContextHolder.getContext(), adPlaceId, new NativeAdLoaderListener() {
            @Override
            public void onAdLoadSuccess(ArrayList<NativeAd> arrayList) {
                if (null != arrayList && arrayList.size() > 0) {
                    NativeAd ad = arrayList.get(0);
                    data2.nativeAd = ad;
                    if (null != mNotiListener)
                        mNotiListener.notifyData();
                }
            }

            @Override
            public void onAdLoadFailed(int i, String s) {
                LogUtil.i(TAG, "i:" + i + ",s:" + s);
            }
        });

        adLoader.loadAds();
    }

    private void render360Ad(ViewHolder viewHolder, int position, View convertView) {
        viewHolder.rl_ad.setVisibility(View.VISIBLE);
        viewHolder.iv_ad.setVisibility(View.GONE);

        RecommendEntity.Data data = mData.get(position);
        RecommendEntity.Data2 data2 = data.data;
        final NativeAd nativeAd = data2.nativeAd;
        if (null == nativeAd) {
            fetch360Ad(data2);
        }
        try {
            String json = null;
            Ad360Entity ad360Entity = null;
            if (null != nativeAd) {
                json = nativeAd.getContent().toString();
            }
            if (null != json)
                ad360Entity = GsonUtil.GsonToBean(json, Ad360Entity.class);

            String ext_text = null == ad360Entity || null == ad360Entity.ext_text ? "" : ad360Entity.ext_text;
            String title = null == ad360Entity || null == ad360Entity.title ? "" : ad360Entity.title;
            String contentimg = null == ad360Entity || null == ad360Entity.contentimg ? "" : ad360Entity.contentimg;
            String btntext = null == ad360Entity || null == ad360Entity.btntext ? "" : ad360Entity.btntext;

            viewHolder.name.setText(ext_text);
            viewHolder.desc.setText(title);

            viewHolder.iv_ad.setVisibility(View.GONE);
            Glide.with(mContext).load(contentimg).transition(new DrawableTransitionOptions().crossFade(500)).into(viewHolder.poster);
            viewHolder.download.setText(btntext);
            convertView.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (null == nativeAd) return;
                    nativeAd.onAdClick(((Activity) mContext), v);
                }
            });
            if (null != nativeAd)
                nativeAd.onAdShowed(convertView);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchQqAd(final RecommendEntity.Data2 data2) {
        String adPlaceId = data2.appid;
        String nativeVideoPosID = data2.nativevideoposid;
        NativeMediaAD mediaAD = new NativeMediaAD(ContextHolder.getContext(), adPlaceId, nativeVideoPosID, new NativeMediaAD.NativeMediaADListener() {

            @Override
            public void onADLoaded(List<NativeMediaADData> list) {
                if (null != list && list.size() > 0) {
                    NativeMediaADData nativeMediaADData = list.get(0);
                    data2.nativeMediaADData = nativeMediaADData;
                    if (null!=mNotiListener)
                        mNotiListener.notifyData();
                }
            }

            @Override
            public void onNoAD(int errorCode) {
                LogUtil.i(TAG, "加载失败，错误码：" + errorCode);
                CommonUtil.clearAppidQ(mContext.getApplicationContext());
            }

            @Override
            public void onADStatusChanged(NativeMediaADData nativeMediaADData) {

            }

            @Override
            public void onADError(NativeMediaADData nativeMediaADData, int i) {

            }

            @Override
            public void onADVideoLoaded(NativeMediaADData nativeMediaADData) {

            }

            @Override
            public void onADExposure(NativeMediaADData nativeMediaADData) {
                adExposure(nativeMediaADData);
            }

            @Override
            public void onADClicked(NativeMediaADData nativeMediaADData) {
                adClick(nativeMediaADData);
            }
        });
        mediaAD.loadAD(1);

    }

    private void renderQQAd(final ViewHolder viewHolder, final int position, final View convertView) {
        viewHolder.iv_ad.setVisibility(View.VISIBLE);
        viewHolder.rl_ad.setVisibility(View.GONE);
        viewHolder.poster.setVisibility(View.VISIBLE);
        RecommendEntity.Data data = mData.get(position);
        RecommendEntity.Data2 data2 = data.data;
        final NativeMediaADData ad = data2.nativeMediaADData;
        if (null == ad) {
            fetchQqAd(data2);
        }

        String ad_img = null == ad ? "" : ad.getImgUrl();
        String title = null == ad ? "" : ad.getTitle();
        String iconUrl = null == ad ? "" : ad.getIconUrl();
        String desc = null == ad ? "" : ad.getDesc();

        viewHolder.name.setText(title);
        viewHolder.desc.setText(desc);
        Glide.with(mContext).load(ad_img).transition(new DrawableTransitionOptions().crossFade(500)).into(viewHolder.poster);
        Glide.with(mContext).load(TextUtils.isEmpty(iconUrl) ? ad_img : iconUrl).transition(new DrawableTransitionOptions().crossFade(500)).into(viewHolder.logo);

        viewHolder.download.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (null != ad)
                    ad.onClicked(v);
            }
        });
        convertView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                if (null == ad) return;
                FireDataManager.qqAdClick(ad);
                ad.onClicked(view);

                AdEntity adEntity = new AdEntity();
                adEntity.setDes(ad.getDesc());
                adEntity.setSrc("qq.e");
                adEntity.setTitle(ad.getTitle());
                String params = GsonUtil.GsonString(adEntity);
                restApi.adClickHttp(params);
            }
        });
        AdQqManager.renderDownLoadView(viewHolder.download, ad);
        if (null != ad)
            ad.onExposured(viewHolder.adInfoContainer);
    }

    private void renderCardStyle1(ViewHolder viewHolder, int position) {
        final RecommendEntity.Data mData = this.mData.get(position);
        List<RecommendEntity.Datas> dataList = mData.datas;
        RecommendEntity.More more = mData.more;
        String moreName = null == more.name ? "" : more.name;
        final String moreAction = null == more.action ? "" : more.action;
        String name = null == mData.name ? "" : mData.name;

        TsdCardStyle1Adapter cardStyle1Adapter = new TsdCardStyle1Adapter(mContext, dataList);

        viewHolder.tv_name.setText(name);
        viewHolder.btn_more.setText(moreName);
        viewHolder.listview_item_gridview.setAdapter(cardStyle1Adapter);

        viewHolder.btn_more.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                EventBus.getDefault().post(moreAction);
                FireDataManager.clickMore();
            }
        });
    }

    private void renderCardStyle2(ViewHolder viewHolder, int position) {
        final RecommendEntity.Data data = mData.get(position);
        List<RecommendEntity.Datas> datases = data.datas;
        RecommendEntity.More more = data.more;
        String moreName = null == more.name ? "" : more.name;
        final String moreAction = null == more.action ? "" : more.action;
        String name = null == data.name ? "" : data.name;

        viewHolder.btn_more.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                EventBus.getDefault().post(moreAction);
                FireDataManager.clickMore();
            }
        });
        CardStyle2Adapter cardStyle2Adapter = new CardStyle2Adapter(mContext, datases);

        viewHolder.btn_more.setText(moreName);
        viewHolder.tv_name.setText(name);
        viewHolder.listview_item_gridview.setAdapter(cardStyle2Adapter);
    }

    private void renderVideoStyleDefault(final ViewHolder viewHolder, final int position) {
        final RecommendEntity.Data data = mData.get(position);
        final RecommendEntity.Data2 dataEntity = data.data;

        String picUrl = null == dataEntity.pic_url ? "" : dataEntity.pic_url;
        String tv_left_up = null == dataEntity.left_up ? "" : dataEntity.left_up;
        String tv_left_down = null == dataEntity.left_down ? "" : dataEntity.left_down;
        String tv_right_down = null == dataEntity.right_down ? "" : dataEntity.right_down;
        final String vid = null == dataEntity.vid ? "" : dataEntity.vid;
        iid = null == dataEntity.iid ? "" : dataEntity.iid;
        final boolean isContainYouKu = dataEntity.isContainYouKu;

        if (!isContainYouKu) {
            viewHolder.rl_bg.setVisibility(View.VISIBLE);
            int childCount = viewHolder.container.getChildCount();
            if (childCount > 1) {
                viewHolder.container.removeViewAt(1);
            }
        }

        viewHolder.iv_play.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {

                synchronized (this) {
                    if (!NetworkUtil.isWifiConnected(mContext)) {
                        mNetDialog.show();
                        mNetDialog.setYesOnclickListener(null, new CommonDialog.onYesOnclickListener() {
                            @Override
                            public void onYesClick() {
                                youkuPlay();
                            }
                        });
                    } else {
                        youkuPlay();
                    }
                }
            }

            private void youkuPlay() {
                resetDatas();
                setDatas(mData, position);
                notifyDataSetChanged();
                viewHolder.container.addView(getYoukuPlayerView());
                initPlayer(youkuPlayerView);
                youkuPlayerView.setShowBackBtn(false);
                youkuPlayerView.playYoukuVideo(vid);
                currentPlayingPosition = position;
                extraVid = vid;
                FireDataManager.play("recommend");
                viewHolder.rl_bg.setVisibility(View.INVISIBLE);

                EventBus.getDefault().post(new BuriedPointEvent("click", iid, null, null, null));
            }
        });
        viewHolder.tv_left_up.setText(tv_left_up);
        viewHolder.tv_left_down.setText(tv_left_down);
        viewHolder.tv_right_down.setText(tv_right_down);
        Glide.with(mContext).load(picUrl).transition(new DrawableTransitionOptions().crossFade(500)).into(viewHolder.iv_pic);
    }

    private void initPopup(View anchorView, final int position) {
        FitPopupUtil fitPopupUtil = new FitPopupUtil((Activity) mContext);
        fitPopupUtil.setOnClickListener(new FitPopupUtil.OnCommitClickListener() {
            @Override
            public void onClick(String reason) {
                RecommendEntity.Data data = mData.get(position);
                RecommendEntity.Data2 data2 = data.data;
                String iid = null == data2.iid ? "" : data2.iid;
                EventBus.getDefault().post(new BuriedPointEvent(TsdConstant.ACTION_DISLIKE, iid, null, null, null));
                EventBus.getDefault().post(new DislikeEvent(position, RecommendHomeAdapter.this));
            }
        });
        fitPopupUtil.showPopup(anchorView);
    }


    public interface NotiListener {
        void notifyData();
    }

    private NotiListener mNotiListener;

    public void setNotiListener(NotiListener notiListener) {
        mNotiListener = notiListener;
    }
}


