package ai.botbrain.ttcloud.sdk.adapter;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;

import java.util.List;

import ai.botbrain.ttcloud.sdk.fragment.GraphicFragment;
import ai.botbrain.ttcloud.sdk.fragment.RecommendHomeFragment;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class MyFragmentPagerAdapter extends FragmentPagerAdapter {

    private List mDatas;
    private TopTitleEntity.Data mData;

    public MyFragmentPagerAdapter(FragmentManager fm, TopTitleEntity.Data data) {
        super(fm);
        this.mData = data;
        mDatas = data.columns;
    }

    @Override
    public Fragment getItem(int position) {
        TopTitleEntity.Columns mColumns = (TopTitleEntity.Columns) mDatas.get(position);
        String type = mData.type;
        if (type.equals("video")) {
            return RecommendHomeFragment.newInstance(position, mColumns);
        }

        if (type.equals("article")) {
            return GraphicFragment.newInstance(position, mColumns);
        }
        return null;
    }

    @Override
    public int getCount() {

        return null == mDatas ? 0 : mDatas.size();
    }
}
