package ai.botbrain.ttcloud.sdk.adapter;

import android.app.Activity;
import android.content.Context;
import android.text.Html;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;

import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.widget.TsdCircleImageView;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/5/17.
 */
public class ContentAdapter extends TsdBaseAdapter implements View.OnClickListener {

    private Context mContext;
    private List mData;

    private static final int TYPE_NO_COMMENT = 0;
    private static final int TYPE_NOR = 1;
    private static final int TYPE_ALL_COMPLETE = 2;

    private static final int TYPE_COUNT = 3;

    public ContentAdapter(Context context, List data) {
        this.mContext = context;
        this.mData = data;
    }

    @Override
    public int getCount() {
        return (null == mData || mData.size() == 0) ? 1 : mData.size();
    }

    @Override
    public Object getItem(int i) {
        return null;
    }

    @Override
    public long getItemId(int i) {
        return 0;
    }

    @Override
    public int getViewTypeCount() {
        return TYPE_COUNT;
    }

    @Override
    public int getItemViewType(int position) {
        if (position == 0 && mData.size() == 0) {
            return TYPE_NO_COMMENT;
        } else {
            return TYPE_NOR;
        }
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder viewHolder;
        int type = getItemViewType(position);
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();

            switch (type) {
                case TYPE_NO_COMMENT:
                    convertView = View.inflate(mContext, R.layout.tsd_include_no_comment, null);
                    viewHolder.tv_no_comment = (TextView) convertView.findViewById(R.id.tv_no_comment);
                    break;
                case TYPE_NOR:
                    convertView = View.inflate(mContext, R.layout.tsd_adapter_content, null);

                    viewHolder.tv_content = (TextView) convertView.findViewById(R.id.tv_content);
                    viewHolder.ll_reply = (LinearLayout) convertView.findViewById(R.id.ll_reply);
                    viewHolder.tv_user_nick = (TextView) convertView.findViewById(R.id.tv_user_nick);
                    viewHolder.tv_subComment = (TextView) convertView.findViewById(R.id.tv_subComment);
                    viewHolder.iv_avatar = (TsdCircleImageView) convertView.findViewById(R.id.iv_avatar);
                    viewHolder.tv_time = (TextView) convertView.findViewById(R.id.tv_time);
                    viewHolder.tv_all_reply = (TextView) convertView.findViewById(R.id.tv_all_reply);
                    viewHolder.tv_reply = (TextView) convertView.findViewById(R.id.tv_reply);

                    viewHolder.tv_all_reply.setOnClickListener(this);
                    viewHolder.tv_reply.setOnClickListener(this);
                    break;
                case TYPE_ALL_COMPLETE:
                    break;
            }
            if (null != convertView)
                convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        if (type == TYPE_NOR) {
            viewHolder.tv_all_reply.setTag(position);
            viewHolder.tv_reply.setTag(position);
            renderNor(viewHolder, position);
        } else if (type == TYPE_NO_COMMENT) {
            renderNoComment(viewHolder);
        } else if (type == TYPE_ALL_COMPLETE) {

        }

        return convertView;
    }

    private void renderNoComment(ViewHolder viewHolder) {
        if (ContextHolder.getHideComment()) {
            viewHolder.tv_no_comment.setText(mContext.getResources().getString(R.string.tsd_no_comments));
        } else
            viewHolder.tv_no_comment.setText(mContext.getResources().getString(
                    R.string.tsd_no_comments_click_publish));
    }

    private void setllReply(SubCommentEntity.LatestsubComment mLatestsubComment, ViewHolder viewHolder) {
        if (null != mLatestsubComment)
            viewHolder.ll_reply.setVisibility(View.VISIBLE);
        else {
            viewHolder.ll_reply.setVisibility(View.GONE);
            return;
        }
        String commentContent = mLatestsubComment.commentContent;
        String userNick = null == mLatestsubComment.userNick ? "" : mLatestsubComment.userNick;
        userNick = userNick + ":";
        viewHolder.tv_subComment.setText(Html.fromHtml("<font color='#406599'>" + userNick + "</font>" + commentContent));
    }

    private void renderNor(ViewHolder viewHolder, int position) {
        SubCommentEntity data = (SubCommentEntity) mData.get(position);
        SubCommentEntity.LatestsubComment mLatestsubComment = data.latestsubComment;
        String commentContent = null == data.commentContent ? "" : data.commentContent;
        String userIcon = null == data.userAvatar ? "" : data.userAvatar;
        String commentTime = null == data.commentTime ? "" : data.commentTime;
        commentTime = TimeUtil.getStrTime(commentTime);
        commentTime = TimeUtil.getNiceDate(commentTime);
        String userNick = null == data.userNickName ? "" : data.userNickName;
        String subCommentNum = null == data.subCommentNum ? "" : data.subCommentNum;

        if (subCommentNum.equals("0"))
            subCommentNum = "";
        viewHolder.tv_reply.setText(subCommentNum + "回复");

        setllReply(mLatestsubComment, viewHolder);
        viewHolder.tv_content.setText(commentContent);
        viewHolder.tv_user_nick.setText(userNick);
        viewHolder.tv_time.setText(commentTime);
        Glide.with(mContext).setDefaultRequestOptions(options_avatar).load(userIcon).transition(
                new DrawableTransitionOptions().crossFade(500)).into(viewHolder.iv_avatar);
    }

    public void clickAllReply(int position) {
        Activity activity = ((Activity) mContext);
        if (!(activity instanceof TsdH5ReaderActivity)) return;
        SubCommentEntity data = (SubCommentEntity) mData.get(position);
        TsdH5ReaderActivity readerActivity = ((TsdH5ReaderActivity) activity);
        readerActivity.showContentWidget(data);

        //readerActivity.setSubCommEntity(data);

        SubCommEntity subCommEntity = new SubCommEntity();
        subCommEntity.parentId = data.id;
        subCommEntity.parentCommentId = data.id;
        subCommEntity.superiorCommentId = data.id;
        subCommEntity.parentNick = data.userNickName;
        subCommEntity.parentIcon = data.userAvatar;
        readerActivity.setSubCommEntity(subCommEntity);

    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.tv_all_reply || id == R.id.tv_reply) {
        int position = (int) v.getTag();
            clickAllReply(position);
        }
    }

    private static class ViewHolder {
        private TextView tv_content;
        private TextView tv_subComment;
        private LinearLayout ll_reply;
        private TextView tv_all_reply;
        private TextView tv_reply;
        private TextView tv_no_comment;
        private TextView tv_user_nick;
        private TextView tv_time;
        private TsdCircleImageView iv_avatar;
    }

}
