package ai.botbrain.ttcloud.sdk.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.GestureDetector;
import android.view.GestureDetector.OnGestureListener;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebChromeClient.CustomViewCallback;
import android.webkit.WebSettings;
import android.webkit.WebSettings.LayoutAlgorithm;
import android.webkit.WebSettings.PluginState;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.FrameLayout.LayoutParams;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.firedata.sdk.Firedata;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.util.DensityUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.NetChangeUtil;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TsdVideoPlayActivity extends Activity implements OnGestureListener,
        View.OnTouchListener {
    private final static String TAG = TsdVideoPlayActivity.class.getSimpleName();

    private WebView content;
    private TextView tv_title;
    private String url;
    private String title;
    private GestureDetector gestureDetector;
    private FrameLayout video_fullView;
    private View xCustomView;
    private CustomViewCallback xCustomViewCallback;
    private MyChromeClient xwebchromeclient;
    private Dialog dialog;
    private RelativeLayout rl_title;
    private TextView geture_tv_bright_percentage;// 音量百分比,亮度百分比
    private float mBrightness = -1f; // 亮度
    private boolean firstScroll = false;// 每次触摸屏幕后，第一次scroll的标志
    private RelativeLayout gesture_bright_layout; // 亮度控制布局

    @SuppressLint({"NewApi", "JavascriptInterface"})
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tsd_activity_download);
        Firedata.pageViewStart("VideoPlayActivity");
        url = getIntent().getStringExtra("url");
        LogUtil.i(TAG, url);
        title = getIntent().getStringExtra("title");
        rl_title = (RelativeLayout) findViewById(R.id.rl_title);
        content = (WebView) findViewById(R.id.content1);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            content.getSettings().setMediaPlaybackRequiresUserGesture(true);
        }

        content.loadUrl(url);
        geture_tv_bright_percentage = (TextView) findViewById(R.id.geture_tv_bright_percentage);
        gesture_bright_layout = (RelativeLayout) findViewById(R.id.gesture_bright_layout);
        tv_title = (TextView) findViewById(R.id.tv_title);
        video_fullView = (FrameLayout) findViewById(R.id.video_fullView);
        xwebchromeclient = new MyChromeClient();
        tv_title.setText(title);
        findViewById(R.id.back).setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View arg0) {
                finish();
            }
        });
        content.addJavascriptInterface(new DemoJavaScriptInterface(), "demo");
        gestureDetector = new GestureDetector(TsdVideoPlayActivity.this,
                TsdVideoPlayActivity.this);
        final WebSettings webSettings = content.getSettings();
        String js = "javascript: var v=document.getElementsByTagName('video')[0]; "
                + "v.addEventListener('playing', function() { window.demo.clickonAndroid(); }, true); ";
        webSettings.setAppCacheEnabled(true);
        webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
        // 设置支持页面js可用
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        // 设置允许访问文件数据
        webSettings.setAllowFileAccess(true);
        // 可以使用localStorage
        webSettings.setDomStorageEnabled(true);
        // 可以有数据库
        webSettings.setDatabaseEnabled(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);// 设置此属性，可任意比例缩放
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setSavePassword(true);
        webSettings.setSaveFormData(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setGeolocationEnabled(true);
        webSettings.setGeolocationDatabasePath(Environment.getExternalStorageDirectory().getPath()+"html5webview");
        webSettings.setDomStorageEnabled(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setSupportZoom(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setLayoutAlgorithm(LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setPluginState(PluginState.ON);
        content.setWebChromeClient(xwebchromeclient);
        content.setWebViewClient(new WebViewClient() {

            @Override
            public boolean shouldOverrideUrlLoading(WebView view,
                                                    final String url) {
                System.out.println("url=" + url);
                return false;
            }

            @Override
            public void onLoadResource(WebView view, String url) {
                Log.e("cache", "onLoadResource-url=" + url);
                super.onLoadResource(view, url);
            }

            @Override
            public void onPageFinished(final WebView view, String url) {
                initNetChangePopWindows();
            }

        });

    }

    @SuppressLint("NewApi")
    private void initNetChangePopWindows() {
        if (NetChangeUtil.getNetWorkType(this) != NetChangeUtil.NETWORKTYPE_WIFI) {
            LayoutInflater inflater = LayoutInflater.from(this);
            final ViewGroup nullParent = null;
            View view = inflater.inflate(R.layout.tsd_net_change_show, nullParent);
            if (dialog == null) {
                dialog = new AlertDialog.Builder(this).create();
                dialog.show();
            }
            dialog.getWindow().setContentView(view);
            dialog.getWindow().setLayout(DensityUtil.dip2px(this, 280),
                    DensityUtil.dip2px(this, 125));
            LinearLayout mCannel = (LinearLayout) view.findViewById(R.id.l1);
            LinearLayout mSure = (LinearLayout) view.findViewById(R.id.l2);
            mCannel.setOnClickListener(new OnClickListener() {

                @Override
                public void onClick(View v) {
                    dialog.dismiss();
                }
            });

            mSure.setOnClickListener(new OnClickListener() {

                @SuppressLint("NewApi")
                @Override
                public void onClick(View v) {
                    // 设置4.2以后版本支持autoPlay，非用户手势促发
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                        content.getSettings().setMediaPlaybackRequiresUserGesture(false);
                    }
                    String js = "javascript: var v=document.getElementsByTagName('video')[0]; " + "v.play(); ";
                    if (NetChangeUtil.getNetWorkType(TsdVideoPlayActivity.this) == NetChangeUtil.NETWORKTYPE_WIFI) {
                        content.loadUrl(js);
                    }
                    content.loadUrl("javascript:(function() { "
                            + "var videos = document.getElementsByTagName('video');"
                            + " for(var i=0;i<videos.length;i++){videos[i].play();}})()");
                    content.loadUrl("javascript:(function() { "
                            + "var videos = document.getElementsByTagName('audio');"
                            + " for(var i=0;i<videos.length;i++){videos[i].play();}})()");
                    dialog.dismiss();
                }
            });
        } else {
            // 设置4.2以后版本支持autoPlay，非用户手势促发
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                content.getSettings().setMediaPlaybackRequiresUserGesture(false);
            }
            String js = "javascript: var v=document.getElementsByTagName('video')[0]; " + "v.play(); ";
            content.loadUrl(js);
            content.loadUrl("javascript:(function() { " + "var videos = document.getElementsByTagName('video');" + " for(var i=0;i<videos.length;i++){videos[i].play();}})()");
            content.loadUrl("javascript:(function() { " + "var videos = document.getElementsByTagName('audio');" + " for(var i=0;i<videos.length;i++){videos[i].play();}})()");
        }

    }

	/*
    public class MyCallback implements CustomViewCallback {

		@Override
		public void onCustomViewHidden() {
			// TODO Auto-generated method stub

		}

	}*/

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) { // 注意这里不能用ONTOUCHEVENT方法，不然无效的
        if (xCustomView != null) {
            gestureDetector.onTouchEvent(ev);
            xCustomView.onTouchEvent(ev);
        }// 这几行代码也要执行，将webview载入MotionEvent对象一下，况且用载入把，不知道用什么表述合适
        if (ev.getAction() == MotionEvent.ACTION_UP) {
            gesture_bright_layout.setVisibility(View.GONE);
        }
        return super.dispatchTouchEvent(ev);
    }

    public class MyChromeClient extends WebChromeClient {

        @Override
        public void onShowCustomView(View view, CustomViewCallback callback) {
            if (xCustomView != null) {
                callback.onCustomViewHidden();
                return;
            }
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
            rl_title.setVisibility(View.GONE);
            video_fullView.setVisibility(View.VISIBLE);
            content.setVisibility(View.GONE);
            LayoutParams p = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
            video_fullView.addView(view, p);
            xCustomView = view;

            view.setLongClickable(true);
            gestureDetector.setIsLongpressEnabled(true);
            view.setOnTouchListener(TsdVideoPlayActivity.this);
            xCustomViewCallback = callback;

        }

        @Override
        public void onHideCustomView() {
            if (xCustomView == null) {
                return;
            }
            video_fullView.setVisibility(View.GONE);
            content.setVisibility(View.VISIBLE);
            video_fullView.removeAllViews();
            xCustomView = null;
            xCustomViewCallback.onCustomViewHidden();
            rl_title.setVisibility(View.VISIBLE);
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }

        @Override
        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            Log.d("ZR",
                    consoleMessage.message() + " at "
                            + consoleMessage.sourceId() + ":"
                            + consoleMessage.lineNumber());
            return super.onConsoleMessage(consoleMessage);
        }
    }

    private final class DemoJavaScriptInterface {
        DemoJavaScriptInterface() {
        }

        public void clickonAndroid() {
            content.loadUrl("javascript: var v=document.getElementsByTagName('video')[0]; "
                    + "v.webkitEnterFullscreen();");

        }

        public void endonAndroid() {

        }
    }

    public boolean inCustomView() {
        return (xCustomView != null);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void hideCustomView() {
        xwebchromeclient.onHideCustomView();
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        rl_title.setVisibility(View.VISIBLE);
    }

    @Override
    protected void onResume() {
        super.onResume();
        super.onResume();
        content.onResume();
        content.resumeTimers();
        if (getRequestedOrientation() != ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE) {
            rl_title.setVisibility(View.VISIBLE);
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        content.onPause();
        content.pauseTimers();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        content.clearCache(true);

        video_fullView.removeAllViews();
        content.stopLoading();
        content.setWebChromeClient(null);
        content.setWebViewClient(null);
        content.destroy();
        content = null;
        Firedata.pageViewEnd("VideoPlayActivity");
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if (inCustomView()) {
                hideCustomView();
                return true;
            } else {
                TsdVideoPlayActivity.this.finish();
            }
        }
        return false;
    }

    @Override
    public boolean onTouch(View arg0, MotionEvent event) {
        if (event.getAction() == MotionEvent.ACTION_UP) {
            gesture_bright_layout.setVisibility(View.GONE);
        }
        return gestureDetector.onTouchEvent(event);
    }

    @Override
    public boolean onDown(MotionEvent arg0) {
        // 设定是触摸屏幕后第一次scroll的标志
        firstScroll = true;
        return false;
    }

    @Override
    public boolean onFling(MotionEvent arg0, MotionEvent arg1, float arg2, float arg3) {
        return false;
    }

    @Override
    public void onLongPress(MotionEvent arg0) {
    }

    @SuppressLint("NewApi")
    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX,
                            float distanceY) {
        float mOldX = e1.getX(), mOldY = e1.getY();
        int y = (int) e2.getRawY();
        if (firstScroll) {// 以触摸屏幕后第一次滑动为标准，避免在屏幕上操作切换混乱
            // 横向的距离变化大则调整进度，纵向的变化大则调整音量
            if (Math.abs(distanceX) >= Math.abs(distanceY)) {

            } else {
                gesture_bright_layout.setVisibility(View.VISIBLE);
            }
        }
        // 如果每次触摸屏幕后第一次scroll是调节进度，那之后的scroll事件都处理音量进度，直到离开屏幕执行下一次操作
        if (mBrightness < 0) {
            mBrightness = getWindow().getAttributes().screenBrightness;
            if (mBrightness <= 0.00f)
                mBrightness = 0.50f;
            if (mBrightness < 0.01f)
                mBrightness = 0.01f;
        }
        Resources resources = this.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        float density1 = dm.density;
        int width3 = dm.widthPixels;
        int height3 = dm.heightPixels;
        WindowManager.LayoutParams lpa = getWindow().getAttributes();
        lpa.screenBrightness = mBrightness + (mOldY - y) / height3;
        if (lpa.screenBrightness > 1.0f)
            lpa.screenBrightness = 1.0f;
        else if (lpa.screenBrightness < 0.01f)
            lpa.screenBrightness = 0.01f;
        getWindow().setAttributes(lpa);
        geture_tv_bright_percentage.setText((int) (lpa.screenBrightness * 100) + "%");

        firstScroll = false;// 第一次scroll执行完成，修改标志
        return false;
    }

    @Override
    public void onShowPress(MotionEvent arg0) {
    }

    @Override
    public boolean onSingleTapUp(MotionEvent arg0) {
        return false;
    }

}
