package ai.botbrain.ttcloud.sdk.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;

import com.youku.cloud.module.PlayerErrorInfo;
import com.youku.cloud.player.PlayerListener;
import com.youku.cloud.player.VideoDefinition;
import com.youku.cloud.player.YoukuPlayerView;
import com.youku.cloud.player.YoukuUIListener;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.LogUtil;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TsdVideoFullscreenActivity extends Activity {
    private Context mContext;

    private String vid;
    private String iid;

    //= "XMTg0NDQxNjExNg==";
    private YoukuPlayerView youkuPlayerView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tsd_activity_video_fullscreen);
        mContext = this;
        initData();

        youkuPlayerView = (YoukuPlayerView) findViewById(R.id.baseview);
        youkuPlayerView.attachActivity(this);
        youkuPlayerView.setPreferVideoDefinition(VideoDefinition.VIDEO_HD);
        youkuPlayerView.setPlayerListener(new MyPlayerListener());
        youkuPlayerView.playYoukuVideo(vid);
        youkuPlayerView.goFullScreen();
        youkuPlayerView.setUIListener(new YoukuUIListener() {
            @Override
            public void onBackBtnClick() {
                TsdVideoFullscreenActivity.this.finish();
            }

            @Override
            public void onFullBtnClick() {
                //Toast.makeText(VideoFullscreenActivity.this, "竖屏", Toast.LENGTH_SHORT).show();
                //Toast.makeText(mContext, "竖屏", Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void initData() {
        Intent intent = getIntent();
        vid = intent.getStringExtra("vid");
        iid = intent.getStringExtra("iid");
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        youkuPlayerView.release();
        finish();
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (null != youkuPlayerView) {
            youkuPlayerView.onPause();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (null != youkuPlayerView) {
            youkuPlayerView.playYoukuVideo(vid);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        youkuPlayerView.onDestroy();
    }

    private class MyPlayerListener extends PlayerListener {
        @Override
        public void onComplete() {
            super.onComplete();
        }

        @Override
        public void onTimeout() {
            super.onTimeout();
            Toast.makeText(mContext, "onTimeout", Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onError(int code, PlayerErrorInfo info) {
            super.onError(code, info);
            new RestApiImpl().reportVid(code, iid);
            LogUtil.i("MainActivity", "code" + code + "info" + info.getDesc());
        }

        @Override
        public void OnCurrentPositionChanged(int msec) {
            super.OnCurrentPositionChanged(msec);
        }

        @Override
        public void onVideoNeedPassword(int code) {
            super.onVideoNeedPassword(code);
        }
    }


}
