package ai.botbrain.ttcloud.sdk.activity;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AdapterView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.lzy.okgo.model.Response;
import com.lzy.okgo.callback.StringCallback;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;
import java.util.List;

import ai.botbrain.ttcloud.api.TtCloudListener;
import ai.botbrain.ttcloud.api.TtCloudManager;
import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.adapter.ContentAdapter;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentsEntity;
import ai.botbrain.ttcloud.sdk.model.UpCountEntity;
import ai.botbrain.ttcloud.sdk.net.RestApi;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.swipeBack.SwipeBackActivity;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.GsonUtil;
import ai.botbrain.ttcloud.sdk.util.KeyBoardUtil;
import ai.botbrain.ttcloud.sdk.util.LogUtil;
import ai.botbrain.ttcloud.sdk.util.ScreenUtils;
import ai.botbrain.ttcloud.sdk.util.ToastUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;
import ai.botbrain.ttcloud.sdk.widget.InputDailog;
import ai.botbrain.ttcloud.sdk.widget.SubCommentsWidget;
import cn.bingoogolapple.refreshlayout.BGANormalRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;

import static android.view.View.inflate;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/22.
 */
public class TsdH5ReaderActivity extends SwipeBackActivity implements TextView.OnEditorActionListener,
        AdapterView.OnItemClickListener, BGARefreshLayout.BGARefreshLayoutDelegate {
    private static final String TAG = TsdH5ReaderActivity.class.getSimpleName();
    private Context mContext;

    private ImageButton btn_up;
    private WebView mWebView;
    private ListView mListView;
    private TextView tv_count;
    private ContentAdapter mAdapter;
    private LinearLayout bottom_bar;
    private TextView tv_title;
    public SubCommentsWidget mSubCommentsWidget;

    private RestApi restApi;
    private CommentListObserver commentListObserver;
    private LikeObserver likeObserver;
    private BGARefreshLayout mRefreshLayout;
    private RelativeLayout rl_container;

    public String iid;
    private String title;
    private String mColumnId;
    private String contentUrl;
    private String shareThumb;
    private String toast_liked;
    private String toast_complete;

    private boolean isClickLike = false;
    private SubCommEntity mSubCommEntity;
    public InputDailog dialog;

    private static final String EXTRA_URL = "extra_url";
    private String mUrl;
    private List<SubCommentEntity> datas;
    private int likesCount;

    private int current = 0;
    private boolean isShownLoadMoreView = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            WindowManager.LayoutParams localLayoutParams = getWindow().getAttributes();
            localLayoutParams.flags = (WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS | localLayoutParams.flags);
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(Color.TRANSPARENT);
        }

        setContentView(R.layout.tsd_activity_h5_reader2);
        initVariables();
        initView();
    }

    public void showInputDialog() {
        dialog = InputDailog.newInstance("回复" + mSubCommEntity.parentNick);
        dialog.show(getSupportFragmentManager(), "dialog");
    }

    public void setSubCommEntity(SubCommEntity subCommEntity) {
        mSubCommEntity = subCommEntity;
    }

    public SubCommEntity getSubCommentEntity() {
        return mSubCommEntity;
    }

    private void initVariables() {
        mContext = this;
        initResString();
        dialog = new InputDailog();
        restApi = new RestApiImpl();
        commentListObserver = new CommentListObserver();
        likeObserver = new LikeObserver();
        initParams();
        if (null == datas)
            datas = new ArrayList<>();
        mAdapter = new ContentAdapter(mContext, datas);
    }

    private void initResString() {
        toast_liked = ContextHolder.getContext().getResources().getString(R.string.tsd_toast_liked);
        toast_complete = ContextHolder.getContext().getResources().getString(R.string.tsd_toast_complete);
    }

    private void initRefreshLayout() {
        mRefreshLayout = (BGARefreshLayout) findViewById(R.id.rl_modulename_refresh);
        mRefreshLayout.setDelegate(this);
        mRefreshLayout.setPullDownRefreshEnable(false);
        BGANormalRefreshViewHolder refreshViewHolder = new BGANormalRefreshViewHolder(mContext, true);
        mRefreshLayout.setRefreshViewHolder(refreshViewHolder);
    }

    public void showContentWidget(SubCommentEntity data) {
        mSubCommentsWidget.show();
        mSubCommentsWidget.renderTop(data);
    }

    private void setSubWidgetPaddTopHeight() {
        int top = ScreenUtils.getStatusHeight(this);
        rl_container.setPadding(0, top, 0, 0);
    }

    private void initView() {
        initRefreshLayout();
        rl_container = (RelativeLayout) findViewById(R.id.rl_container);
        setSubWidgetPaddTopHeight();
        mSubCommentsWidget = (SubCommentsWidget) findViewById(R.id.contents_widget);
        mSubCommentsWidget.setEnabled(true);
        tv_title = (TextView) findViewById(R.id.tv_title);
        ImageView iv_back = (ImageView) findViewById(R.id.iv_back);
        mListView = (ListView) findViewById(R.id.listview);
        mListView.setOnItemClickListener(this);
        addWebViewToListView(mListView);
        tv_count = (TextView) findViewById(R.id.tv_count);
        btn_up = (ImageButton) findViewById(R.id.btn_up);
        bottom_bar = (LinearLayout) findViewById(R.id.bottom_bar);
        initWebView();
        contentUrl = TextUtils.isEmpty(contentUrl) ? "" : contentUrl;
        mWebView.loadUrl(contentUrl + "&type=2");
        // 不显示
        //mWebView.loadUrl("https://bkd.botbrain.ai/view/v1/S4EBUTASGJ/article/AODgyMzE4ODU2MjQ?platform=android&apt=S4EBUTASGJ");

        restApi.like(likeObserver, TsdConstant.HTTP_GET, iid);
        hideBottomLayout();

        iv_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                TsdH5ReaderActivity.this.finish();
            }
        });

    }

    private void hideBottomLayout() {
        if (ContextHolder.getHideComment())
            bottom_bar.setVisibility(View.GONE);
        else {
            bottom_bar.setVisibility(View.VISIBLE);
        }
    }

    private void addWebViewToListView(ListView listView) {
        View view = inflate(mContext, R.layout.tsd_adapter_webview, null);
        mWebView = (WebView) view.findViewById(R.id.content);
        listView.addHeaderView(view, null, false);
    }

    private void initParams() {
        Intent intent = getIntent();
        if (intent != null) {
            iid = intent.getStringExtra(TsdConstant.EXTRA_IID);
            //iid = "AODgxMDgyNjEzODQ";
            TsdSPUtils.put(mContext, "iid", iid);
            if (intent.hasExtra(TsdConstant.EXTRA_COLUMN_ID))
                mColumnId = intent.getStringExtra(TsdConstant.EXTRA_COLUMN_ID);
            mUrl = intent.getStringExtra(EXTRA_URL);
            contentUrl = getContentUrlByIid(iid);
            LogUtil.i(TAG, "contentUrl:" + contentUrl);
        }
    }

    private void setlikeCount() {
        tv_count.setVisibility(View.VISIBLE);
        mSubCommentsWidget.tv_widget_count.setVisibility(View.VISIBLE);

        btn_up.setImageResource(R.drawable.tsd_like_press);
        mSubCommentsWidget.ib_widget_like.setImageResource(R.drawable.tsd_like_press);

        btn_up.setActivated(true);
        mSubCommentsWidget.ib_widget_like.setActivated(true);
    }

    public void clickUp(View view) {
        if (!isClickLike) {
            setlikeCount();
            TtCloudListener.Article article = new TtCloudListener.Article();
            article.setContentTitle(title);
            article.setContentUrl(contentUrl);
            ContextHolder.getTtCloudListener().onLiked(article, ContextHolder.getUser());
            isClickLike = true;
            restApi.like(likeObserver, TsdConstant.HTTP_COUNT, iid);
        } else {
            ToastUtil.showShort(ContextHolder.getContext(), toast_liked);
        }
    }

    public void back(View view) {
        finish();
    }

    public void openShare(View view) {
        TtCloudListener.Article article = new TtCloudListener.Article();
        article.setContentTitle(title);
        article.setContentUrl(contentUrl + "&type=4");
        if (!TextUtils.isEmpty(shareThumb)) article.setThumb(shareThumb);
        ContextHolder.getTtCloudListener().onShare(view, article, ContextHolder.getUser(), new TtCloudListener.ResultCallBack() {
            @Override
            public void success() {
            }

            @Override
            public void failed() {

            }
            @Override
            public void setUserInfo(TtCloudListener.User user) {

            }
        });

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        /*
        String className = "com.umeng.socialize.UMShareAPI";
        try {
            Class aClass = Class.forName(className);
            Method method = aClass.getMethod("onActivityResult", int.class, int.class, Intent.class);
            method.invoke(requestCode, requestCode, data);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        */
        //UMShareAPI.get(this).onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
        boolean handled = false;
        if (actionId == EditorInfo.IME_ACTION_DONE) {
            ToastUtil.showShort(ContextHolder.getContext(), toast_complete);
            handled = true;
            KeyBoardUtil.hide((Activity) mContext);
        }
        return handled;
    }

    private void setTextSize() {
        this.mWebView.getSettings().setSupportZoom(true);
        int size = ContextHolder.getFont_size();
        if (size == 12) {
            this.mWebView.getSettings().setTextSize(WebSettings.TextSize.SMALLER);
        } else if (size == 18) {
            this.mWebView.getSettings().setTextSize(WebSettings.TextSize.LARGER);
        } else if (size == 20) {
            this.mWebView.getSettings().setTextSize(WebSettings.TextSize.LARGEST);
        } else {
            this.mWebView.getSettings().setTextSize(WebSettings.TextSize.NORMAL);
        }
    }

    @JavascriptInterface
    @SuppressWarnings("unused")
    public void getImagesFromHtml(String json) {
        try {
            JSONArray jsonArray = new JSONArray(json);
            shareThumb = jsonArray.optString(0);
            LogUtil.i(TAG, "This method is called!" + shareThumb);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void initWebView() {
        WebChromeClient mWebChromeClient = new WebChromeClient();
        this.mWebView.setWebChromeClient(mWebChromeClient);
        this.mWebView.addJavascriptInterface(TsdH5ReaderActivity.this, "botbrain");

        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                title = view.getTitle();
                tv_title.setText(title);
                mListView.setAdapter(mAdapter);
                current = 0;
                datas.clear();
                restApi.commentList(commentListObserver, iid, current);
            }
        });
        setTextSize();
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setBlockNetworkImage(false);
        this.mWebView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.mWebView.getSettings().setUserAgentString(this.mWebView.getSettings().getUserAgentString());
        this.mWebView.getSettings().setDatabaseEnabled(true);
        this.mWebView.setScrollBarStyle(View.SCROLLBARS_INSIDE_OVERLAY);
        LogUtil.i(TAG, mWebView.getSettings().getUserAgentString());
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }

        if (Build.VERSION.SDK_INT > 15) {
            this.mWebView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        }
        if ((Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) && (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR1)) {
            fixWebView();
        }
    }

    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    private void fixWebView() {
        this.mWebView.removeJavascriptInterface("searchBoxJavaBridge_");
    }

    private void renderCommentList(String json) {
        SubCommentsEntity entity = GsonUtil.GsonToBean(json, SubCommentsEntity.class);
        datas.addAll(entity.data);
        if (datas.size() > 0) {
            if (!isShownLoadMoreView) {
                isShownLoadMoreView = true;
            }
        }
        if (datas.size() > 0 && current > 0 && entity.data.size() == 0) {

        }
        if (entity.data.size() < 6 && datas.size() != 0) {
            mRefreshLayout.setIsShowLoadingMoreView(false);
            View v = View.inflate(mContext, R.layout.tsd_item_all_complete, null);
            mListView.addFooterView(v);
            isCanLoadMore = false;
        }
        mAdapter.notifyDataSetChanged();
    }

    public void writeCommentClick(View view) {
        if (!ContextHolder.isLogin()) {
            ContextHolder.getTtCloudListener().onComment(view, null, null);
        } else {
            dialog.newInstance().show(getSupportFragmentManager(), "dialog");
        }
        //mSubCommEntity = null;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        if (position == 1 && datas.size() == 0 && !ContextHolder.getHideComment()) {
            InputDailog.newInstance().show(getSupportFragmentManager(), "dialog");
            return;
        }
        if (datas.size() > (position - 1)) {
            mAdapter.clickAllReply(--position);
        }
    }

    @Override
    public void onBGARefreshLayoutBeginRefreshing(BGARefreshLayout refreshLayout) {
    }

    @Override
    public boolean onBGARefreshLayoutBeginLoadingMore(BGARefreshLayout refreshLayout) {
        if (!isCanLoadMore) return isCanLoadMore;
        current = current + TsdConstant.REQUEST_COUNT_CONTENT_LIST;
        restApi.commentList(commentListObserver, iid, current);
        return isCanLoadMore;
    }

    boolean isCanLoadMore = true;

    public void addComment2(SubCommentEntity data) {
        mSubCommentsWidget.mDatas.add(0, data);
        mSubCommentsWidget.mListView.smoothScrollToPosition(0);
        mSubCommentsWidget.mSubCommentAdapter.notifyDataSetChanged();
        mSubCommentsWidget.renderReplyNum();
    }

    /**
     * 加入一级回复列表
     * @param subCommentEntity
     */
    public void addComment(SubCommentEntity subCommentEntity) {
        if (!isShownLoadMoreView) {
            isShownLoadMoreView = true;
        }
        datas.add(0, subCommentEntity);
        mAdapter.notifyDataSetChanged();
    }

    private final class CommentListObserver extends StringCallback {

        @Override
        public void onError(Response<String> response) {
            super.onError(response);
            mRefreshLayout.endLoadingMore();
            isShowLoadMoreView();
        }

        @Override
        public void onSuccess(Response<String> response) {
            String s = response.body();
            mRefreshLayout.endLoadingMore();
            renderCommentList(s);
            isShowLoadMoreView();
        }

    }

    private void isShowLoadMoreView() {
        if (datas.size() == 0) {
            mRefreshLayout.setIsShowLoadingMoreView(false);
        } else {
            mRefreshLayout.setIsShowLoadingMoreView(true);
        }
    }

    private final class LikeObserver extends StringCallback {

        public void onSuccess(Response<String> response) {
            String s = response.body();
            try {
                UpCountEntity countEntity = GsonUtil.GsonToBean(s, UpCountEntity.class);
                likesCount = Integer.valueOf(countEntity.data);
                setTv_count();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }

    public void setTv_count() {
        if (likesCount > 0) {
            tv_count.setVisibility(View.VISIBLE);
            tv_count.setText(String.valueOf(likesCount));

            mSubCommentsWidget.tv_widget_count.setVisibility(View.VISIBLE);
            mSubCommentsWidget.tv_widget_count.setText(String.valueOf(likesCount));
        } else {
            tv_count.setVisibility(View.GONE);
            mSubCommentsWidget.tv_widget_count.setVisibility(View.GONE);
        }
    }

    private String getContentUrlByIid(String iid) {
        String contentUrl = RestApiImpl.API_URL_ARTICLE + TtCloudManager.getAppId() + "/article/" + iid +
                "?platform=android&apt=" + TtCloudManager.getAppId();
        if (!TextUtils.isEmpty(mColumnId)) {
            contentUrl = contentUrl + "&columnid=" + mColumnId;
        }
        if (!TextUtils.isEmpty(mUrl)) {
            return mUrl;
        }
        return contentUrl;
    }

}
