package ai.botbrain.ttcloud.api;


import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;

import ai.botbrain.ttcloud.sdk.TsdConstant;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.activity.TsdSearchActivity;
import ai.botbrain.ttcloud.sdk.fragment.IndexFragment;
import ai.botbrain.ttcloud.sdk.net.RestApiImpl;
import ai.botbrain.ttcloud.sdk.util.Ad360Mamager;
import ai.botbrain.ttcloud.sdk.util.ContextHolder;
import ai.botbrain.ttcloud.sdk.util.FireDataManager;
import ai.botbrain.ttcloud.sdk.util.OkHttpManager;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.util.TsdSPUtils;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/3/21.
 */
public class TtCloudManager {

    public static boolean DEBUG = false;
    private static boolean mShowResponse = false;
    public static boolean LOG = true;

    private static String appId;
    private static String appKey;

    private static String sid = "";

    public static void init(Application application, TtcClient client) {
        try {
            ApplicationInfo appInfo = application.getPackageManager()
                    .getApplicationInfo(application.getPackageName(), PackageManager.GET_META_DATA);
            appId = appInfo.metaData.getString("TTC_APPID");
            appKey = appInfo.metaData.getString("TTC_APPKEY");
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        if (null != client) {
            LOG = client.isShowLog();
            mShowResponse = client.isShowResponse();
            DEBUG = client.isDebug();
        }
        hideComment(client);
        ContextHolder.initialContext(application);
        OkHttpManager.initOkHttp3(mShowResponse);
        Ad360Mamager.initSdk(false);
        sid = TimeUtil.getTimestamp();
        new RestApiImpl().getYouKuConfig();
        FireDataManager.init(application, appId, appKey);
    }

    private static void hideComment(TtcClient client) {
        if (null!=client && client.isHideComment()) {
            ContextHolder.setHideComment();
        }
    }

    public static void init(Application application) {
        init(application, null);
    }

    @SuppressWarnings("unused")
    public static void hideActionBar(boolean b) {
        ContextHolder.setIsShowActionBar(b);
    }

    public static String getAppId() {
        return appId;
    }

    public static String getSid() {
        return sid;
    }

    public static void setCallBack(TtCloudListener ttCloudListener) {
        ContextHolder.initTtCloudListener(ttCloudListener);
    }

    public static void login(TtCloudListener.User user) {
        ContextHolder.initalUser(user);
    }

    /**
     * 注销操作
     */
    public static void logout() {
        TsdSPUtils.remove(ContextHolder.getContext(), TsdConstant.PRE_USER_ID);
        ContextHolder.clearUser();
    }

    public static boolean isLogin() {
        return ContextHolder.isLogin();
    }

    /**
     * 禁止viewPager滑动
     */
    @SuppressWarnings("unused")
    public static void setNotScroll() {
        ContextHolder.setCanScroll(false);
    }

    @SuppressWarnings("unused")
    public static void setLoadingErrorView(int loadingErrorView) {
        ContextHolder.showLoadErrorView(loadingErrorView);
    }

    protected static void setFontSize(int size) {
        ContextHolder.setFont_size(size);
    }

    @SuppressWarnings("unused")
    public static void openArticleDetailActivity(Context context, String extra_iid) {
        Intent intent = new Intent();
        intent.setClass(context, TsdH5ReaderActivity.class);
        intent.putExtra(TsdConstant.EXTRA_IID, extra_iid);
        context.startActivity(intent);
    }

    @SuppressWarnings("unused")
    public static void openSearchActivity(Context context) {
        Intent intent = new Intent();
        intent.setClass(context, TsdSearchActivity.class);
        context.startActivity(intent);
    }

    @SuppressWarnings("unused")
    public static void setAppId(String appId) {
        TtCloudManager.appId = appId;
    }

    @SuppressWarnings("unused")
    public static IndexFragment getVideoFragment() {
        return IndexFragment.newInstance(IndexFragment.TYPE_VIDEO);
    }

    @SuppressWarnings("unused")
    public static IndexFragment getNewsFragment() {
        return IndexFragment.newInstance(IndexFragment.TYPE_ARTICLE);
    }

    @SuppressWarnings("unused")
    public static IndexFragment getDefaultFragment() {
        return IndexFragment.newInstance();
    }
}
