/*
 * Decompiled with CFR 0.152.
 */
package agency.tango.android.avatarview.views;

import agency.tango.android.avatarview.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.widget.ImageView;
import timber.log.Timber;

public class AvatarView
extends ImageView {
    private int defaultBorderColor;
    private int defaultBorderWidth;
    private int defaultTextSizePercentage;
    private int borderColor;
    private int borderWidth;
    private int textSizePercentage;
    private int viewSize;
    private Drawable drawable;
    int circleRadius;
    int circleCenterXValue;
    int circleCenterYValue;
    private Paint borderPaint = new Paint();
    private Paint mainPaint = new Paint();
    private Rect circleRect;

    public AvatarView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AvatarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AvatarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @RequiresApi(api=21)
    public AvatarView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public void onDraw(Canvas canvas) {
        this.saveBasicValues(canvas);
        if (this.viewSize == 0) {
            return;
        }
        Bitmap bitmap = this.cutIntoCircle(this.drawableToBitmap(this.drawable));
        if (bitmap == null) {
            return;
        }
        canvas.translate((float)this.circleCenterXValue, (float)this.circleCenterYValue);
        canvas.drawCircle((float)(this.circleRadius + this.borderWidth), (float)(this.circleRadius + this.borderWidth), (float)(this.circleRadius + this.borderWidth), this.borderPaint);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
    }

    public int textSizePercentage() {
        return this.textSizePercentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.setDefaultBorderValues();
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AvatarView, 0, 0);
            try {
                this.configureBorderValues(typedArray);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.borderPaint.setAntiAlias(true);
        this.borderPaint.setStyle(Paint.Style.FILL);
        this.borderPaint.setColor(this.borderColor);
        this.mainPaint.setAntiAlias(true);
        this.mainPaint.setColor(this.getResources().getColor(R.color.av_bitmap_background_color));
        this.mainPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)this.viewSize, (int)this.viewSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, this.viewSize, this.viewSize);
            drawable.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError error) {
            Timber.d((Throwable)error, (String)"OutOfMemoryError occurred while generating bitmap", (Object[])new Object[0]);
            return null;
        }
    }

    private Bitmap cutIntoCircle(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        try {
            Bitmap output = Bitmap.createBitmap((int)this.viewSize, (int)this.viewSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            canvas.drawARGB(0, 0, 0, 0);
            canvas.drawCircle((float)(this.circleRadius + this.borderWidth), (float)(this.circleRadius + this.borderWidth), (float)this.circleRadius, this.borderPaint);
            canvas.drawBitmap(bitmap, this.circleRect, this.circleRect, this.mainPaint);
            return output;
        }
        catch (OutOfMemoryError error) {
            Timber.d((Throwable)error, (String)"OutOfMemoryError occurred while generating bitmap", (Object[])new Object[0]);
            return null;
        }
    }

    private void setDefaultBorderValues() {
        this.defaultBorderColor = this.getResources().getColor(R.color.av_default_border);
        this.defaultBorderWidth = this.getResources().getDimensionPixelSize(R.dimen.av_default_border_width);
        this.defaultTextSizePercentage = 33;
    }

    private void configureBorderValues(TypedArray typedArray) {
        this.borderColor = typedArray.getColor(R.styleable.AvatarView_av_border_color, this.defaultBorderColor);
        this.borderWidth = typedArray.getDimensionPixelSize(R.styleable.AvatarView_av_border_width, this.defaultBorderWidth);
        this.textSizePercentage = typedArray.getInt(R.styleable.AvatarView_av_text_size_percentage, this.defaultTextSizePercentage);
    }

    private void saveBasicValues(Canvas canvas) {
        int viewHeight = canvas.getHeight();
        int viewWidth = canvas.getWidth();
        this.viewSize = Math.min(viewWidth, viewHeight);
        this.circleCenterXValue = (viewWidth - this.viewSize) / 2;
        this.circleCenterYValue = (viewHeight - this.viewSize) / 2;
        this.circleRadius = (this.viewSize - this.borderWidth * 2) / 2;
        this.circleRect = new Rect(0, 0, this.viewSize, this.viewSize);
        this.maximizeAvailableBorderSize();
        if (this.viewSize != 0) {
            this.drawable = this.getDrawable();
        }
    }

    void maximizeAvailableBorderSize() {
        if (this.viewSize / 3 < this.borderWidth) {
            this.borderWidth = this.viewSize / 3;
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }
}

