/*
 * Decompiled with CFR 0.152.
 */
package agency.tango.android.avatarview;

import agency.tango.android.avatarview.utils.StringUtils;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;

public class AvatarPlaceholder
extends Drawable {
    public static final String DEFAULT_PLACEHOLDER_STRING = "?";
    private static final String DEFAULT_PLACEHOLDER_COLOR = "#3F51B5";
    private static final String COLOR_FORMAT = "#FF%06X";
    public static final int DEFAULT_TEXT_SIZE_PERCENTAGE = 33;
    private Paint textPaint;
    private Paint backgroundPaint;
    private RectF placeholderBounds;
    private String avatarText;
    private int textSizePercentage;
    private String defaultString;
    private float textStartXPoint;
    private float textStartYPoint;

    public AvatarPlaceholder(String name) {
        this(name, 33, DEFAULT_PLACEHOLDER_STRING);
    }

    public AvatarPlaceholder(String name, @IntRange int textSizePercentage) {
        this(name, textSizePercentage, DEFAULT_PLACEHOLDER_STRING);
    }

    public AvatarPlaceholder(String name, @NonNull String defaultString) {
        this(name, 33, defaultString);
    }

    public AvatarPlaceholder(String name, @IntRange int textSizePercentage, @NonNull String defaultString) {
        this.defaultString = this.resolveStringWhenNoName(defaultString);
        this.avatarText = this.convertNameToAvatarText(name);
        this.textSizePercentage = textSizePercentage;
        this.textPaint = new Paint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setColor(Color.parseColor((String)"white"));
        this.textPaint.setTypeface(Typeface.create((String)"sans-serif-light", (int)0));
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setAntiAlias(true);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.backgroundPaint.setColor(Color.parseColor((String)this.convertStringToColor(name)));
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.placeholderBounds == null) {
            this.placeholderBounds = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
            this.setAvatarTextValues();
        }
        canvas.drawRect(this.placeholderBounds, this.backgroundPaint);
        canvas.drawText(this.avatarText, this.textStartXPoint, this.textStartYPoint, this.textPaint);
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
        this.backgroundPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.textPaint.setColorFilter(colorFilter);
        this.backgroundPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    private void setAvatarTextValues() {
        this.textPaint.setTextSize(this.calculateTextSize());
        this.textStartXPoint = this.calculateTextStartXPoint();
        this.textStartYPoint = this.calculateTextStartYPoint();
    }

    private float calculateTextStartXPoint() {
        float stringWidth = this.textPaint.measureText(this.avatarText);
        return (float)this.getBounds().width() / 2.0f - stringWidth / 2.0f;
    }

    private float calculateTextStartYPoint() {
        return (float)this.getBounds().height() / 2.0f - (this.textPaint.ascent() + this.textPaint.descent()) / 2.0f;
    }

    private String resolveStringWhenNoName(String stringWhenNoName) {
        return StringUtils.isNotNullOrEmpty(stringWhenNoName) ? stringWhenNoName : DEFAULT_PLACEHOLDER_STRING;
    }

    private String convertNameToAvatarText(String name) {
        return StringUtils.isNotNullOrEmpty(name) ? name.substring(0, 1).toUpperCase() : this.defaultString;
    }

    private String convertStringToColor(String text) {
        return StringUtils.isNullOrEmpty(text) ? DEFAULT_PLACEHOLDER_COLOR : String.format(COLOR_FORMAT, 0xFFFFFF & text.hashCode());
    }

    private float calculateTextSize() {
        if (this.textSizePercentage < 0 || this.textSizePercentage > 100) {
            this.textSizePercentage = 33;
        }
        return (float)this.getBounds().height() * (float)this.textSizePercentage / 100.0f;
    }
}

