/*
 * Decompiled with CFR 0.152.
 */
package admobilize.adtrackerlib.control;

import admobilize.adtrackerlib.control.ConfigParameters;
import admobilize.adtrackerlib.control.OnDetectorActionListener;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;

public class ConfigManager {
    private static final String TAG = ConfigManager.class.getSimpleName();
    public static final String action_detector_webhook = "admobilize.broadcast.data";
    private static final String action_get_detector_id = "ACTION_GET_ADMOBILIZE_DETECTOR_ID";
    private static final String action_on_detector_id = "ACTION_ON_ADMOBILIZE_DETECTOR_ID";
    private final Context ctx;
    private final OnDetectorActionListener eventListener;
    private String action_name;
    private String action_url;
    private String action_enable;
    private String action_start;
    private String action_stop;
    private String action_update_config_details;
    private String action_request_preview;
    private String action_update_preview;
    private String action_request_config_details;
    private String action_orientation;
    private String action_orientation_status;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String data;
            Bundle extras;
            String action = intent.getAction();
            if (action.equals(ConfigManager.this.action_name)) {
                ConfigManager.this.eventListener.onChangeName(intent.getExtras().getString("key_camera_name"));
            } else if (action.equals(ConfigManager.this.action_url)) {
                ConfigManager.this.eventListener.onChangeUrl(intent.getExtras().getString("key_camera_url"));
            } else if (action.equals(ConfigManager.this.action_enable)) {
                ConfigManager.this.eventListener.onServiceEnable(intent.getExtras().getBoolean("key_camera_enable"));
            } else if (action.equals(ConfigManager.this.action_start)) {
                ConfigManager.this.eventListener.onServiceStart();
            } else if (action.equals(ConfigManager.this.action_stop)) {
                String msg = intent.getExtras().getString("key_camera_service_msg");
                ConfigManager.this.eventListener.onServiceStop(msg);
            } else if (action.equals(ConfigManager.this.action_request_config_details)) {
                ConfigManager.this.eventListener.onRequestConfigDetails();
            } else if (action.equals(ConfigManager.this.action_update_config_details)) {
                String name = intent.getExtras().getString("key_camera_name");
                String url = intent.getExtras().getString("key_camera_url");
                String orientation = intent.getExtras().getString("key_camera_orientation");
                boolean isOrientationChangeAllowed = intent.getExtras().getBoolean("key_camera_orientation_allowed");
                boolean enable = intent.getExtras().getBoolean("key_camera_enable");
                ConfigParameters params = new ConfigParameters(name, url);
                params.orientation = orientation;
                params.isOrientationChangeAllowed = isOrientationChangeAllowed;
                params.isDetectionRunning = enable;
                ConfigManager.this.eventListener.onUpdateConfigDetails(params);
            } else if (action.equals(ConfigManager.this.action_request_preview)) {
                ConfigManager.this.eventListener.onRequestPreview();
            } else if (action.equals(ConfigManager.this.action_update_preview)) {
                byte[] preview = intent.getExtras().getByteArray("key_camera_preview");
                ConfigManager.this.eventListener.onUpdatePreview(preview);
            } else if (action.equals(ConfigManager.this.action_orientation_status)) {
                boolean isOrientationAllowed = intent.getExtras().getBoolean("key_camera_orientation_allowed");
                ConfigManager.this.eventListener.onUpdateOrientationAllowed(isOrientationAllowed);
            } else if (action.equals(ConfigManager.this.action_orientation)) {
                String orientation = intent.getExtras().getString("key_camera_orientation");
                ConfigManager.this.eventListener.onUpdateOrientation(orientation);
            } else if (action.equals(ConfigManager.action_on_detector_id)) {
                Bundle extras2 = intent.getExtras();
                if (extras2 != null) {
                    String detectorId = extras2.getString("key_adm_detector_id");
                    Log.d((String)TAG, (String)("new detectorId: " + detectorId));
                    ConfigManager.this.registerReceiver(detectorId);
                    ConfigManager.this.eventListener.onDetectorId(detectorId);
                }
            } else if (action.equals(ConfigManager.action_detector_webhook) && (extras = intent.getExtras()) != null && (data = extras.getString("webhook")) != null) {
                Log.d((String)TAG, (String)("onDetectorData: " + data));
                ConfigManager.this.eventListener.onDetectorData(data);
            }
        }
    };

    public ConfigManager(Context ctx, OnDetectorActionListener listener) {
        this.ctx = ctx;
        this.eventListener = listener;
        this.registerReceiver("");
        this.getDetectorId();
    }

    public void getDetectorId() {
        Intent intent = new Intent(action_get_detector_id);
        this.ctx.sendBroadcast(intent);
    }

    private void registerReceiver(String detectorId) {
        this.action_name = "ACTION" + detectorId + "NAME";
        this.action_url = "ACTION" + detectorId + "URL";
        this.action_enable = "ACTION" + detectorId + "ENABLE";
        this.action_start = "ACTION" + detectorId + "SERVICE_START";
        this.action_stop = "ACTION" + detectorId + "SERVICE_STOP";
        this.action_request_config_details = "ACTION" + detectorId + "REQUEST_DETAILS";
        this.action_update_config_details = "ACTION" + detectorId + "CONFIG_DETAILS";
        this.action_request_preview = "ACTION" + detectorId + "REQUEST_PREVIEW";
        this.action_update_preview = "ACTION" + detectorId + "UPDATE_PREVIEW";
        this.action_orientation = "ACTION" + detectorId + "ORIENTATION";
        this.action_orientation_status = "ACTION" + detectorId + "ORIENTATION_STATUS";
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(this.action_name);
        intentFilter.addAction(this.action_url);
        intentFilter.addAction(this.action_enable);
        intentFilter.addAction(this.action_start);
        intentFilter.addAction(this.action_stop);
        intentFilter.addAction(this.action_request_config_details);
        intentFilter.addAction(this.action_update_config_details);
        intentFilter.addAction(this.action_request_preview);
        intentFilter.addAction(this.action_update_preview);
        intentFilter.addAction(this.action_orientation);
        intentFilter.addAction(this.action_orientation_status);
        intentFilter.addAction(action_get_detector_id);
        intentFilter.addAction(action_on_detector_id);
        this.ctx.registerReceiver(this.mReceiver, intentFilter);
    }

    public void setCameraName(String name) {
        Intent intent = new Intent(this.action_name);
        intent.putExtra("key_camera_name", name);
        this.ctx.sendBroadcast(intent);
    }

    public void setCameraUrl(String url) {
        Intent intent = new Intent(this.action_url);
        intent.putExtra("key_camera_url", url);
        this.ctx.sendBroadcast(intent);
    }

    public void setServiceEnable(boolean enable) {
        Intent intent = new Intent(this.action_enable);
        intent.putExtra("key_camera_enable", enable);
        intent.addFlags(32);
        this.ctx.sendBroadcast(intent);
    }

    public void setServiceStart() {
        Intent intent = new Intent(this.action_start);
        this.ctx.sendBroadcast(intent);
    }

    public void setServiceStop(String message) {
        Intent intent = new Intent(this.action_stop);
        intent.putExtra("key_camera_service_msg", message);
        this.ctx.sendBroadcast(intent);
    }

    public void requestConfigDetails() {
        Intent intent = new Intent(this.action_request_config_details);
        this.ctx.sendBroadcast(intent);
    }

    public void updateConfigDetails(ConfigParameters params) {
        Intent intent = new Intent(this.action_update_config_details);
        intent.putExtra("key_camera_name", params.name);
        intent.putExtra("key_camera_url", params.url);
        intent.putExtra("key_camera_orientation", params.orientation);
        intent.putExtra("key_camera_orientation_allowed", params.isOrientationChangeAllowed);
        intent.putExtra("key_camera_enable", params.isDetectionRunning);
        this.ctx.sendBroadcast(intent);
    }

    public void requestCameraPreview() {
        Intent intent = new Intent(this.action_request_preview);
        this.ctx.sendBroadcast(intent);
    }

    public void updateCameraPreview(byte[] preview) {
        Intent intent = new Intent(this.action_update_preview);
        intent.putExtra("key_camera_preview", preview);
        this.ctx.sendBroadcast(intent);
    }

    public void setOrientationAllowed(boolean status) {
        Intent intent = new Intent(this.action_orientation_status);
        intent.putExtra("key_camera_orientation_allowed", status);
        this.ctx.sendBroadcast(intent);
    }

    public void setOrientation(String orientation) {
        Intent intent = new Intent(this.action_orientation);
        intent.putExtra("key_camera_orientation", orientation);
        this.ctx.sendBroadcast(intent);
    }

    public void unregister() {
        this.ctx.unregisterReceiver(this.mReceiver);
    }
}

