/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Utils;

import adfactory.player.android.R;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.webkit.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static StateListDrawable loadVectorDrawable(Context context, int n) {
        VectorDrawableCompat vectorDrawableCompat = VectorDrawableCompat.create((Resources)context.getResources(), (int)n, (Resources.Theme)context.getTheme());
        Drawable drawable = vectorDrawableCompat.getConstantState().newDrawable().mutate();
        DrawableCompat.setTint((Drawable)drawable, (int)ContextCompat.getColor((Context)context, (int)R.color.adfactory_controllers_focus_color));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842908, -16842919}, (Drawable)vectorDrawableCompat);
        stateListDrawable.addState(new int[]{16842908, 16842919}, drawable);
        stateListDrawable.addState(new int[]{-16842908, 16842919}, drawable);
        stateListDrawable.addState(new int[0], (Drawable)vectorDrawableCompat);
        return stateListDrawable;
    }

    public static String getApiKey(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            return bundle.getString("com.adfactory.key");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String milliSecondsToTimer(long l) {
        String string = "";
        String string2 = "";
        int n = (int)(l / 3600000L);
        int n2 = (int)(l % 3600000L) / 60000;
        int n3 = (int)(l % 3600000L % 60000L / 1000L);
        if (n > 0) {
            string = n + ":";
        }
        string2 = n3 < 10 ? "0" + n3 : "" + n3;
        string = string + n2 + ":" + string2;
        return string;
    }

    public static String extractVideoId(String string) {
        String string2 = "";
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        Uri uri = Uri.parse((String)string);
        string2 = uri.getLastPathSegment();
        return string2;
    }

    public static String extractVideoUrl(String string) {
        Pattern pattern = Pattern.compile("src=\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(string);
        String string2 = "";
        while (matcher.find()) {
            Log.e((String)"Find", (String)matcher.group(1));
            string2 = matcher.group(1);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string2 = Utils.addMissingHttp(string2);
        }
        return string2;
    }

    public static String addMissingHttp(String string) {
        if (!string.startsWith("http")) {
            if (string.startsWith("//")) {
                return String.format("http:%s", string);
            }
            return String.format("http://%s", string);
        }
        return string;
    }

    public static int getThemeAccentColor(Context context) {
        int n = Build.VERSION.SDK_INT >= 21 ? 16843829 : context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(n, typedValue, true);
        return typedValue.data;
    }

    public static String getDomainName(String string) {
        if (!URLUtil.isHttpUrl((String)string) && !URLUtil.isHttpsUrl((String)string)) {
            return "";
        }
        URI uRI = null;
        try {
            uRI = new URI(string);
            String string2 = uRI.getHost();
            string2 = string2.toLowerCase();
            string2 = string2.startsWith("www.") ? string2.substring(4) : string2;
            int n = string2.lastIndexOf(46) > -1 ? string2.lastIndexOf(46) : string2.length();
            string2 = string2.substring(0, n);
            String[] stringArray = string2.split("\\.");
            if (stringArray.length > 0) {
                return stringArray[stringArray.length - 1];
            }
            return stringArray[0];
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }
}

