/*
 * Decompiled with CFR 0.152.
 */
package adfactory.player.android.Utils;

import android.app.Activity;
import android.content.Context;
import android.media.MediaPlayer;
import android.os.Build;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.VideoView;

public class Html5WebVideoView
extends WebView {
    private WebSettings mWebSettings;
    private WebChromeClient mChromeClient;
    private VideoView mCustomVideoView;
    private WebChromeClient.CustomViewCallback mViewCallback;
    private FrameLayout mVideoLayout;
    private boolean mIsFullscreen = false;
    private FrameLayout mRootLayout;
    private boolean mAllowAutomaticNativeFullscreen = false;
    private boolean mAutoPlay = false;

    public Html5WebVideoView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    public Html5WebVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public Html5WebVideoView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mRootLayout = (FrameLayout)((Activity)this.getContext()).getWindow().getDecorView();
        this.mWebSettings = this.getSettings();
        this.mWebSettings = this.getSettings();
        this.mWebSettings.setJavaScriptEnabled(true);
        this.mWebSettings.setPluginState(WebSettings.PluginState.ON);
        this.mWebSettings.setJavaScriptCanOpenWindowsAutomatically(false);
        this.mWebSettings.setSupportMultipleWindows(false);
        this.mWebSettings.setSupportZoom(false);
        this.mWebSettings.setLoadWithOverviewMode(true);
        if (Build.VERSION.SDK_INT >= 17) {
            this.mWebSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setInitialScale(0);
        this.setWebChromeClient(new WebChromeClient());
        this.mChromeClient = new WebChromeClient(){

            public View getVideoLoadingProgressView() {
                ProgressBar progressBar = new ProgressBar(Html5WebVideoView.this.getContext());
                progressBar.setIndeterminate(true);
                return progressBar;
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
                super.onShowCustomView(view, customViewCallback);
                ((Activity)Html5WebVideoView.this.getContext()).setVolumeControlStream(3);
                Html5WebVideoView.this.mIsFullscreen = true;
                Html5WebVideoView.this.mViewCallback = customViewCallback;
                if (view instanceof FrameLayout) {
                    FrameLayout frameLayout = (FrameLayout)view;
                    if (frameLayout.getFocusedChild() instanceof VideoView) {
                        VideoView videoView = (VideoView)frameLayout.getFocusedChild();
                        frameLayout.removeView((View)videoView);
                        Html5WebVideoView.this.setupVideoLayout((View)videoView);
                        Html5WebVideoView.this.mCustomVideoView = videoView;
                        Html5WebVideoView.this.mCustomVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                            public void onCompletion(MediaPlayer mediaPlayer) {
                                Html5WebVideoView.this.hideVideoView();
                            }
                        });
                    } else {
                        Html5WebVideoView.this.setupVideoLayout(view);
                    }
                }
            }

            public void onShowCustomView(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
                this.onShowCustomView(view, customViewCallback);
            }

            public void onHideCustomView() {
                Html5WebVideoView.this.hideVideoView();
            }
        };
        this.setWebChromeClient(this.mChromeClient);
    }

    private void callPlayerMethod(String string) {
        this.loadUrl("javascript:player.api(\"" + string + "\")");
    }

    public void setVideoUrl(String string) {
        this.loadUrl(string);
    }

    public void hideVideoView() {
        if (this.isFullscreen()) {
            if (this.mCustomVideoView != null) {
                this.mCustomVideoView.stopPlayback();
            }
            this.mRootLayout.removeView((View)this.mVideoLayout);
            this.mViewCallback.onCustomViewHidden();
            ((Activity)this.getContext()).setVolumeControlStream(Integer.MIN_VALUE);
            this.mIsFullscreen = false;
        }
    }

    private void setupVideoLayout(View view) {
        this.mVideoLayout = new FrameLayout(this.getContext()){

            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 4 && keyEvent.getAction() == 1) {
                    Html5WebVideoView.this.hideVideoView();
                    return true;
                }
                return super.dispatchKeyEvent(keyEvent);
            }
        };
        if (Build.VERSION.SDK_INT >= 14) {
            int n = 6;
            this.mVideoLayout.setSystemUiVisibility(n);
        }
        this.mVideoLayout.setBackgroundResource(17170444);
        this.mVideoLayout.addView(view);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        this.mRootLayout.addView((View)this.mVideoLayout, (ViewGroup.LayoutParams)layoutParams);
        this.mIsFullscreen = true;
    }

    public boolean isFullscreen() {
        return this.mIsFullscreen;
    }

    public void handleBackPress(Activity activity) {
        if (this.isFullscreen()) {
            this.hideVideoView();
        } else {
            this.loadUrl("");
            activity.finish();
        }
    }

    public void setAllowAutomaticNativeFullscreen(boolean bl) {
        this.mAllowAutomaticNativeFullscreen = bl;
    }

    public boolean isAutoPlaying() {
        return this.mAutoPlay;
    }

    public void setAutoPlay(boolean bl) {
        this.mAutoPlay = bl;
    }
}

