package adfactory.player.android.interfaces;

import android.media.MediaPlayer;

/**
 * Created by medyo on 8/23/16.
 */
public interface IVideoPlayer {

    public interface IPlayerCallback {

        /**
         * Called when the current video starts playing from the beginning.
         */
        void onPlay();

        /**
         * Called when the current video has completed playback to the end of the video.
         */
        void onCompleted();

        /**
         * Called when an error occurs during video playback.
         */
        void onError(MediaPlayer mp, int what, int extra);

        /**
         * Called when the video is paused.
         */
        void onPause();

        /**
         * Called when the video is resumed.
         */
        void onResume();

        /**
         * Called when the video is prepared
         */
        void onPrepare(MediaPlayer mediaPlayer);
    }

    /**
     * Play the currently loaded video from its current position.
     */
    void play();

    /**
     * Pause the currently loaded video.
     */
    void pause();

    /**
     * Get the playback progress state (milliseconds) of the current video.
     */
    int getCurrentPosition();

    /**
     * Progress the currently loaded video to the given position (milliseconds).
     */
    void seekTo(int videoPosition);

    /**
     * Get the total length of the currently loaded video in milliseconds.
     */
    int getDuration();

    /**
     * Stop playing the currently loaded video.
     */
    void stopPlayback();

    /**
     * Set the URL or path of the video to play.
     */
    void setVideoPath(String videoUrl);

    /**
     * Provide the player with a callback for major video events (pause, complete, resume, etc).
     */
    void addPlayerCallback(IPlayerCallback callback);
}
